/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client.pages;

import mantle.client.pages.BookPage;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.HarvestLevels;

public class MaterialPage
extends BookPage {
    String title;
    ItemStack[] icons;
    String iconText;
    ToolMaterial material;

    public void readPageFromXML(Element element) {
        NodeList nodes = element.getElementsByTagName("title");
        if (nodes != null) {
            this.title = nodes.item(0).getTextContent();
        }
        this.icons = new ItemStack[4];
        nodes = element.getElementsByTagName("text");
        if (nodes != null) {
            this.iconText = nodes.item(0).getTextContent();
        }
        if ((nodes = element.getElementsByTagName("icon")) != null) {
            this.icons[0] = MantleClientRegistry.getManualIcon((String)nodes.item(0).getTextContent());
        }
        this.material = (nodes = element.getElementsByTagName("toolmaterial")) != null && nodes.getLength() > 0 ? TConstructRegistry.getMaterial(nodes.item(0).getTextContent()) : TConstructRegistry.getMaterial(this.title);
        nodes = element.getElementsByTagName("material").item(0).getChildNodes();
        this.icons[1] = MantleClientRegistry.getManualIcon((String)nodes.item(1).getTextContent());
        this.icons[2] = PatternBuilder.instance.getShardFromSet(this.material.name());
        this.icons[3] = PatternBuilder.instance.getRodFromSet(this.material.name());
    }

    public void renderContentLayer(int localWidth, int localHeight, boolean isTranslatable) {
        String heart;
        String mat = StatCollector.translateToLocal((String)"manual.page.material.material");
        String shard = StatCollector.translateToLocal((String)"manual.page.material.shard");
        String rod = StatCollector.translateToLocal((String)"manual.page.material.rod");
        String durability = StatCollector.translateToLocal((String)"manual.page.material.durability");
        String handleModifier = StatCollector.translateToLocal((String)"manual.page.material.handle");
        String fullToolDurability = StatCollector.translateToLocal((String)"manual.page.material1");
        String miningSpeed = StatCollector.translateToLocal((String)"manual.page.material.speed");
        String miningLevel = StatCollector.translateToLocal((String)"manual.page.material.level");
        String baseAttack = StatCollector.translateToLocal((String)"manual.page.material.attack");
        String heart_ = StatCollector.translateToLocal((String)"manual.page.material2");
        String hearts = StatCollector.translateToLocal((String)"manual.page.material3");
        String materialTrait = StatCollector.translateToLocal((String)"manual.page.material4");
        String extraMod = StatCollector.translateToLocal((String)"manual.page.material5");
        String traitReinforced = StatCollector.translateToLocal((String)"manual.page.material6");
        String reinforcedLevel = StatCollector.translateToLocal((String)"manual.page.material7");
        String stoneboundLevel = StatCollector.translateToLocal((String)"manual.page.material8");
        String splinteringLevel = StatCollector.translateToLocal((String)"manual.page.material9");
        if (isTranslatable) {
            this.title = StatCollector.translateToLocal((String)this.title);
            this.iconText = StatCollector.translateToLocal((String)this.iconText);
            mat = StatCollector.translateToLocal((String)mat);
            shard = StatCollector.translateToLocal((String)shard);
            rod = StatCollector.translateToLocal((String)rod);
            durability = StatCollector.translateToLocal((String)durability);
            handleModifier = StatCollector.translateToLocal((String)handleModifier);
            fullToolDurability = StatCollector.translateToLocal((String)fullToolDurability);
            miningSpeed = StatCollector.translateToLocal((String)miningSpeed);
            miningLevel = StatCollector.translateToLocal((String)miningLevel);
            baseAttack = StatCollector.translateToLocal((String)baseAttack);
            heart_ = StatCollector.translateToLocal((String)heart_);
            hearts = StatCollector.translateToLocal((String)hearts);
            materialTrait = StatCollector.translateToLocal((String)materialTrait);
            extraMod = StatCollector.translateToLocal((String)extraMod);
            traitReinforced = StatCollector.translateToLocal((String)traitReinforced);
            reinforcedLevel = StatCollector.translateToLocal((String)reinforcedLevel);
            stoneboundLevel = StatCollector.translateToLocal((String)stoneboundLevel);
            splinteringLevel = StatCollector.translateToLocal((String)splinteringLevel);
        }
        this.manual.fonts.drawString("\u00a7n" + this.title, localWidth + 70, localHeight + 4, 0);
        this.manual.fonts.drawSplitString(this.iconText, localWidth, localHeight + 16, 178, 0);
        this.manual.fonts.drawString(mat + ": ", localWidth + 108, localHeight + 40, 0);
        this.manual.fonts.drawString(shard + ": ", localWidth + 108, localHeight + 72, 0);
        this.manual.fonts.drawString(rod + ": ", localWidth + 108, localHeight + 104, 0);
        GL11.glEnable((int)32826);
        RenderHelper.enableGUIStandardItemLighting();
        this.manual.renderitem.zLevel = 100.0f;
        this.manual.renderitem.renderItemAndEffectIntoGUI(this.manual.fonts, this.manual.getMC().renderEngine, this.icons[1], localWidth + 108, localHeight + 50);
        this.manual.renderitem.renderItemAndEffectIntoGUI(this.manual.fonts, this.manual.getMC().renderEngine, this.icons[2], localWidth + 108, localHeight + 82);
        this.manual.renderitem.renderItemAndEffectIntoGUI(this.manual.fonts, this.manual.getMC().renderEngine, this.icons[3], localWidth + 108, localHeight + 114);
        this.manual.renderitem.zLevel = 0.0f;
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)32826);
        String icon = this.icons[1].getTooltip((EntityPlayer)this.manual.getMC().thePlayer, false).get(0).toString();
        if (isTranslatable) {
            icon = StatCollector.translateToLocal((String)icon);
        }
        int iconOffset = icon.length() > 12 ? 0 : 3;
        this.manual.fonts.drawSplitString(icon, localWidth + 128, localHeight + 50 + iconOffset, 52, 0);
        if (this.icons[2] != null) {
            icon = this.icons[2].getTooltip((EntityPlayer)this.manual.getMC().thePlayer, false).get(0).toString();
            if (isTranslatable) {
                icon = StatCollector.translateToLocal((String)icon);
            }
            iconOffset = icon.length() > 12 ? 0 : 3;
            this.manual.fonts.drawSplitString(this.icons[2].getTooltip((EntityPlayer)this.manual.getMC().thePlayer, false).get(0).toString(), localWidth + 128, localHeight + 82 + iconOffset, 52, 0);
        }
        if (this.icons[3] != null) {
            icon = this.icons[3].getTooltip((EntityPlayer)this.manual.getMC().thePlayer, false).get(0).toString();
            if (isTranslatable) {
                icon = StatCollector.translateToLocal((String)icon);
            }
            iconOffset = icon.length() > 12 ? 0 : 3;
            this.manual.fonts.drawSplitString(this.icons[3].getTooltip((EntityPlayer)this.manual.getMC().thePlayer, false).get(0).toString(), localWidth + 128, localHeight + 114 + iconOffset, 52, 0);
        }
        this.manual.fonts.drawString(durability + ": " + this.material.durability(), localWidth, localHeight + 40, 0);
        this.manual.fonts.drawString(handleModifier + ": " + this.material.handleDurability() + "x", localWidth, localHeight + 50, 0);
        this.manual.fonts.drawString(fullToolDurability + ": " + (int)((float)this.material.durability() * this.material.handleDurability()), localWidth, localHeight + 60, 0);
        this.manual.fonts.drawString(miningSpeed + ": " + (float)this.material.toolSpeed() / 100.0f, localWidth, localHeight + 80, 0);
        this.manual.fonts.drawString(miningLevel + ": " + this.material.harvestLevel() + " (" + HarvestLevels.getHarvestLevelName(this.material.harvestLevel()) + ")", localWidth, localHeight + 90, 0);
        int attack = this.material.attack();
        String string = heart = attack == 2 ? " " + heart_ : " " + hearts;
        if (attack % 2 == 0) {
            this.manual.fonts.drawString(baseAttack + ": " + this.material.attack() / 2 + heart, localWidth, localHeight + 100, 0);
        } else {
            this.manual.fonts.drawString(baseAttack + ": " + (float)this.material.attack() / 2.0f + heart, localWidth, localHeight + 100, 0);
        }
        int offset = 0;
        String ability = this.material.ability();
        if (!ability.equals("")) {
            this.manual.fonts.drawString(materialTrait + ": " + ability, localWidth, localHeight + 120 + 10 * offset, 0);
            ++offset;
            if (this.material.name().equals("Paper") || this.material.name().equals("Thaumium")) {
                this.manual.fonts.drawString(extraMod, localWidth, localHeight + 120 + 10 * offset, 0);
            }
        }
        if (this.material.reinforced() > 0) {
            this.manual.fonts.drawString(traitReinforced, localWidth, localHeight + 120 + 10 * offset, 0);
            this.manual.fonts.drawString(reinforcedLevel + ": " + this.material.reinforced(), localWidth, localHeight + 120 + 10 * ++offset, 0);
            ++offset;
        }
        if (this.material.shoddy() > 0.0f) {
            this.manual.fonts.drawString(stoneboundLevel + ": " + this.material.shoddy(), localWidth, localHeight + 120 + 10 * offset, 0);
            ++offset;
        } else if (this.material.shoddy() < 0.0f) {
            this.manual.fonts.drawString(splinteringLevel + ": " + -this.material.shoddy(), localWidth, localHeight + 120 + 10 * offset, 0);
            ++offset;
        }
    }
}

