/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.weaponry.TinkerWeaponry;

@Deprecated
public class Arrow
extends ToolCore {
    public Arrow() {
        super(3);
        this.setUnlocalizedName("InfiTool.Arrow");
        this.setMaxStackSize(64);
        this.setMaxDamage(0);
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_arrow_head";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "_arrow_shaft";
            }
            case 3: {
                return "_arrow_fletching";
            }
        }
        return "";
    }

    @Override
    protected int getDefaultColor(int renderPass, int materialID) {
        CustomMaterial mat;
        if (renderPass == 2 && (mat = TConstructRegistry.getCustomMaterial(materialID, FletchingMaterial.class)) != null) {
            return mat.color;
        }
        return super.getDefaultColor(renderPass, materialID);
    }

    @Override
    public String getEffectSuffix() {
        return "_arrow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "arrow";
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        this.handleStrings.put(index, location[2]);
    }

    @Override
    public void registerAlternatePartPaths(int index, String[] location) {
        this.accessoryStrings.put(index, location[3]);
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.arrowhead;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.fletching;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"ammo"};
    }

    @Override
    public float getDamageModifier() {
        return 0.5f;
    }

    @Override
    public void getSubItems(Item id, CreativeTabs tab, List list) {
        Item accessory = this.getAccessoryItem();
        ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, 0) : null;
        Item extra = this.getExtraItem();
        ItemStack extraStack = extra != null ? new ItemStack(extra, 1, 0) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, 3), new ItemStack(this.getHandleItem(), 1, 0), accessoryStack, extraStack, "");
        if (tool != null) {
            tool.stackSize = 1;
            tool.getTagCompound().getCompoundTag("InfiTool").setBoolean("Built", true);
            list.add(tool);
        }
        accessoryStack = (accessory = this.getAccessoryItem()) != null ? new ItemStack(this.getAccessoryItem(), 1, this.random.nextInt(4)) : null;
        extra = this.getExtraItem();
        extraStack = extra != null ? new ItemStack(extra, 1, 0) : null;
        tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, this.random.nextInt(18)), new ItemStack(this.getHandleItem(), 1, this.random.nextInt(18)), accessoryStack, extraStack, StatCollector.translateToLocal((String)"item.tool.randomarrow"));
        if (tool != null) {
            tool.stackSize = 1;
            tool.getTagCompound().getCompoundTag("InfiTool").setBoolean("Built", true);
            list.add(tool);
        }
        super.getSubItems(id, tab, list);
    }

    @Override
    public void buildTool(int id, String name, List list) {
        Item accessory = this.getAccessoryItem();
        ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, 0) : null;
        Item extra = this.getExtraItem();
        ItemStack extraStack = extra != null ? new ItemStack(this.getExtraItem(), 1, id) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), new ItemStack(this.getHandleItem(), 1, id), accessoryStack, extraStack, name);
        if (tool != null) {
            tool.stackSize = 1;
            tool.getTagCompound().getCompoundTag("InfiTool").setBoolean("Built", true);
            list.add(tool);
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = stack.getTagCompound();
        if (tags.hasKey("Energy")) {
            String color = "";
            int power = tags.getInteger("Energy");
            if (power != 0) {
                color = power <= this.getMaxEnergyStored(stack) / 3 ? "\u00a74" : (power > this.getMaxEnergyStored(stack) * 2 / 3 ? "\u00a72" : "\u00a76");
            }
            String energy = color + tags.getInteger("Energy") + "/" + this.getMaxEnergyStored(stack) + " RF";
            list.add(energy);
        }
        if (tags.hasKey("InfiTool")) {
            boolean broken = tags.getCompoundTag("InfiTool").getBoolean("Broken");
            if (broken) {
                list.add("\u00a7oBroken");
            } else {
                String handleName;
                int head = tags.getCompoundTag("InfiTool").getInteger("Head");
                int handle = tags.getCompoundTag("InfiTool").getInteger("Handle");
                String headName = this.getAbilityNameForType(head, 0);
                if (!headName.equals("")) {
                    list.add(Arrow.getStyleForType(head) + headName);
                }
                if (!(handleName = this.getAbilityNameForType(handle, 0)).equals("") && handle != head) {
                    list.add(Arrow.getStyleForType(handle) + handleName);
                }
                boolean displayToolTips = true;
                int tipNum = 0;
                while (displayToolTips) {
                    String tooltip = "Tooltip" + ++tipNum;
                    if (tags.getCompoundTag("InfiTool").hasKey(tooltip)) {
                        String tipName = tags.getCompoundTag("InfiTool").getString(tooltip);
                        if (tipName.equals("")) continue;
                        list.add(tipName);
                        continue;
                    }
                    displayToolTips = false;
                }
            }
        }
        int attack = (int)((float)tags.getCompoundTag("InfiTool").getInteger("Attack") * this.getDamageModifier());
        list.add("\u00a79+" + attack + " " + StatCollector.translateToLocalFormatted((String)"attribute.name.generic.attackDamage", (Object[])new Object[0]));
        list.add("\u00a79+" + tags.getCompoundTag("InfiTool").getInteger("Attack") + " " + StatCollector.translateToLocalFormatted((String)"attribute.name.ammo.attackDamage", (Object[])new Object[0]));
    }
}

