/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.tools.Weapon;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.logic.EquipLogic;

public class BattleSign
extends Weapon {
    public BattleSign() {
        super(1);
        this.setUnlocalizedName("InfiTool.Battlesign");
    }

    @Override
    public String getToolName() {
        return "Battlesign";
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.signHead;
    }

    @Override
    public Item getAccessoryItem() {
        return null;
    }

    @Override
    public int getPartAmount() {
        return 2;
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        this.brokenPartStrings.put(index, location[1]);
        this.handleStrings.put(index, location[2]);
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_battlesign_head";
            }
            case 1: {
                return "_battlesign_head_broken";
            }
            case 2: {
                return "_battlesign_handle";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_battlesign_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "battlesign";
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        if (side == 0 || !player.isSneaking()) {
            return false;
        }
        if (!world.getBlock(x, y, z).getMaterial().isSolid()) {
            return false;
        }
        if (side == 1) {
            ++y;
        }
        if (side == 2) {
            --z;
        }
        if (side == 3) {
            ++z;
        }
        if (side == 4) {
            --x;
        }
        if (side == 5) {
            ++x;
        }
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        if (!TinkerTools.battlesignBlock.canPlaceBlockAt(world, x, y, z)) {
            return false;
        }
        world.setBlock(x, y, z, TinkerTools.battlesignBlock, 0, 3);
        TinkerTools.battlesignBlock.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
        EquipLogic logic = (EquipLogic)world.getTileEntity(x, y, z);
        logic.setEquipmentItem(stack);
        --stack.stackSize;
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            player.openGui((Object)TConstruct.instance, 12, world, x, y, z);
        }
        return true;
    }
}

