/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.entity.ArrowEntity;
import tconstruct.util.config.PHConstruct;

@Deprecated
public abstract class BowBase
extends ToolCore {
    public IIcon arrow1;
    public IIcon arrow2;
    public IIcon arrow3;
    public HashMap<Integer, IIcon> headIcons1 = new HashMap();
    public HashMap<Integer, IIcon> handleIcons1 = new HashMap();
    public HashMap<Integer, IIcon> accessoryIcons1 = new HashMap();
    public HashMap<Integer, IIcon> extraIcons1 = new HashMap();
    public HashMap<Integer, IIcon> effectIcons1 = new HashMap();
    public HashMap<Integer, IIcon> headIcons2 = new HashMap();
    public HashMap<Integer, IIcon> handleIcons2 = new HashMap();
    public HashMap<Integer, IIcon> accessoryIcons2 = new HashMap();
    public HashMap<Integer, IIcon> extraIcons2 = new HashMap();
    public HashMap<Integer, IIcon> effectIcons2 = new HashMap();
    public HashMap<Integer, IIcon> headIcons3 = new HashMap();
    public HashMap<Integer, IIcon> handleIcons3 = new HashMap();
    public HashMap<Integer, IIcon> accessoryIcons3 = new HashMap();
    public HashMap<Integer, IIcon> extraIcons3 = new HashMap();
    public HashMap<Integer, IIcon> effectIcons3 = new HashMap();

    public BowBase() {
        super(0);
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int useRemaining) {
        int time = this.getMaxItemUseDuration(stack) - useRemaining;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, time);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        time = event.charge;
        boolean creative = player.capabilities.isCreativeMode || EnchantmentHelper.getEnchantmentLevel((int)Enchantment.infinity.effectId, (ItemStack)stack) > 0;
        int slotID = this.getInventorySlotContainItem(TinkerTools.arrow, player.inventory);
        int arrowID = this.getInventorySlotContainItem(Items.arrow, player.inventory);
        boolean arrowState = false;
        ItemStack tinkerArrow = null;
        if (slotID != -1) {
            tinkerArrow = player.inventory.getStackInSlot(slotID);
        }
        if (creative || tinkerArrow != null || arrowID != -1) {
            int var9;
            NBTTagCompound toolTag = stack.getTagCompound().getCompoundTag("InfiTool");
            float drawTime = toolTag.getInteger("DrawSpeed");
            float flightSpeed = toolTag.getFloat("FlightSpeed");
            float speedBase = (float)time / drawTime;
            if ((double)(speedBase = (speedBase * speedBase + speedBase * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (speedBase > flightSpeed) {
                speedBase = flightSpeed;
            }
            EntityArrow arrowEntity = null;
            if (slotID != -1 && (arrowID == -1 || slotID < arrowID)) {
                ItemStack arrowStack = tinkerArrow.copy();
                arrowStack.stackSize = 1;
                arrowEntity = new ArrowEntity(world, (EntityLivingBase)player, speedBase * 2.0f, arrowStack);
            } else {
                arrowEntity = new EntityArrow(world, (EntityLivingBase)player, speedBase * 2.0f);
            }
            if (speedBase >= 1.0f) {
                arrowEntity.setIsCritical(true);
            }
            if ((var9 = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)stack)) > 0) {
                arrowEntity.setDamage(arrowEntity.getDamage() + (double)var9 * 0.5 + 0.5);
            }
            int var10 = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)stack);
            if (slotID != -1 && (arrowID == -1 || slotID < arrowID)) {
                ((ArrowEntity)arrowEntity).setKnockbackModStrength(toolTag.getFloat("Knockback"));
            }
            if (var10 > 0) {
                arrowEntity.setKnockbackStrength(var10);
            }
            if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)stack) > 0) {
                arrowEntity.setFire(100);
            }
            int reinforced = 0;
            if (toolTag.hasKey("Unbreaking")) {
                reinforced = toolTag.getInteger("Unbreaking");
            }
            if (this.random.nextInt(10) < 10 - reinforced) {
                AbilityHelper.damageTool(stack, 1, (EntityLivingBase)player, false);
            }
            world.playSoundAtEntity((Entity)player, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + speedBase * 0.5f);
            if (creative) {
                arrowEntity.canBePickedUp = 2;
            } else if (slotID != -1 && (arrowID == -1 || slotID < arrowID)) {
                player.inventory.consumeInventoryItem((Item)TinkerTools.arrow);
            } else {
                player.inventory.consumeInventoryItem(Items.arrow);
            }
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)arrowEntity);
            }
        }
    }

    int getInventorySlotContainItem(Item item, InventoryPlayer inventory) {
        for (int j = 0; j < inventory.mainInventory.length; ++j) {
            if (inventory.mainInventory[j] == null || inventory.mainInventory[j].getItem() != item) continue;
            return j;
        }
        return -1;
    }

    public ItemStack onFoodEaten(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
        return stack;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World par2World, EntityPlayer player) {
        NBTTagCompound toolTag;
        if (stack.hasTagCompound() && !(toolTag = stack.getTagCompound().getCompoundTag("InfiTool")).getBoolean("Broken")) {
            ArrowNockEvent event = new ArrowNockEvent(player, stack);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return event.result;
            }
            if (player.capabilities.isCreativeMode || player.inventory.hasItemStack(new ItemStack(Items.arrow)) || player.inventory.hasItemStack(new ItemStack((Item)TinkerTools.arrow))) {
                player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
            }
        }
        return stack;
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        super.registerIcons(iconRegister);
        if (PHConstruct.minimalTextures) {
            this.headIcons1.clear();
            this.headIcons1.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(0) + "_1"));
            this.handleIcons1.clear();
            this.handleIcons1.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(2) + "_1"));
            this.accessoryIcons1.clear();
            this.accessoryIcons1.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(3) + "_1"));
            this.headIcons2.clear();
            this.headIcons2.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(0) + "_2"));
            this.handleIcons2.clear();
            this.handleIcons2.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(2) + "_2"));
            this.accessoryIcons2.clear();
            this.accessoryIcons2.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(3) + "_2"));
            this.headIcons3.clear();
            this.headIcons3.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(0) + "_3"));
            this.handleIcons3.clear();
            this.handleIcons3.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(2) + "_3"));
            this.accessoryIcons3.clear();
            this.accessoryIcons3.put(-1, iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/" + this.getIconSuffix(3) + "_3"));
            this.effectIcons1.clear();
            this.effectIcons2.clear();
            this.effectIcons3.clear();
            for (Map.Entry entry : this.effectStrings.entrySet()) {
                this.effectIcons.put(entry.getKey(), iconRegister.registerIcon((String)entry.getValue()));
                this.effectIcons1.put((Integer)entry.getKey(), iconRegister.registerIcon((String)entry.getValue() + "_1"));
                this.effectIcons2.put((Integer)entry.getKey(), iconRegister.registerIcon((String)entry.getValue() + "_2"));
                this.effectIcons3.put((Integer)entry.getKey(), iconRegister.registerIcon((String)entry.getValue() + "_3"));
            }
        } else {
            this.headIcons1.clear();
            this.handleIcons1.clear();
            this.accessoryIcons1.clear();
            this.extraIcons1.clear();
            this.effectIcons1.clear();
            for (Map.Entry pairs : this.headStrings.entrySet()) {
                this.headIcons1.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_1"));
            }
            for (Map.Entry pairs : this.handleStrings.entrySet()) {
                this.handleIcons1.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_1"));
            }
            if (this.getPartAmount() > 2) {
                for (Map.Entry pairs : this.accessoryStrings.entrySet()) {
                    this.accessoryIcons1.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_1"));
                }
            }
            if (this.getPartAmount() > 3) {
                for (Map.Entry pairs : this.extraStrings.entrySet()) {
                    this.extraIcons1.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_1"));
                }
            }
            for (Map.Entry pairs : this.effectStrings.entrySet()) {
                this.effectIcons1.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_1"));
            }
            this.headIcons2.clear();
            this.handleIcons2.clear();
            this.accessoryIcons2.clear();
            this.extraIcons2.clear();
            this.effectIcons2.clear();
            for (Map.Entry pairs : this.headStrings.entrySet()) {
                this.headIcons2.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_2"));
            }
            for (Map.Entry pairs : this.handleStrings.entrySet()) {
                this.handleIcons2.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_2"));
            }
            if (this.getPartAmount() > 2) {
                for (Map.Entry pairs : this.accessoryStrings.entrySet()) {
                    this.accessoryIcons2.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_2"));
                }
            }
            if (this.getPartAmount() > 3) {
                for (Map.Entry pairs : this.extraStrings.entrySet()) {
                    this.extraIcons2.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_2"));
                }
            }
            for (Map.Entry pairs : this.effectStrings.entrySet()) {
                this.effectIcons2.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_2"));
            }
            this.headIcons3.clear();
            this.handleIcons3.clear();
            this.accessoryIcons3.clear();
            this.extraIcons3.clear();
            this.effectIcons3.clear();
            for (Map.Entry pairs : this.headStrings.entrySet()) {
                this.headIcons3.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_3"));
            }
            for (Map.Entry pairs : this.handleStrings.entrySet()) {
                this.handleIcons3.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_3"));
            }
            if (this.getPartAmount() > 2) {
                for (Map.Entry pairs : this.accessoryStrings.entrySet()) {
                    this.accessoryIcons3.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_3"));
                }
            }
            if (this.getPartAmount() > 3) {
                for (Map.Entry pairs : this.extraStrings.entrySet()) {
                    this.extraIcons3.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_3"));
                }
            }
            for (Map.Entry pairs : this.effectStrings.entrySet()) {
                this.effectIcons3.put((Integer)pairs.getKey(), iconRegister.registerIcon((String)pairs.getValue() + "_3"));
            }
        }
        this.registerArrows(iconRegister);
    }

    void registerArrows(IIconRegister iconRegister) {
        this.arrow1 = iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/arrow_1");
        this.arrow2 = iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/arrow_2");
        this.arrow3 = iconRegister.registerIcon("tinker:" + this.getDefaultFolder() + "/arrow_3");
    }

    @Override
    public IIcon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags != null) {
            tags = stack.getTagCompound().getCompoundTag("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    if (tags.getBoolean("Broken")) {
                        return this.getCorrectIcon(this.brokenIcons, tags.getInteger("RenderHandle"));
                    }
                    return this.getCorrectIcon(this.handleIcons, tags.getInteger("RenderHandle"));
                }
                if (renderPass == 1) {
                    return this.getCorrectIcon(this.headIcons, tags.getInteger("RenderHead"));
                }
                if (renderPass == 2) {
                    return this.getCorrectIcon(this.accessoryIcons, tags.getInteger("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return this.getCorrectIcon(this.extraIcons, tags.getInteger("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.hasKey("Effect1")) {
                    return this.getCorrectIcon2(this.effectIcons, tags.getInteger("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.hasKey("Effect2")) {
                    return this.getCorrectIcon2(this.effectIcons, tags.getInteger("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.hasKey("Effect3")) {
                    return this.getCorrectIcon2(this.effectIcons, tags.getInteger("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.hasKey("Effect4")) {
                    return this.getCorrectIcon2(this.effectIcons, tags.getInteger("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.hasKey("Effect5")) {
                    return this.getCorrectIcon2(this.effectIcons, tags.getInteger("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5 && tags.hasKey("Effect6")) {
                return this.getCorrectIcon2(this.effectIcons, tags.getInteger("Effect6"));
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    protected IIcon getCorrectIcon2(Map<Integer, IIcon> icons, int id) {
        if (!icons.containsKey(id)) {
            return blankSprite;
        }
        return icons.get(id);
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        if (location.length > 3) {
            this.accessoryStrings.put(index, location[3]);
        }
        if (location.length > 4) {
            this.extraStrings.put(index, location[4]);
        }
    }

    @Override
    public void registerAlternatePartPaths(int index, String[] location) {
        this.brokenPartStrings.put(index, location[1]);
        this.handleStrings.put(index, location[2]);
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int useTime = stack.getMaxItemUseDuration() - useRemaining;
        if (!stack.hasTagCompound()) {
            return emptyIcon;
        }
        NBTTagCompound toolTag = stack.getTagCompound().getCompoundTag("InfiTool");
        int drawTime = toolTag.getInteger("DrawSpeed");
        float flightSpeed = toolTag.getFloat("FlightSpeed");
        drawTime = (int)((float)drawTime * flightSpeed);
        if (usingItem == null) {
            return this.getIcon(stack, renderPass);
        }
        if (useTime >= drawTime - 2) {
            return this.getIcon3(stack, renderPass);
        }
        if (useTime >= drawTime * 2 / 3) {
            return this.getIcon2(stack, renderPass);
        }
        return this.getIcon1(stack, renderPass);
    }

    public IIcon getIcon1(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags != null) {
            tags = stack.getTagCompound().getCompoundTag("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return this.getCorrectIcon(this.handleIcons1, tags.getInteger("RenderHandle"));
                }
                if (renderPass == 1) {
                    return this.getCorrectIcon(this.headIcons1, tags.getInteger("RenderHead"));
                }
                if (renderPass == 2) {
                    return this.getCorrectIcon(this.accessoryIcons1, tags.getInteger("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return this.getCorrectIcon(this.extraIcons1, tags.getInteger("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.hasKey("Effect1")) {
                    return this.getCorrectIcon2(this.effectIcons1, tags.getInteger("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.hasKey("Effect2")) {
                    return this.getCorrectIcon2(this.effectIcons1, tags.getInteger("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.hasKey("Effect3")) {
                    return this.getCorrectIcon2(this.effectIcons1, tags.getInteger("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.hasKey("Effect4")) {
                    return this.getCorrectIcon2(this.effectIcons1, tags.getInteger("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.hasKey("Effect5")) {
                    return this.getCorrectIcon2(this.effectIcons1, tags.getInteger("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5) {
                if (tags.hasKey("Effect6")) {
                    return this.getCorrectIcon2(this.effectIcons1, tags.getInteger("Effect6"));
                }
            } else {
                return this.arrow1;
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    public IIcon getIcon2(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags != null) {
            tags = stack.getTagCompound().getCompoundTag("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return this.getCorrectIcon(this.handleIcons2, tags.getInteger("RenderHandle"));
                }
                if (renderPass == 1) {
                    return this.getCorrectIcon(this.headIcons2, tags.getInteger("RenderHead"));
                }
                if (renderPass == 2) {
                    return this.getCorrectIcon(this.accessoryIcons2, tags.getInteger("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return this.getCorrectIcon(this.extraIcons2, tags.getInteger("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.hasKey("Effect1")) {
                    return this.getCorrectIcon2(this.effectIcons2, tags.getInteger("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.hasKey("Effect2")) {
                    return this.getCorrectIcon2(this.effectIcons2, tags.getInteger("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.hasKey("Effect3")) {
                    return this.getCorrectIcon2(this.effectIcons2, tags.getInteger("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.hasKey("Effect4")) {
                    return this.getCorrectIcon2(this.effectIcons2, tags.getInteger("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.hasKey("Effect5")) {
                    return this.getCorrectIcon2(this.effectIcons2, tags.getInteger("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5) {
                if (tags.hasKey("Effect6")) {
                    return this.getCorrectIcon2(this.effectIcons2, tags.getInteger("Effect6"));
                }
            } else {
                return this.arrow2;
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    public IIcon getIcon3(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags != null) {
            tags = stack.getTagCompound().getCompoundTag("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return this.getCorrectIcon(this.handleIcons3, tags.getInteger("RenderHandle"));
                }
                if (renderPass == 1) {
                    return this.getCorrectIcon(this.headIcons3, tags.getInteger("RenderHead"));
                }
                if (renderPass == 2) {
                    return this.getCorrectIcon(this.accessoryIcons3, tags.getInteger("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return this.getCorrectIcon(this.extraIcons3, tags.getInteger("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.hasKey("Effect1")) {
                    return this.getCorrectIcon2(this.effectIcons3, tags.getInteger("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.hasKey("Effect2")) {
                    return this.getCorrectIcon2(this.effectIcons3, tags.getInteger("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.hasKey("Effect3")) {
                    return this.getCorrectIcon2(this.effectIcons3, tags.getInteger("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.hasKey("Effect4")) {
                    return this.getCorrectIcon2(this.effectIcons3, tags.getInteger("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.hasKey("Effect5")) {
                    return this.getCorrectIcon2(this.effectIcons3, tags.getInteger("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5) {
                if (tags.hasKey("Effect6")) {
                    return this.getCorrectIcon2(this.effectIcons3, tags.getInteger("Effect6"));
                }
            } else {
                return this.arrow3;
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    @Override
    public void buildTool(int id, String name, List list) {
        Item accessory = this.getAccessoryItem();
        ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, id) : null;
        Item extra = this.getExtraItem();
        ItemStack extraStack = extra != null ? new ItemStack(this.getExtraItem(), 1, id) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), new ItemStack(this.getHandleItem(), 1, id), accessoryStack, extraStack, name);
        if (tool == null) {
            return;
        }
        tool.getTagCompound().getCompoundTag("InfiTool").setBoolean("Built", true);
        list.add(tool);
    }
}

