/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class StencilBuilder {
    public static StencilBuilder instance = new StencilBuilder();
    public List<ItemStack> blanks = new LinkedList<ItemStack>();
    public Map<Integer, ItemStack> stencils = new TreeMap<Integer, ItemStack>();

    public static boolean isBlank(ItemStack stack) {
        for (ItemStack blank : StencilBuilder.instance.blanks) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)blank, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static void registerBlankStencil(ItemStack itemStack) {
        StencilBuilder.instance.blanks.add(itemStack);
    }

    public static void registerStencil(int id, Item item, int meta) {
        StencilBuilder.registerStencil(id, new ItemStack(item, 1, meta));
    }

    public static void registerStencil(int id, ItemStack pattern) {
        if (StencilBuilder.instance.stencils.containsKey(id)) {
            throw new IllegalArgumentException("[TCon API] Stencil ID " + id + " is already occupied by " + StencilBuilder.instance.stencils.get(id).getDisplayName());
        }
        StencilBuilder.instance.stencils.put(id, pattern);
    }

    public static Collection<ItemStack> getStencils() {
        return StencilBuilder.instance.stencils.values();
    }

    public static int getId(ItemStack stencil) {
        for (Map.Entry<Integer, ItemStack> entry : StencilBuilder.instance.stencils.entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)stencil, (ItemStack)entry.getValue(), (boolean)false)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static ItemStack getStencil(int num) {
        if (!StencilBuilder.instance.stencils.containsKey(num)) {
            return null;
        }
        return StencilBuilder.instance.stencils.get(num).copy();
    }

    public static int getStencilCount() {
        return StencilBuilder.instance.stencils.size();
    }
}

