/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.modifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.IModifyable;

public abstract class ItemModifier {
    public final String key;
    public final List stacks;
    public final int effectIndex;
    public static Random random = new Random();

    public ItemModifier(ItemStack[] recipe, int effect, String dataKey) {
        ArrayList<ItemStack> itemstacks = new ArrayList<ItemStack>();
        for (int iter = 0; iter < recipe.length; ++iter) {
            itemstacks.add(recipe[iter]);
        }
        this.stacks = itemstacks;
        this.effectIndex = effect;
        this.key = dataKey;
    }

    public boolean matches(ItemStack[] recipe, ItemStack input) {
        if (!this.canModify(input, recipe)) {
            return false;
        }
        ArrayList list = new ArrayList(this.stacks);
        for (int iter = 0; iter < recipe.length; ++iter) {
            ItemStack craftingStack = recipe[iter];
            if (craftingStack == null) continue;
            boolean canCraft = false;
            for (ItemStack removeStack : list) {
                if (craftingStack.getItem() != removeStack.getItem() || removeStack.getItemDamage() != Short.MAX_VALUE && craftingStack.getItemDamage() != removeStack.getItemDamage()) continue;
                canCraft = true;
                list.remove(removeStack);
                break;
            }
            if (canCraft) continue;
            return false;
        }
        return list.isEmpty();
    }

    protected String getTagName(ItemStack stack) {
        return ((IModifyable)stack.getItem()).getBaseTagName();
    }

    protected NBTTagCompound getModifierTag(ItemStack stack) {
        return stack.getTagCompound().getCompoundTag(this.getTagName(stack));
    }

    protected boolean canModify(ItemStack input, ItemStack[] recipe) {
        NBTTagCompound tags = input.getTagCompound().getCompoundTag(this.getTagName(input));
        return tags.getInteger("Modifiers") > 0;
    }

    public abstract void modify(ItemStack[] var1, ItemStack var2);

    public void addMatchingEffect(ItemStack input) {
        NBTTagCompound tags = input.getTagCompound().getCompoundTag(this.getTagName(input));
        if (tags.hasKey("Effect6") || tags.hasKey(this.key)) {
            return;
        }
        if (tags.hasKey("Effect5")) {
            tags.setInteger("Effect6", this.effectIndex);
        } else if (tags.hasKey("Effect4")) {
            tags.setInteger("Effect5", this.effectIndex);
        } else if (tags.hasKey("Effect3")) {
            tags.setInteger("Effect4", this.effectIndex);
        } else if (tags.hasKey("Effect2")) {
            tags.setInteger("Effect3", this.effectIndex);
        } else if (tags.hasKey("Effect1")) {
            tags.setInteger("Effect2", this.effectIndex);
        } else {
            tags.setInteger("Effect1", this.effectIndex);
        }
    }

    protected int addModifierTip(ItemStack input, String modifierTip) {
        String tip;
        NBTTagCompound tags = input.getTagCompound().getCompoundTag(this.getTagName(input));
        int tipNum = 0;
        while (tags.hasKey(tip = "Tooltip" + ++tipNum)) {
        }
        tags.setString(tip, "");
        String modTip = "ModifierTip" + tipNum;
        tags.setString(modTip, modifierTip);
        return tipNum;
    }

    protected int addToolTip(ItemStack input, String tooltip, String modifierTip) {
        String tip;
        String tag;
        NBTTagCompound tags = input.getTagCompound().getCompoundTag(this.getTagName(input));
        int tipNum = 0;
        do {
            if (tags.hasKey(tip = "Tooltip" + ++tipNum)) continue;
            tags.setString(tip, tooltip);
            String modTip = "ModifierTip" + tipNum;
            tags.setString(modTip, modifierTip);
            return tipNum;
        } while (!(tag = tags.getString(tip)).contains(tooltip));
        tags.setString(tip, this.getProperName(tooltip, tag));
        String modTip = "ModifierTip" + tipNum;
        tag = tags.getString(modTip);
        tags.setString(modTip, this.getProperName(modifierTip, tag));
        return tipNum;
    }

    protected String getProperName(String tooltip, String tag) {
        if (tag.isEmpty()) {
            return tooltip + " I";
        }
        if (tag.equals(tooltip) || tag.equals(tooltip + " I")) {
            return tooltip + " II";
        }
        if (tag.equals(tooltip + " II")) {
            return tooltip + " III";
        }
        if (tag.equals(tooltip + " III")) {
            return tooltip + " IV";
        }
        if (tag.equals(tooltip + " IV")) {
            return tooltip + " V";
        }
        if (tag.equals(tooltip + " V")) {
            return tooltip + " VI";
        }
        if (tag.equals(tooltip + " VI")) {
            return tooltip + " VII";
        }
        if (tag.equals(tooltip + " VII")) {
            return tooltip + " VIII";
        }
        if (tag.equals(tooltip + " VIII")) {
            return tooltip + " IX";
        }
        if (tag.equals(tooltip + " IX")) {
            return tooltip + " X";
        }
        return tooltip + " X+";
    }

    public boolean validType(IModifyable input) {
        return input.getModifyType().equals("Tool");
    }

    public boolean areItemsEquivalent(ItemStack stack1, ItemStack stack2) {
        if (stack1.getItem() != stack2.getItem()) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public boolean areItemStacksEquivalent(ItemStack stack1, ItemStack stack2) {
        if (stack1.getItem() != stack2.getItem()) {
            return false;
        }
        if (stack1.getItemDamage() != stack2.getItemDamage()) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public static NBTTagCompound getAttributeTag(String attributeType, String modifierName, double amount, boolean flat, UUID uuid) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("AttributeName", attributeType);
        tag.setString("Name", modifierName);
        tag.setDouble("Amount", amount);
        tag.setInteger("Operation", flat ? 0 : 1);
        tag.setLong("UUIDMost", uuid.getMostSignificantBits());
        tag.setLong("UUIDLeast", uuid.getLeastSignificantBits());
        return tag;
    }
}

