/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import tconstruct.TConstruct;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.PiercingEntityDamage;

public class AbilityHelper {
    public static Random random = new Random();
    public static boolean necroticUHS;
    private static boolean equalityOverrideLoaded;

    public static boolean onBlockChanged(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase player, Random random) {
        if (!stack.hasTagCompound()) {
            return false;
        }
        int reinforced = 0;
        NBTTagCompound tags = stack.getTagCompound();
        if (tags.getCompoundTag("InfiTool").hasKey("Unbreaking")) {
            reinforced = tags.getCompoundTag("InfiTool").getInteger("Unbreaking");
        }
        if (random.nextInt(10) < 10 - reinforced) {
            AbilityHelper.damageTool(stack, 1, tags, player, false);
        }
        return true;
    }

    public static boolean onLeftClickEntity(ItemStack stack, EntityLivingBase player, Entity entity, ToolCore tool) {
        return AbilityHelper.onLeftClickEntity(stack, player, entity, tool, 0);
    }

    public static boolean onLeftClickEntity(ItemStack stack, EntityLivingBase player, Entity entity, ToolCore tool, int baseDamage) {
        if (entity.canAttackWithItem() && stack.hasTagCompound() && !entity.hitByEntity((Entity)player)) {
            NBTTagCompound tags = stack.getTagCompound();
            NBTTagCompound toolTags = stack.getTagCompound().getCompoundTag("InfiTool");
            boolean broken = toolTags.getBoolean("Broken");
            int durability = tags.getCompoundTag("InfiTool").getInteger("Damage");
            float stonebound = tags.getCompoundTag("InfiTool").getFloat("Shoddy");
            float stoneboundDamage = (float)Math.log((float)durability / 72.0f + 1.0f) * -2.0f * stonebound;
            int damage = AbilityHelper.calcDamage((Entity)player, entity, stack, tool, toolTags, baseDamage);
            float knockback = AbilityHelper.calcKnockback((Entity)player, entity, stack, tool, toolTags, baseDamage);
            float enchantDamage = 0.0f;
            if (entity instanceof EntityLivingBase) {
                enchantDamage = EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)entity));
            }
            if (damage > 0 || enchantDamage > 0.0f) {
                boolean criticalHit = player.fallDistance > 0.0f && !player.onGround && !player.isOnLadder() && !player.isInWater() && !player.isPotionActive(Potion.blindness) && player.ridingEntity == null && entity instanceof EntityLivingBase;
                for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                    if (!mod.doesCriticalHit(tool, tags, toolTags, stack, player, entity)) continue;
                    criticalHit = true;
                }
                if (criticalHit) {
                    damage += random.nextInt(damage / 2 + 2);
                }
                damage = (int)((float)damage + enchantDamage);
                if (tool.getDamageModifier() != 1.0f) {
                    damage = (int)((float)damage * tool.getDamageModifier());
                }
                if (broken) {
                    damage = baseDamage > 0 ? baseDamage : 1;
                }
                boolean causedDamage = false;
                boolean isAlive = entity.isEntityAlive();
                causedDamage = tool.pierceArmor() && !broken ? (player instanceof EntityPlayer ? entity.attackEntityFrom(AbilityHelper.causePlayerPiercingDamage((EntityPlayer)player), (float)damage) : entity.attackEntityFrom(AbilityHelper.causePiercingDamage(player), (float)damage)) : (player instanceof EntityPlayer ? entity.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)((EntityPlayer)player)), (float)damage) : entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)player), (float)damage));
                if (causedDamage) {
                    int drain;
                    AbilityHelper.damageTool(stack, 1, tags, player, false);
                    tool.onEntityDamaged(player.worldObj, player, entity);
                    if ((!necroticUHS || entity instanceof IMob && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).getHealth() <= 0.0f) && isAlive && (drain = toolTags.getInteger("Necrotic") * 2) > 0) {
                        player.heal((float)random.nextInt(drain + 1));
                    }
                    if (knockback > 0.0f) {
                        entity.addVelocity((double)(-MathHelper.sin((float)(player.rotationYaw * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.1, (double)(MathHelper.cos((float)(player.rotationYaw * (float)Math.PI / 180.0f)) * knockback * 0.5f));
                        player.motionX *= 0.6;
                        player.motionZ *= 0.6;
                        player.setSprinting(false);
                    }
                    if (player instanceof EntityPlayer) {
                        if (criticalHit) {
                            ((EntityPlayer)player).onCriticalHit(entity);
                        }
                        if (enchantDamage > 0.0f) {
                            ((EntityPlayer)player).onEnchantmentCritical(entity);
                        }
                        if (damage >= 18) {
                            ((EntityPlayer)player).triggerAchievement((StatBase)AchievementList.overkill);
                        }
                    }
                    player.setLastAttacker(entity);
                    if (entity instanceof EntityLivingBase) {
                        DamageSource.causeThornsDamage((Entity)entity);
                    }
                }
                if (entity instanceof EntityLivingBase) {
                    if (entity instanceof EntityPlayer) {
                        stack.hitEntity((EntityLivingBase)entity, (EntityPlayer)player);
                        if (entity.isEntityAlive()) {
                            AbilityHelper.alertPlayerWolves((EntityPlayer)player, (EntityLivingBase)entity, true);
                        }
                        ((EntityPlayer)player).addStat(StatList.damageDealtStat, damage);
                    } else {
                        stack.getItem().hitEntity(stack, (EntityLivingBase)entity, player);
                    }
                    if (causedDamage) {
                        AbilityHelper.processFiery((Entity)player, entity, toolTags);
                    }
                }
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)player).addExhaustion(0.3f);
                }
                if (causedDamage) {
                    return true;
                }
            }
        }
        return false;
    }

    public static int calcDamage(Entity user, Entity entity, ItemStack stack, ToolCore tool, NBTTagCompound toolTags, int baseDamage) {
        float lunge;
        EntityLivingBase living = user instanceof EntityLivingBase ? (EntityLivingBase)user : null;
        int damage = toolTags.getInteger("Attack") + baseDamage;
        int earlyModDamage = 0;
        for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
            earlyModDamage = mod.baseAttackDamage(earlyModDamage, damage, tool, stack.getTagCompound(), toolTags, stack, living, entity);
        }
        damage += earlyModDamage;
        if (living != null) {
            if (living.isPotionActive(Potion.damageBoost)) {
                damage += 3 << living.getActivePotionEffect(Potion.damageBoost).getAmplifier();
            }
            if (living.isPotionActive(Potion.weakness)) {
                damage -= 2 << living.getActivePotionEffect(Potion.weakness).getAmplifier();
            }
        }
        if ((damage = (int)((float)damage - AbilityHelper.calcStoneboundBonus(tool, toolTags))) < 1) {
            damage = 1;
        }
        if (living != null && living.isSprinting() && (lunge = tool.chargeAttack()) > 1.0f) {
            damage = (int)((float)damage * lunge);
        }
        int modDamage = 0;
        for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
            modDamage = mod.attackDamage(modDamage, damage, tool, stack.getTagCompound(), toolTags, stack, living, entity);
        }
        return damage += modDamage;
    }

    public static float calcKnockback(Entity user, Entity entity, ItemStack stack, ToolCore tool, NBTTagCompound toolTags, int baseDamage) {
        if (user == null) {
            return 0.0f;
        }
        float knockback = 0.0f;
        if (entity instanceof EntityLivingBase && user instanceof EntityLivingBase) {
            knockback += (float)EnchantmentHelper.getKnockbackModifier((EntityLivingBase)((EntityLivingBase)user), (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (user.isSprinting()) {
            knockback += 1.0f;
            float lunge = tool.chargeAttack();
            if (lunge > 1.0f) {
                knockback += lunge - 1.0f;
            }
        }
        float modKnockback = 0.0f;
        for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
            modKnockback = mod.knockback(modKnockback, knockback, tool, stack.getTagCompound(), toolTags, stack, user instanceof EntityLivingBase ? (EntityLivingBase)user : null, entity);
        }
        return knockback += modKnockback;
    }

    public static void processFiery(Entity player, Entity target, NBTTagCompound toolTags) {
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        int fireAspect = 0;
        if (player instanceof EntityLivingBase) {
            fireAspect = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)((EntityLivingBase)player));
        }
        if (fireAspect > 0 || toolTags.hasKey("Fiery") || toolTags.hasKey("Lava")) {
            fireAspect *= 4;
            if (toolTags.hasKey("Fiery")) {
                fireAspect += toolTags.getInteger("Fiery") / 5 + 1;
            }
            if (toolTags.getBoolean("Lava")) {
                fireAspect += 3;
            }
            target.setFire(fireAspect);
        }
    }

    static void alertPlayerWolves(EntityPlayer player, EntityLivingBase living, boolean par2) {
        if (!(living instanceof EntityCreeper) && !(living instanceof EntityGhast)) {
            EntityWolf var3;
            if (living instanceof EntityWolf && (var3 = (EntityWolf)living).isTamed() && player.getDisplayName().equals(var3.func_152113_b())) {
                return;
            }
            if (!(living instanceof EntityPlayer) || player.canAttackPlayer((EntityPlayer)living)) {
                List var6 = player.worldObj.getEntitiesWithinAABB(EntityWolf.class, AxisAlignedBB.getBoundingBox((double)player.posX, (double)player.posY, (double)player.posZ, (double)(player.posX + 1.0), (double)(player.posY + 1.0), (double)(player.posZ + 1.0)).expand(16.0, 4.0, 16.0));
                for (EntityWolf var5 : var6) {
                    if (!var5.isTamed() || var5.getEntityToAttack() != null || !player.getDisplayName().equals(var5.func_152113_b()) || par2 && var5.isSitting()) continue;
                    var5.setSitting(false);
                    var5.setTarget((Entity)living);
                }
            }
        }
    }

    public static void damageTool(ItemStack stack, int dam, EntityLivingBase entity, boolean ignoreCharge) {
        NBTTagCompound tags = stack.getTagCompound();
        AbilityHelper.damageTool(stack, dam, tags, entity, ignoreCharge);
    }

    public static void healTool(ItemStack stack, int dam, EntityLivingBase entity, boolean ignoreCharge) {
        NBTTagCompound tags = stack.getTagCompound();
        AbilityHelper.damageTool(stack, -dam, tags, entity, ignoreCharge);
    }

    public static void damageTool(ItemStack stack, int dam, NBTTagCompound tags, EntityLivingBase entity, boolean ignoreCharge) {
        NBTTagCompound toolTags;
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).capabilities.isCreativeMode || tags == null) {
            return;
        }
        int reinforced = 0;
        if (tags.hasKey("InfiTool") && dam > 0 && (toolTags = tags.getCompoundTag("InfiTool")).hasKey("Unbreaking")) {
            reinforced = tags.getCompoundTag("InfiTool").getInteger("Unbreaking");
            for (int i = dam; i > 0; --i) {
                if (random.nextInt(10) >= reinforced) continue;
                --dam;
            }
            if (dam <= 0) {
                return;
            }
        }
        if (ignoreCharge || !AbilityHelper.damageEnergyTool(stack, tags, (Entity)entity)) {
            boolean damagedTool = false;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                if (!mod.damageTool(stack, dam, entity)) continue;
                damagedTool = true;
            }
            if (damagedTool) {
                return;
            }
            int damage = tags.getCompoundTag("InfiTool").getInteger("Damage");
            int damageTrue = damage + dam;
            int maxDamage = tags.getCompoundTag("InfiTool").getInteger("TotalDurability");
            if (damageTrue <= 0) {
                tags.getCompoundTag("InfiTool").setInteger("Damage", 0);
                tags.getCompoundTag("InfiTool").setBoolean("Broken", false);
            } else if (damageTrue > maxDamage) {
                AbilityHelper.breakTool(stack, tags, (Entity)entity);
            } else {
                tags.getCompoundTag("InfiTool").setInteger("Damage", damage + dam);
                int toolDamage = damage * 100 / maxDamage + 1;
                int stackDamage = stack.getItemDamage();
                if (toolDamage != stackDamage) {
                    // empty if block
                }
            }
        }
    }

    public static boolean damageEnergyTool(ItemStack stack, NBTTagCompound tags, Entity entity) {
        if (!tags.hasKey("Energy")) {
            return false;
        }
        NBTTagCompound toolTag = stack.getTagCompound().getCompoundTag("InfiTool");
        int energy = tags.getInteger("Energy");
        int durability = toolTag.getInteger("Damage");
        float shoddy = toolTag.getFloat("Shoddy");
        float mineSpeed = toolTag.getInteger("MiningSpeed");
        int heads = 1;
        if (toolTag.hasKey("MiningSpeed2")) {
            mineSpeed += (float)toolTag.getInteger("MiningSpeed2");
            ++heads;
        }
        if (toolTag.hasKey("MiningSpeedHandle")) {
            mineSpeed += (float)toolTag.getInteger("MiningSpeedHandle");
            ++heads;
        }
        if (toolTag.hasKey("MiningSpeedExtra")) {
            mineSpeed += (float)toolTag.getInteger("MiningSpeedExtra");
            ++heads;
        }
        float trueSpeed = mineSpeed / ((float)heads * 100.0f);
        float stonebound = toolTag.getFloat("Shoddy");
        float bonusLog = (float)Math.log((float)durability / 72.0f + 1.0f) * 2.0f * stonebound;
        trueSpeed += bonusLog;
        trueSpeed *= 6.0f;
        if (energy != -1) {
            int usage = (int)(trueSpeed * 2.8f);
            if (!equalityOverrideLoaded && entity instanceof EntityPlayer) {
                ToolCore tool = (ToolCore)stack.getItem();
                AbilityHelper.chargeEnergyFromHotbar(stack, (EntityPlayer)entity, tags);
                energy = tool.getEnergyStored(stack);
            }
            if (energy < usage) {
                if (energy > 0) {
                    tags.setInteger("Energy", 0);
                }
                return false;
            }
            tags.setInteger("Energy", energy -= usage);
        }
        return true;
    }

    protected static void chargeEnergyFromHotbar(ItemStack stack, EntityPlayer player, NBTTagCompound tags) {
        if (!(stack.getItem() instanceof ToolCore)) {
            return;
        }
        ToolCore tool = (ToolCore)stack.getItem();
        if (tool.receiveEnergy(stack, 1, true) != 1) {
            return;
        }
        int buffer = tool.getEnergyStored(stack);
        int max = tool.getMaxEnergyStored(stack);
        int missing = max - buffer;
        if (missing <= 0) {
            return;
        }
        for (int iter = 0; iter < 9; ++iter) {
            ItemStack slot = player.inventory.mainInventory[iter];
            if (slot == null || slot.getItem() instanceof ToolCore || !(slot.getItem() instanceof IEnergyContainerItem)) continue;
            IEnergyContainerItem fluxItem = (IEnergyContainerItem)slot.getItem();
            while (fluxItem.extractEnergy(slot, missing, true) > 0) {
                missing -= fluxItem.extractEnergy(slot, missing, false);
            }
        }
        tags.setInteger("Energy", max - missing);
    }

    public static void breakTool(ItemStack stack, NBTTagCompound tags, Entity entity) {
        tags.getCompoundTag("InfiTool").setBoolean("Broken", true);
        if (entity != null) {
            entity.worldObj.playSound(entity.posX, entity.posY, entity.posZ, "random.break", 1.0f, 1.0f, true);
        }
    }

    public static void repairTool(ItemStack stack, NBTTagCompound tags) {
        tags.getCompoundTag("InfiTool").setBoolean("Broken", false);
        tags.getCompoundTag("InfiTool").setInteger("Damage", 0);
    }

    public static DamageSource causePiercingDamage(EntityLivingBase mob) {
        return new PiercingEntityDamage("mob", (Entity)mob);
    }

    public static DamageSource causePlayerPiercingDamage(EntityPlayer player) {
        return new PiercingEntityDamage("player", (Entity)player);
    }

    public static void knockbackEntity(EntityLivingBase living, double boost) {
        living.motionX *= boost;
        living.motionZ *= boost;
    }

    public static boolean hoeGround(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, Random random) {
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            AbilityHelper.damageTool(stack, 1, (EntityLivingBase)player, false);
            return true;
        }
        Block block = world.getBlock(x, y, z);
        if (side != 0 && world.getBlock(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z) && (block == Blocks.grass || block == Blocks.dirt)) {
            Block block1 = Blocks.farmland;
            world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block1.stepSound.getStepResourcePath(), (block1.stepSound.getVolume() + 1.0f) / 2.0f, block1.stepSound.getPitch() * 0.8f);
            if (world.isRemote) {
                return true;
            }
            world.setBlock(x, y, z, block1);
            AbilityHelper.damageTool(stack, 1, (EntityLivingBase)player, false);
            return true;
        }
        return false;
    }

    public static void spawnItemAtEntity(Entity entity, ItemStack stack, int delay) {
        if (!entity.worldObj.isRemote) {
            EntityItem entityitem = new EntityItem(entity.worldObj, entity.posX + 0.5, entity.posY + 0.5, entity.posZ + 0.5, stack);
            entityitem.delayBeforeCanPickup = delay;
            entity.worldObj.spawnEntityInWorld((Entity)entityitem);
        }
    }

    public static void spawnItemAtPlayer(EntityPlayer player, ItemStack stack) {
        if (!player.worldObj.isRemote) {
            if (player instanceof FakePlayer || !player.inventory.addItemStackToInventory(stack)) {
                EntityItem entityitem = new EntityItem(player.worldObj, player.posX + 0.5, player.posY + 0.5, player.posZ + 0.5, stack);
                player.worldObj.spawnEntityInWorld((Entity)entityitem);
                if (!(player instanceof FakePlayer)) {
                    entityitem.onCollideWithPlayer(player);
                }
            } else if (player instanceof EntityPlayerMP) {
                player.worldObj.playSoundAtEntity((Entity)player, "random.pop", 0.2f, ((TConstruct.random.nextFloat() - TConstruct.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.inventoryContainer.detectAndSendChanges();
            }
        }
    }

    public static void forceAddToInv(EntityPlayer entityplayer, ItemStack itemstack, int i, boolean flag) {
        ItemStack itemstack1 = entityplayer.inventory.getStackInSlot(i);
        entityplayer.inventory.setInventorySlotContents(i, itemstack);
        if (itemstack1 != null) {
            AbilityHelper.addToInv(entityplayer, itemstack1, flag);
        }
    }

    public static boolean addToInv(EntityPlayer entityplayer, ItemStack itemstack, boolean flag) {
        return AbilityHelper.addToInv(entityplayer, itemstack, entityplayer.inventory.currentItem, flag);
    }

    public static boolean addToInv(EntityPlayer entityplayer, ItemStack itemstack, int i, boolean flag) {
        boolean flag1;
        ItemStack itemstack1 = entityplayer.inventory.getStackInSlot(i);
        if (itemstack1 == null) {
            entityplayer.inventory.setInventorySlotContents(i, itemstack);
            flag1 = true;
        } else {
            flag1 = entityplayer.inventory.addItemStackToInventory(itemstack);
        }
        if (flag && !flag1) {
            AbilityHelper.addItemStackToWorld(entityplayer.worldObj, (float)Math.floor(entityplayer.posX), (float)Math.floor(entityplayer.posY), (float)Math.floor(entityplayer.posZ), itemstack);
            return true;
        }
        return flag1;
    }

    public static EntityItem addItemStackToWorld(World world, float f, float f1, float f2, ItemStack itemstack) {
        return AbilityHelper.addItemStackToWorld(world, f, f1, f2, itemstack, false);
    }

    public static EntityItem addItemStackToWorld(World world, float f, float f1, float f2, ItemStack itemstack, boolean flag) {
        EntityItem entityitem;
        if (flag) {
            entityitem = new EntityItem(world, (double)f, (double)f1, (double)f2, itemstack);
        } else {
            float f3 = 0.7f;
            float f4 = random.nextFloat() * f3 + (1.0f - f3) * 0.5f;
            float f5 = 1.2f;
            float f6 = random.nextFloat() * f3 + (1.0f - f3) * 0.5f;
            entityitem = new EntityItem(world, (double)(f + f4), (double)(f1 + f5), (double)(f2 + f6), itemstack);
        }
        entityitem.delayBeforeCanPickup = 10;
        world.spawnEntityInWorld((Entity)entityitem);
        return entityitem;
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * f;
        float f2 = player.prevRotationYaw + (player.rotationYaw - player.prevRotationYaw) * f;
        double d0 = player.prevPosX + (player.posX - player.prevPosX) * (double)f;
        double d1 = player.prevPosY + (player.posY - player.prevPosY) * (double)f;
        if (!world.isRemote && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.prevPosZ + (player.posZ - player.prevPosZ) * (double)f;
        Vec3 vec3 = Vec3.createVectorHelper((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.cos((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.sin((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.cos((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.sin((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).theItemInWorldManager.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.addVector((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public static float calcToolSpeed(ToolCore tool, NBTTagCompound tags) {
        float mineSpeed = tags.getInteger("MiningSpeed");
        int heads = 1;
        if (tags.hasKey("MiningSpeed2")) {
            mineSpeed += (float)tags.getInteger("MiningSpeed2");
            ++heads;
        }
        if (tags.hasKey("MiningSpeedHandle")) {
            mineSpeed += (float)tags.getInteger("MiningSpeedHandle");
            ++heads;
        }
        if (tags.hasKey("MiningSpeedExtra")) {
            mineSpeed += (float)tags.getInteger("MiningSpeedExtra");
            ++heads;
        }
        float speedMod = 1.0f;
        if (tool instanceof HarvestTool) {
            speedMod = ((HarvestTool)tool).breakSpeedModifier();
        }
        float trueSpeed = mineSpeed / ((float)heads * 100.0f) * speedMod;
        return trueSpeed += AbilityHelper.calcStoneboundBonus(tool, tags);
    }

    public static float calcDualToolSpeed(ToolCore tool, NBTTagCompound tags, boolean secondary) {
        String tag = "MiningSpeed";
        if (secondary) {
            tag = tag + "2";
        }
        float mineSpeed = tags.getInteger(tag);
        float speedMod = 1.0f;
        if (tool instanceof HarvestTool) {
            speedMod = ((HarvestTool)tool).breakSpeedModifier();
        }
        float trueSpeed = mineSpeed / 100.0f * speedMod;
        return trueSpeed += AbilityHelper.calcStoneboundBonus(tool, tags);
    }

    public static float calcStoneboundBonus(ToolCore tool, NBTTagCompound tags) {
        int durability = tags.getInteger("Damage");
        float stonebound = tags.getFloat("Shoddy");
        float stoneboundMod = 72.0f;
        if (tool instanceof HarvestTool) {
            stoneboundMod = ((HarvestTool)tool).stoneboundModifier();
        }
        return (float)Math.log((float)durability / stoneboundMod + 1.0f) * 2.0f * stonebound;
    }

    static {
        equalityOverrideLoaded = Loader.isModLoaded((String)"CoFHCore");
    }
}

