/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.armor.ArmorMod;
import tconstruct.library.armor.ArmorPart;
import tconstruct.library.modifier.IModifyable;

public class TravelModDoubleJump
extends ArmorMod {
    String color = "\u00a77";
    String tooltipName = "Double-Jump";

    public TravelModDoubleJump(EnumSet<ArmorPart> armorTypes, ItemStack[] items) {
        super(0, "Double-Jump", armorTypes, items);
    }

    @Override
    public boolean validType(IModifyable type) {
        return type.getModifyType().equals("Clothing");
    }

    @Override
    public void modify(ItemStack[] recipe, ItemStack input) {
        NBTTagCompound tags = input.getTagCompound().getCompoundTag(this.getTagName(input));
        int amount = 1;
        if (tags.hasKey(this.key)) {
            int increase = tags.getInteger(this.key);
            tags.setInteger(this.key, ++increase);
        } else {
            tags.setInteger(this.key, amount);
        }
        int modifiers = tags.getInteger("Modifiers");
        tags.setInteger("Modifiers", --modifiers);
        this.addToolTip(input, this.color + this.tooltipName, this.color + this.key);
    }

    @Override
    protected int addToolTip(ItemStack tool, String tooltip, String modifierTip) {
        String tip;
        String tag;
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag(this.getTagName(tool));
        int tipNum = 0;
        do {
            if (tags.hasKey(tip = "Tooltip" + ++tipNum)) continue;
            tags.setString(tip, tooltip);
            String modTip = "ModifierTip" + tipNum;
            tags.setString(modTip, modifierTip);
            return tipNum;
        } while (!(tag = tags.getString(tip)).contains("Double-Jump") && !tag.contains("Triple-Jump"));
        tags.setString(tip, this.getProperName(tooltip, tag));
        String modTip = "ModifierTip" + tipNum;
        tag = tags.getString(modTip);
        tags.setString(modTip, this.getProperName(modifierTip, tag));
        return tipNum;
    }

    @Override
    protected String getProperName(String tooltip, String tag) {
        if (tag.contains("Double-Jump")) {
            return this.color + "Triple-Jump";
        }
        if (tag.contains("Triple-Jump")) {
            return this.color + "Quadruple-Jump";
        }
        if (tag.contains("Quadruple-Jump")) {
            return this.color + "Quintuple-Jump";
        }
        if (tag.contains("Quintuple-Jump")) {
            return this.color + "Sextuple-Jump";
        }
        if (tag.contains("Sextuple-Jump")) {
            return this.color + "Septuple-Jump";
        }
        return this.color + "Double-Jump";
    }
}

