/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.armor.items.TravelGear;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.modifier.ItemModifier;

public class TravelModRepair
extends ItemModifier {
    public TravelModRepair() {
        super(new ItemStack[0], 0, "");
    }

    @Override
    public boolean matches(ItemStack[] recipe, ItemStack input) {
        return this.canModify(input, recipe);
    }

    @Override
    protected boolean canModify(ItemStack input, ItemStack[] recipe) {
        if (input.getItem() instanceof TravelGear) {
            TravelGear gear = (TravelGear)input.getItem();
            NBTTagCompound tags = input.getTagCompound().getCompoundTag(gear.getBaseTagName());
            int damage = tags.getInteger("Damage");
            if (damage > 0) {
                boolean validOutput = true;
                int outputs = 0;
                for (ItemStack curInput : recipe) {
                    if (curInput == null) continue;
                    if (this.areItemStacksEquivalent(curInput, gear.getRepairMaterial(input))) {
                        ++outputs;
                        continue;
                    }
                    validOutput = false;
                }
                return validOutput && outputs > 0;
            }
        }
        return false;
    }

    private int calculateIncrease(ItemStack tool, NBTTagCompound tags, int materialValue, int itemsUsed) {
        int damage = tags.getInteger("Damage");
        int dur = tags.getInteger("BaseDurability");
        int increase = (int)((float)(50 * itemsUsed) + (float)dur * 0.4f * (float)materialValue);
        int modifiers = tags.getInteger("Modifiers");
        float mods = 1.0f;
        if (modifiers == 2) {
            mods = 0.9f;
        } else if (modifiers == 1) {
            mods = 0.8f;
        } else if (modifiers == 0) {
            mods = 0.7f;
        }
        increase = (int)((float)increase * mods);
        int repair = tags.getInteger("RepairCount");
        float repairCount = (float)(100 - repair) / 100.0f;
        if (repairCount < 0.5f) {
            repairCount = 0.5f;
        }
        increase = (int)((float)increase * repairCount);
        return increase;
    }

    @Override
    public void modify(ItemStack[] recipe, ItemStack input) {
        TravelGear gear = (TravelGear)input.getItem();
        NBTTagCompound tags = input.getTagCompound().getCompoundTag(gear.getBaseTagName());
        tags.setBoolean("Broken", false);
        int damage = tags.getInteger("Damage");
        int dur = tags.getInteger("BaseDurability");
        int itemsUsed = 0;
        int materialValue = 0;
        for (ItemStack modify : recipe) {
            if (modify == null) continue;
            materialValue += 2;
            ++itemsUsed;
        }
        int increase = this.calculateIncrease(input, tags, materialValue, itemsUsed);
        int repair = tags.getInteger("RepairCount");
        tags.setInteger("RepairCount", repair += itemsUsed);
        if ((damage -= increase) < 0) {
            damage = 0;
        }
        tags.setInteger("Damage", damage);
        input.setItemDamage(damage);
    }

    @Override
    public void addMatchingEffect(ItemStack tool) {
    }

    @Override
    public boolean validType(IModifyable input) {
        return input.getModifyType().equals("Clothing");
    }
}

