/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class ModAntiSpider
extends ItemModTypeFilter {
    String tooltipName = "\u00a72Bane of Arthropods";
    int max = 4;
    String guiType;

    public ModAntiSpider(String type, int effect, ItemStack[] items, int[] values) {
        super(effect, "ModAntiSpider", items, values);
        this.guiType = type;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        if (!tags.hasKey(this.key)) {
            return tags.getInteger("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
        }
        if (this.matchingAmount(input) > this.max) {
            return false;
        }
        int[] keyPair = tags.getIntArray(this.key);
        if (keyPair[0] + this.matchingAmount(input) <= keyPair[1]) {
            return true;
        }
        if (keyPair[0] == keyPair[1]) {
            return tags.getInteger("Modifiers") > 0;
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int increase = this.matchingAmount(input);
        if (tags.hasKey(this.key)) {
            int[] keyPair = tags.getIntArray(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.setIntArray(this.key, keyPair);
                int modifiers = tags.getInteger("Modifiers");
                tags.setInteger("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.setIntArray(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.getInteger("Modifiers");
            tags.setInteger("Modifiers", --modifiers);
            String modName = "\u00a72" + this.guiType + " (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{increase, this.max, tooltipIndex};
            tags.setIntArray(this.key, keyPair);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a72" + this.guiType + " (" + keys[0] + "/" + keys[1] + ")";
        tags.setString(tip, modName);
    }
}

