/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import cofh.api.energy.IEnergyContainerItem;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ModBoolean;
import tconstruct.util.config.PHConstruct;

public class ModFlux
extends ModBoolean {
    public ArrayList<ItemStack> batteries = new ArrayList();
    public int modifiersRequired = 1;

    public ModFlux() {
        super(new ItemStack[0], 9, "Flux", "\u00a7e", "");
    }

    @Override
    public boolean matches(ItemStack[] input, ItemStack tool) {
        String[] traits;
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        for (String trait : traits = ((IModifyable)tool.getItem()).getTraits()) {
            if (!"ammo".equals(trait)) continue;
            return false;
        }
        ItemStack foundBattery = null;
        for (ItemStack stack : input) {
            for (ItemStack battery : this.batteries) {
                if (stack == null || stack.getItem() != battery.getItem() || !(stack.getItem() instanceof IEnergyContainerItem)) continue;
                if (foundBattery != null) {
                    return false;
                }
                foundBattery = stack;
            }
        }
        if (foundBattery == null) {
            return false;
        }
        int maxEnergy = ((IEnergyContainerItem)foundBattery.getItem()).getMaxEnergyStored(foundBattery);
        if (PHConstruct.balancedFluxModifier && tags.getInteger("TotalDurability") < maxEnergy / 1000) {
            return false;
        }
        if (tags.getBoolean(this.key)) {
            int a = ((IEnergyContainerItem)foundBattery.getItem()).getMaxEnergyStored(foundBattery);
            int b = ((ToolCore)tool.getItem()).getMaxEnergyStored(tool);
            return ((IEnergyContainerItem)foundBattery.getItem()).getMaxEnergyStored(foundBattery) > ((ToolCore)tool.getItem()).getMaxEnergyStored(tool);
        }
        return tags.getInteger("Modifiers") >= this.modifiersRequired;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int progress;
        NBTTagCompound tags = tool.getTagCompound();
        if (!tags.hasKey(this.key)) {
            int modifiers = tags.getCompoundTag("InfiTool").getInteger("Modifiers");
            tags.getCompoundTag("InfiTool").setInteger("Modifiers", modifiers -= this.modifiersRequired);
            this.addModifierTip(tool, "\u00a7eFlux");
        }
        tags.getCompoundTag("InfiTool").setBoolean(this.key, true);
        ItemStack inputBattery = null;
        for (ItemStack stack : input) {
            for (ItemStack battery : this.batteries) {
                if (stack == null || stack.getItem() != battery.getItem() || !(stack.getItem() instanceof IEnergyContainerItem)) continue;
                inputBattery = stack;
            }
        }
        IEnergyContainerItem energyContainer = (IEnergyContainerItem)inputBattery.getItem();
        int charge = energyContainer.getEnergyStored(inputBattery);
        if (tags.hasKey("Energy")) {
            charge += tags.getInteger("Energy");
        }
        int maxCharge = energyContainer.getMaxEnergyStored(inputBattery);
        ItemStack subject42 = inputBattery.copy();
        int change = 1;
        for (progress = 0; progress < maxCharge && change > 0; progress += change) {
            change = energyContainer.receiveEnergy(subject42, 100000, false);
        }
        int maxExtract = energyContainer.extractEnergy(subject42, Integer.MAX_VALUE, true);
        subject42 = inputBattery.copy();
        change = 1;
        for (progress = 0; progress < maxCharge && change > 0; progress += change) {
            change = energyContainer.extractEnergy(subject42, 100000, false);
        }
        int maxReceive = energyContainer.receiveEnergy(subject42, Integer.MAX_VALUE, true);
        charge = Math.min(charge, maxCharge);
        tags.setInteger("Energy", charge);
        tags.setInteger("EnergyMax", maxCharge);
        tags.setInteger("EnergyExtractionRate", maxExtract);
        tags.setInteger("EnergyReceiveRate", maxReceive);
        tags.setInteger(this.key, 1);
        ToolCore toolcore = (ToolCore)tool.getItem();
    }
}

