/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ModRedstone;

public class ModWindup
extends ModRedstone {
    public ModWindup(int effect, ItemStack[] items, int[] values) {
        super(effect, items, values);
    }

    @Override
    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.getTraits());
        return list.contains("windup");
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (!super.canModify(tool, input)) {
            return false;
        }
        float drawSSpeed = tool.getTagCompound().getCompoundTag("InfiTool").getFloat("DrawSpeed");
        return drawSSpeed > 5.0f;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int modifiers;
        int[] keyPair;
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int increase = this.matchingAmount(input);
        int current = 0;
        if (tags.hasKey(this.key)) {
            keyPair = tags.getIntArray(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.setIntArray(this.key, keyPair);
                modifiers = tags.getInteger("Modifiers");
                tags.setInteger("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.setIntArray(this.key, keyPair);
            }
            current = keyPair[0];
            this.updateModTag(tool, keyPair);
        } else {
            modifiers = tags.getInteger("Modifiers");
            tags.setInteger("Modifiers", --modifiers);
            String modName = "\u00a74Redstone (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            keyPair = new int[]{increase, this.max, tooltipIndex};
            current = keyPair[0];
            tags.setIntArray(this.key, keyPair);
        }
        float boost = 0.1f * (float)current;
        for (int i = 0; i < current / 50; ++i) {
            boost += 2.0f;
        }
        int baseDrawSpeed = tags.getInteger("BaseDrawSpeed");
        int drawSpeed = baseDrawSpeed - (int)boost;
        drawSpeed = Math.max(5, drawSpeed);
        tags.setInteger("DrawSpeed", drawSpeed);
    }
}

