/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import tconstruct.library.crafting.AlloyMix;
import tconstruct.library.crafting.Smeltery;
import tconstruct.plugins.nei.RecipeHandlerBase;

public class RecipeHandlerAlloying
extends RecipeHandlerBase {
    public static final Rectangle OUTPUT_TANK = new Rectangle(118, 9, 18, 32);

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tconstruct.nei.alloying");
    }

    @Override
    public String getRecipeID() {
        return "tconstruct.smeltery.alloying";
    }

    public String getGuiTexture() {
        return "tinker:textures/gui/nei/smeltery.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 21, 22, 15), this.getRecipeID(), new Object[0]));
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)62, (int)160, (int)65);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeID())) {
            for (AlloyMix recipe : Smeltery.getAlloyList()) {
                if (recipe.mixers.isEmpty()) continue;
                this.arecipes.add(new CachedAlloyingRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (AlloyMix recipe : Smeltery.getAlloyList()) {
            if (!RecipeHandlerAlloying.areFluidsEqual(recipe.result, result) || recipe.mixers.isEmpty()) continue;
            this.arecipes.add(new CachedAlloyingRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        block0: for (AlloyMix recipe : Smeltery.getAlloyList()) {
            for (FluidStack liquid : recipe.mixers) {
                if (!RecipeHandlerAlloying.areFluidsEqual(liquid, ingredient) || recipe.mixers.isEmpty()) continue;
                this.arecipes.add(new CachedAlloyingRecipe(recipe));
                continue block0;
            }
        }
    }

    public class CachedAlloyingRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        private List<RecipeHandlerBase.FluidTankElement> fluidTanks;
        private int minAmount;

        public CachedAlloyingRecipe(AlloyMix recipe) {
            super(RecipeHandlerAlloying.this);
            this.fluidTanks = new ArrayList<RecipeHandlerBase.FluidTankElement>();
            int maxAmount = recipe.mixers.get((int)0).amount;
            int mult = 1;
            this.minAmount = maxAmount;
            for (FluidStack stack : recipe.mixers) {
                if (stack.amount > maxAmount) {
                    maxAmount = stack.amount;
                }
                if (stack.amount >= this.minAmount) continue;
                this.minAmount = stack.amount;
            }
            RecipeHandlerBase.FluidTankElement tank = new RecipeHandlerBase.FluidTankElement(OUTPUT_TANK, maxAmount * mult, recipe.result);
            tank.fluid.amount *= mult;
            this.fluidTanks.add(tank);
            int width = 36 / recipe.mixers.size();
            int counter = 0;
            for (FluidStack stack : recipe.mixers) {
                tank = counter == recipe.mixers.size() - 1 ? new RecipeHandlerBase.FluidTankElement(new Rectangle(21 + width * counter, 9, 36 - width * counter, 32), maxAmount * mult, stack) : new RecipeHandlerBase.FluidTankElement(new Rectangle(21 + width * counter, 9, width, 32), maxAmount * mult, stack);
                tank.fluid.amount *= mult;
                this.fluidTanks.add(tank);
                ++counter;
            }
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public List<RecipeHandlerBase.FluidTankElement> getFluidTanks() {
            return this.fluidTanks;
        }
    }
}

