/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.HarvestLevels;
import tconstruct.library.util.IToolPart;
import tconstruct.plugins.nei.RecipeHandlerBase;
import tconstruct.tools.items.ToolPart;
import tconstruct.util.config.PHConstruct;

public class RecipeHandlerToolMaterials
extends RecipeHandlerBase {
    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tconstruct.nei.toolmaterials");
    }

    @Override
    public String getRecipeID() {
        return "tconstruct.tools.materials";
    }

    public String getGuiTexture() {
        return "tinker:textures/gui/nei/toolmaterials.png";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)160, (int)130);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(10, 30, 16, 16), this.getRecipeID(), new Object[0]));
    }

    public void drawExtras(int recipe) {
        int x;
        CachedToolMaterialsRecipe crecipe = (CachedToolMaterialsRecipe)((Object)this.arecipes.get(recipe));
        if (crecipe.material != null) {
            String ability;
            String heart;
            GuiDraw.drawString((String)(EnumChatFormatting.BOLD + crecipe.material.localizedName()), (int)35, (int)10, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.partcrafter4") + crecipe.material.durability), (int)35, (int)20, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.partcrafter5") + crecipe.material.handleModifier + "x"), (int)35, (int)30, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.partcrafter11") + Math.round((float)crecipe.material.durability * crecipe.material.handleModifier)), (int)35, (int)40, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.partcrafter6") + (float)crecipe.material.miningspeed / 100.0f), (int)35, (int)50, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.partcrafter7") + HarvestLevels.getHarvestLevelName(crecipe.material.harvestLevel)), (int)35, (int)60, (int)0x404040, (boolean)false);
            String string = heart = crecipe.material.attack == 2 ? StatCollector.translateToLocal((String)"gui.partcrafter8") : StatCollector.translateToLocal((String)"gui.partcrafter9");
            if (crecipe.material.attack() % 2 == 0) {
                GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.partcrafter10") + crecipe.material.attack / 2 + heart), (int)35, (int)70, (int)0x404040, (boolean)false);
            } else {
                GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.partcrafter10") + (float)crecipe.material.attack / 2.0f + heart), (int)35, (int)70, (int)0x404040, (boolean)false);
            }
            int abilityY = 85;
            if (crecipe.material.reinforced > 0) {
                GuiDraw.drawString((String)RecipeHandlerToolMaterials.getReinforcedString(crecipe.material.reinforced), (int)35, (int)85, (int)0x404040, (boolean)false);
                abilityY += 10;
            }
            if ((ability = crecipe.material.ability()) != null) {
                if (crecipe.material.stonebound != 0.0f) {
                    GuiDraw.drawString((String)(ability + " (" + Math.abs(crecipe.material.stonebound) + ")"), (int)35, (int)abilityY, (int)0x404040, (boolean)false);
                } else {
                    GuiDraw.drawString((String)ability, (int)35, (int)abilityY, (int)0x404040, (boolean)false);
                }
            }
        }
        if (crecipe.bowMaterial != null) {
            int y = 20;
            x = 35;
            GuiDraw.drawString((String)(EnumChatFormatting.BOLD + StatCollector.translateToLocal((String)"tconstruct.nei.projectilematerials")), (int)35, (int)10, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.toolstation6") + crecipe.bowMaterial.drawspeed), (int)x, (int)y, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.toolstation7") + crecipe.bowMaterial.flightSpeedMax), (int)x, (int)(y += 10), (int)0x404040, (boolean)false);
        }
        if (crecipe.arrowMaterial != null) {
            int y = 50;
            x = 35;
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.toolstation8") + crecipe.arrowMaterial.mass), (int)x, (int)y, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(StatCollector.translateToLocal((String)"gui.toolstation22") + crecipe.arrowMaterial.breakChance), (int)x, (int)(y += 10), (int)0x404040, (boolean)false);
        }
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeID())) {
            for (int matID : TConstructRegistry.toolMaterials.keySet()) {
                ArrayList<ItemStack> toolParts = new ArrayList<ItemStack>();
                ToolMaterial mat = TConstructRegistry.toolMaterials.get(matID);
                for (PatternBuilder.ItemKey key : PatternBuilder.instance.materials) {
                    PatternBuilder.MaterialSet set = PatternBuilder.instance.materialSets.get(key.key);
                    if (set.materialID != matID) continue;
                    ItemStack stack = new ItemStack(key.item, 1, key.damage);
                    toolParts.add(stack);
                }
                for (List list : TConstructRegistry.patternPartMapping.keySet()) {
                    if ((Integer)list.get(2) != matID) continue;
                    toolParts.add(TConstructRegistry.patternPartMapping.get(list));
                }
                if (!PHConstruct.craftMetalTools) {
                    for (CastingRecipe recipe : TConstructRegistry.getTableCasting().getCastingRecipes()) {
                        ItemStack castResult = recipe.getResult();
                        if (!(castResult.getItem() instanceof IToolPart) || ((IToolPart)castResult.getItem()).getMaterialID(castResult) != matID) continue;
                        toolParts.add(castResult);
                    }
                }
                if (toolParts.size() <= 0) continue;
                this.arecipes.add(new CachedToolMaterialsRecipe(toolParts, matID));
                this.arecipes.add(new CachedToolMaterialsRecipe(toolParts, matID, true));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        if (ingred.getItem() instanceof ToolPart || ingred.getItem() instanceof DynamicToolPart) {
            List toolParts;
            int materialID = ((IToolPart)ingred.getItem()).getMaterialID(ingred);
            if (materialID >= 0 && (toolParts = RecipeHandlerToolMaterials.getSingleList(ingred)).size() > 0) {
                this.arecipes.add(new CachedToolMaterialsRecipe(toolParts, materialID));
                this.arecipes.add(new CachedToolMaterialsRecipe(toolParts, materialID, true));
            }
        } else if (PatternBuilder.instance.getPartID(ingred) < Short.MAX_VALUE) {
            int materialID = PatternBuilder.instance.getPartID(ingred);
            List toolParts = RecipeHandlerToolMaterials.getSingleList(ingred);
            if (toolParts.size() > 0) {
                this.arecipes.add(new CachedToolMaterialsRecipe(toolParts, materialID));
                this.arecipes.add(new CachedToolMaterialsRecipe(toolParts, materialID, true));
            }
        } else {
            super.loadUsageRecipes(ingred);
        }
    }

    public static String getReinforcedString(int reinforced) {
        if (reinforced > 9) {
            return "Unbreakable";
        }
        String ret = "Reinforced ";
        switch (reinforced) {
            case 1: {
                ret = ret + "I";
                break;
            }
            case 2: {
                ret = ret + "II";
                break;
            }
            case 3: {
                ret = ret + "III";
                break;
            }
            case 4: {
                ret = ret + "IV";
                break;
            }
            case 5: {
                ret = ret + "V";
                break;
            }
            case 6: {
                ret = ret + "VI";
                break;
            }
            case 7: {
                ret = ret + "VII";
                break;
            }
            case 8: {
                ret = ret + "VIII";
                break;
            }
            case 9: {
                ret = ret + "IX";
                break;
            }
            default: {
                ret = ret + "X";
            }
        }
        return ret;
    }

    public class CachedToolMaterialsRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> toolParts = new ArrayList<PositionedStack>();
        public ToolMaterial material;
        public BowMaterial bowMaterial;
        public ArrowMaterial arrowMaterial;

        public CachedToolMaterialsRecipe(List<ItemStack> toolParts, int materialID) {
            for (ItemStack stack : toolParts) {
                this.toolParts.add(new PositionedStack((Object)stack, 10, 10));
            }
            this.material = TConstructRegistry.getMaterial(materialID);
        }

        public CachedToolMaterialsRecipe(List<ItemStack> toolParts, int materialID, boolean arrowBow) {
            for (ItemStack stack : toolParts) {
                this.toolParts.add(new PositionedStack((Object)stack, 10, 10));
            }
            this.arrowMaterial = TConstructRegistry.getArrowMaterial(materialID);
            this.bowMaterial = TConstructRegistry.getBowMaterial(materialID);
        }

        public PositionedStack getIngredient() {
            return this.toolParts.get(RecipeHandlerToolMaterials.this.cycleticks / 20 % this.toolParts.size());
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

