/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.te4;

import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class TE4Helper {
    public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setInteger("energy", energy);
        toSend.setTag("input", (NBTBase)new NBTTagCompound());
        toSend.setTag("output", (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.getCompoundTag("input"));
        output.writeToNBT(toSend.getCompoundTag("output"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"FurnaceRecipe", (NBTTagCompound)toSend);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        TE4Helper.addPulverizerRecipe(energy, input, primaryOutput, null, 0);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        TE4Helper.addPulverizerRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null || secondaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setInteger("energy", energy);
        toSend.setTag("input", (NBTBase)new NBTTagCompound());
        toSend.setTag("primaryOutput", (NBTBase)new NBTTagCompound());
        toSend.setTag("secondaryOutput", (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.getCompoundTag("input"));
        primaryOutput.writeToNBT(toSend.getCompoundTag("primaryOutput"));
        secondaryOutput.writeToNBT(toSend.getCompoundTag("secondaryOutput"));
        toSend.setInteger("secondaryChance", secondaryChance);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"PulverizerRecipe", (NBTTagCompound)toSend);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        TE4Helper.addSawmillRecipe(energy, input, primaryOutput, null, 0);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        TE4Helper.addSawmillRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null || secondaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setInteger("energy", energy);
        toSend.setTag("input", (NBTBase)new NBTTagCompound());
        toSend.setTag("primaryOutput", (NBTBase)new NBTTagCompound());
        toSend.setTag("secondaryOutput", (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.getCompoundTag("input"));
        primaryOutput.writeToNBT(toSend.getCompoundTag("primaryOutput"));
        secondaryOutput.writeToNBT(toSend.getCompoundTag("secondaryOutput"));
        toSend.setInteger("secondaryChance", secondaryChance);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SawmillRecipe", (NBTTagCompound)toSend);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        TE4Helper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        TE4Helper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput == null || secondaryInput == null || primaryOutput == null || secondaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setInteger("energy", energy);
        toSend.setTag("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.setTag("secondaryInput", (NBTBase)new NBTTagCompound());
        toSend.setTag("primaryOutput", (NBTBase)new NBTTagCompound());
        toSend.setTag("secondaryOutput", (NBTBase)new NBTTagCompound());
        primaryInput.writeToNBT(toSend.getCompoundTag("primaryInput"));
        secondaryInput.writeToNBT(toSend.getCompoundTag("secondaryInput"));
        primaryOutput.writeToNBT(toSend.getCompoundTag("primaryOutput"));
        secondaryOutput.writeToNBT(toSend.getCompoundTag("secondaryOutput"));
        toSend.setInteger("secondaryChance", secondaryChance);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterRecipe", (NBTTagCompound)toSend);
    }

    public static void addSmelterBlastOre(String oreType) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setString("oreType", oreType);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterBlastOreType", (NBTTagCompound)toSend);
    }

    public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setInteger("energy", energy);
        toSend.setTag("input", (NBTBase)new NBTTagCompound());
        toSend.setTag("output", (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.getCompoundTag("input"));
        output.writeToNBT(toSend.getCompoundTag("output"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CrucibleRecipe", (NBTTagCompound)toSend);
    }

    public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input == null || output == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setInteger("energy", energy);
        toSend.setTag("input", (NBTBase)new NBTTagCompound());
        toSend.setTag("output", (NBTBase)new NBTTagCompound());
        toSend.setTag("fluid", (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.getCompoundTag("input"));
        output.writeToNBT(toSend.getCompoundTag("output"));
        toSend.setBoolean("reversible", reversible);
        fluid.writeToNBT(toSend.getCompoundTag("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerFillRecipe", (NBTTagCompound)toSend);
    }

    public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input == null || output == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setInteger("energy", energy);
        toSend.setTag("input", (NBTBase)new NBTTagCompound());
        toSend.setTag("output", (NBTBase)new NBTTagCompound());
        toSend.setTag("fluid", (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.getCompoundTag("input"));
        output.writeToNBT(toSend.getCompoundTag("output"));
        toSend.setBoolean("reversible", reversible);
        toSend.setInteger("chance", chance);
        fluid.writeToNBT(toSend.getCompoundTag("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerExtractRecipe", (NBTTagCompound)toSend);
    }

    public static void addMagmaticFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setString("fluidName", fluidName);
        toSend.setInteger("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"MagmaticFuel", (NBTTagCompound)toSend);
    }

    public static void addCompressionFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setString("fluidName", fluidName);
        toSend.setInteger("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CompressionFuel", (NBTTagCompound)toSend);
    }

    public static void addReactantFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setString("fluidName", fluidName);
        toSend.setInteger("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"ReactantFuel", (NBTTagCompound)toSend);
    }

    public static void addCoolant(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setString("fluidName", fluidName);
        toSend.setInteger("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"Coolant", (NBTTagCompound)toSend);
    }
}

