/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.smeltery.blocks.LiquidMetalFinite;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;

public class TinkerSmelteryEvents {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (!PHConstruct.beginnerBook) {
            return;
        }
        Item item = event.crafting.getItem();
        if (!(event.player.worldObj.isRemote || item != Item.getItemFromBlock((Block)TinkerSmeltery.smeltery) && item != Item.getItemFromBlock((Block)TinkerSmeltery.lavaTank))) {
            TPlayerStats stats = TPlayerStats.get(event.player);
            if (!stats.smelteryManual) {
                stats.smelteryManual = true;
                AbilityHelper.spawnItemAtPlayer(event.player, new ItemStack(TinkerTools.manualBook, 1, 2));
            }
        }
    }

    @SubscribeEvent
    public void bucketFill(FillBucketEvent evt) {
        if (evt.current.getItem() == Items.bucket && evt.target.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int hitX = evt.target.blockX;
            int hitY = evt.target.blockY;
            int hitZ = evt.target.blockZ;
            if (evt.entityPlayer != null && !evt.entityPlayer.canPlayerEdit(hitX, hitY, hitZ, evt.target.sideHit, evt.current)) {
                return;
            }
            Block bID = evt.world.getBlock(hitX, hitY, hitZ);
            for (int id = 0; id < TinkerSmeltery.fluidBlocks.length; ++id) {
                if (bID != TinkerSmeltery.fluidBlocks[id]) continue;
                if (evt.entityPlayer.capabilities.isCreativeMode) {
                    WorldHelper.setBlockToAir((World)evt.world, (int)hitX, (int)hitY, (int)hitZ);
                    continue;
                }
                if (TinkerSmeltery.fluidBlocks[id] instanceof LiquidMetalFinite) {
                    WorldHelper.setBlockToAir((World)evt.world, (int)hitX, (int)hitY, (int)hitZ);
                } else {
                    WorldHelper.setBlockToAir((World)evt.world, (int)hitX, (int)hitY, (int)hitZ);
                }
                evt.setResult(Event.Result.ALLOW);
                evt.result = new ItemStack(TinkerSmeltery.buckets, 1, id);
            }
        }
    }
}

