/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.smeltery.logic.CastingChannelLogic;
import tconstruct.smeltery.model.BlockRenderCastingChannel;

public class CastingChannelBlock
extends BlockContainer {
    public CastingChannelBlock() {
        super(Material.rock);
        this.setHardness(1.0f);
        this.setResistance(10.0f);
        this.stepSound = soundTypeStone;
        this.setCreativeTab(TConstructRegistry.blockTab);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getCurrentEquippedItem();
        CastingChannelLogic tile = (CastingChannelLogic)world.getTileEntity(x, y, z);
        if (stack != null && stack.getItem() == Item.getItemFromBlock((Block)TinkerSmeltery.castingChannel)) {
            return false;
        }
        tile.changeOutputs(player, side, hitX, hitY, hitZ);
        return true;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        CastingChannelLogic tile = (CastingChannelLogic)world.getTileEntity(x, y, z);
        float minX = 0.3125f;
        float maxX = 0.6875f;
        float minZ = 0.3125f;
        float maxZ = 0.6875f;
        minZ = 0.0f;
        maxZ = 1.0f;
        minX = 0.0f;
        maxX = 1.0f;
        this.setBlockBounds(minX, 0.375f, minZ, maxX, 0.625f, maxZ);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public int getRenderType() {
        return BlockRenderCastingChannel.renderID;
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("tinker:searedstone");
    }

    public TileEntity createNewTileEntity(World var1, int var2) {
        return new CastingChannelLogic();
    }
}

