/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.InventoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.smeltery.logic.CastingBasinLogic;
import tconstruct.smeltery.logic.CastingBlockLogic;
import tconstruct.smeltery.logic.CastingTableLogic;
import tconstruct.smeltery.logic.FaucetLogic;
import tconstruct.smeltery.model.CastingBlockRender;

public class SearedBlock
extends InventoryBlock {
    String texturePrefix = "";

    public SearedBlock() {
        super(Material.rock);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setHardness(3.0f);
        this.setResistance(20.0f);
        this.setStepSound(soundTypeMetal);
    }

    public SearedBlock(String texture) {
        this();
        this.texturePrefix = texture;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new CastingTableLogic();
            }
            case 1: {
                return new FaucetLogic();
            }
            case 2: {
                return new CastingBasinLogic();
            }
        }
        return null;
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return null;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 0 || md == 2) {
            return this.activateCastingBlock(world, x, y, z, player);
        }
        if (md == 1) {
            if (player.isSneaking()) {
                return false;
            }
            if (!world.isRemote) {
                FaucetLogic logic = (FaucetLogic)world.getTileEntity(x, y, z);
                logic.setActive(true);
            }
            return true;
        }
        return super.onBlockActivated(world, x, y, z, player, side, clickX, clickY, clickZ);
    }

    boolean activateCastingBlock(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.isRemote) {
            CastingBlockLogic logic = (CastingBlockLogic)world.getTileEntity(x, y, z);
            logic.interact(player);
            world.markBlockForUpdate(x, y, z);
        }
        return true;
    }

    public int getRenderType() {
        return CastingBlockRender.searedModel;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"castingtable_top", "castingtable_side", "castingtable_bottom", "faucet", "blockcast_top", "blockcast_side", "blockcast_bottom"};
        if (!this.texturePrefix.equals("")) {
            for (int i = 0; i < textureNames.length; ++i) {
                textureNames[i] = this.texturePrefix + "_" + textureNames[i];
            }
        }
        return textureNames;
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta == 0) {
            return this.icons[this.getTextureIndex(side)];
        }
        if (meta == 2) {
            return this.icons[this.getTextureIndex(side) + 4];
        }
        return this.icons[3];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 3; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta != 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            TileEntity te = world.getTileEntity(x, y, z);
            float xMin = 0.25f;
            float xMax = 0.75f;
            float zMin = 0.25f;
            float zMax = 0.75f;
            if (te instanceof FaucetLogic) {
                FaucetLogic logic = (FaucetLogic)te;
                switch (logic.getRenderDirection()) {
                    case 2: {
                        zMin = 0.625f;
                        zMax = 1.0f;
                        break;
                    }
                    case 3: {
                        zMax = 0.375f;
                        zMin = 0.0f;
                        break;
                    }
                    case 4: {
                        xMin = 0.625f;
                        xMax = 1.0f;
                        break;
                    }
                    case 5: {
                        xMax = 0.375f;
                        xMin = 0.0f;
                    }
                }
            }
            this.setBlockBounds(xMin, 0.25f, zMin, xMax, 0.625f, zMax);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta != 1) {
            return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile != null && tile instanceof FaucetLogic) {
            FaucetLogic logic = (FaucetLogic)tile;
            float xMin = 0.25f;
            float xMax = 0.75f;
            float zMin = 0.25f;
            float zMax = 0.75f;
            switch (logic.getRenderDirection()) {
                case 2: {
                    zMin = 0.625f;
                    zMax = 1.0f;
                    break;
                }
                case 3: {
                    zMax = 0.375f;
                    zMin = 0.0f;
                    break;
                }
                case 4: {
                    xMin = 0.625f;
                    xMax = 1.0f;
                    break;
                }
                case 5: {
                    xMax = 0.375f;
                    xMin = 0.0f;
                }
            }
            return AxisAlignedBB.getBoundingBox((double)((float)x + xMin), (double)((double)y + 0.25), (double)((float)z + zMin), (double)((float)x + xMax), (double)((double)y + 0.625), (double)((float)z + zMax));
        }
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return world.getBlockMetadata(x, y, z) == 1;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlockID) {
        if (world.getBlockMetadata(x, y, z) == 1) {
            boolean isPowered = world.isBlockIndirectlyGettingPowered(x, y, z);
            TileEntity te = world.getTileEntity(x, y, z);
            if (!(te instanceof FaucetLogic)) {
                return;
            }
            FaucetLogic logic = (FaucetLogic)te;
            if (!logic.hasRedstonePower && isPowered) {
                logic.hasRedstonePower = true;
                logic.setActive(true);
            }
            logic.hasRedstonePower = isPowered;
        }
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new CastingTableLogic();
            }
            case 1: {
                return new FaucetLogic();
            }
            case 2: {
                return new CastingBasinLogic();
            }
        }
        return null;
    }
}

