/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mantle.blocks.abstracts.InventoryBlock;
import mantle.blocks.abstracts.MultiServantLogic;
import mantle.blocks.iface.IFacingLogic;
import mantle.blocks.iface.IMasterLogic;
import mantle.blocks.iface.IServantLogic;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.smeltery.logic.SmelteryDrainLogic;
import tconstruct.smeltery.logic.SmelteryLogic;
import tconstruct.smeltery.model.SmelteryRender;

public class SmelteryBlock
extends InventoryBlock {
    Random rand;
    String texturePrefix = "";

    public SmelteryBlock() {
        super(Material.rock);
        this.setHardness(3.0f);
        this.setResistance(20.0f);
        this.setStepSound(soundTypeMetal);
        this.rand = new Random();
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setBlockName("tconstruct.Smeltery");
    }

    public SmelteryBlock(String prefix) {
        this();
        this.texturePrefix = prefix;
    }

    public int getRenderType() {
        return SmelteryRender.smelteryModel;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"smeltery_side", "smeltery_inactive", "smeltery_active", "drain_side", "drain_out", "drain_basin", "searedbrick", "searedstone", "searedcobble", "searedpaver", "searedbrickcracked", "searedroad", "searedbrickfancy", "searedbricksquare", "searedcreeper"};
        if (!this.texturePrefix.equals("")) {
            for (int i = 0; i < textureNames.length; ++i) {
                textureNames[i] = this.texturePrefix + "_" + textureNames[i];
            }
        }
        return textureNames;
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta < 2) {
            int sideTex = side == 3 ? 1 : 0;
            return this.icons[sideTex + meta * 3];
        }
        if (meta == 2) {
            return this.icons[6];
        }
        if (meta == 11 && (side == 0 || side == 1)) {
            return this.icons[9];
        }
        return this.icons[3 + meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.getTileEntity(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            if (side == direction) {
                if (SmelteryBlock.isActive((IBlockAccess)world, (int)x, (int)y, (int)z)) {
                    return this.icons[2];
                }
                return this.icons[1];
            }
            return this.icons[0];
        }
        if (meta == 1) {
            if (side == direction) {
                return this.icons[5];
            }
            if (side / 2 == direction / 2) {
                return this.icons[4];
            }
            return this.icons[3];
        }
        if (meta == 2) {
            return this.icons[6];
        }
        if (meta == 11 && (side == 0 || side == 1)) {
            return this.icons[9];
        }
        return this.icons[3 + meta];
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return 7;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        if (SmelteryBlock.isActive((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            TileEntity logic = world.getTileEntity(x, y, z);
            byte face = 0;
            if (logic instanceof IFacingLogic) {
                face = ((IFacingLogic)logic).getRenderDirection();
            }
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.5f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            switch (face) {
                case 4: {
                    world.spawnParticle("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.spawnParticle("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.spawnParticle("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.spawnParticle("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.spawnParticle("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    world.spawnParticle("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.spawnParticle("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                    world.spawnParticle("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return !SmelteryBlock.isActive((IBlockAccess)world, (int)x, (int)y, (int)z) ? 0 : 9;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        if (world.getBlockMetadata(x, y, z) != 0) {
            return false;
        }
        return super.onBlockActivated(world, x, y, z, player, side, clickX, clickY, clickZ);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new SmelteryLogic();
            }
            case 1: {
                return new SmelteryDrainLogic();
            }
            case 3: {
                return null;
            }
        }
        return new MultiServantLogic();
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(world, x, y, z, entityliving, stack);
        if (world.getBlockMetadata(x, y, z) == 0) {
            this.onBlockPlacedElsewhere(world, x, y, z, entityliving);
        }
    }

    public void onBlockPlacedElsewhere(World world, int x, int y, int z, EntityLivingBase entityliving) {
        SmelteryLogic logic = (SmelteryLogic)world.getTileEntity(x, y, z);
        logic.checkValidPlacement();
    }

    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 12; ++iter) {
            if (iter == 3) continue;
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        TileEntity logic = world.getTileEntity(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        } else if (logic instanceof IMasterLogic) {
            ((IMasterLogic)logic).notifyChange(null, x, y, z);
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block blockID, int meta) {
        TileEntity logic = world.getTileEntity(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        }
        super.breakBlock(world, x, y, z, blockID, meta);
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int comparatorSide) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            return Container.calcRedstoneFromInventory((IInventory)((SmelteryLogic)world.getTileEntity(x, y, z)));
        }
        if (meta == 1) {
            return ((SmelteryDrainLogic)world.getTileEntity(x, y, z)).comparatorStrength();
        }
        return 0;
    }
}

