/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.TConstruct;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.event.ToolBuildEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.util.ItemHelper;
import tconstruct.util.config.PHConstruct;
import tconstruct.util.network.MovementUpdatePacket;

public class TinkerToolEvents {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.getItem();
        if (!event.player.worldObj.isRemote) {
            if (item == Item.getItemFromBlock((Block)TinkerTools.toolStationWood)) {
                if (!PHConstruct.beginnerBook) {
                    return;
                }
                TPlayerStats stats = TPlayerStats.get(event.player);
                if (!stats.materialManual) {
                    stats.materialManual = true;
                    AbilityHelper.spawnItemAtPlayer(event.player, new ItemStack(TinkerTools.manualBook, 1, 1));
                }
            }
            if (item == Item.getItemFromBlock((Block)TinkerTools.craftingSlabWood) && event.crafting.getItemDamage() == 4) {
                for (int i = 0; i < event.craftMatrix.getSizeInventory(); ++i) {
                    ItemStack stack = event.craftMatrix.getStackInSlot(i);
                    if (stack == null || stack.getItem() != Item.getItemFromBlock((Block)TinkerTools.toolStationWood) || stack.getItemDamage() != 5) continue;
                    event.crafting.setTagCompound(stack.getTagCompound());
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void buildTool(ToolBuildEvent event) {
        if (event.handleStack.getItem() == Items.bone) {
            event.handleStack = new ItemStack(TinkerTools.toolRod, 1, 5);
            return;
        }
        ArrayList sticks = OreDictionary.getOres((String)"stickWood");
        for (ItemStack stick : sticks) {
            if (!OreDictionary.itemMatches((ItemStack)stick, (ItemStack)event.handleStack, (boolean)false)) continue;
            event.handleStack = new ItemStack(TinkerTools.toolRod, 1, 0);
            return;
        }
    }

    @SubscribeEvent
    public void craftTool(ToolCraftEvent.NormalTool event) {
        int accessory;
        int handle;
        int head;
        NBTTagCompound toolTag = event.toolTag.getCompoundTag("InfiTool");
        if (PHConstruct.denyMattock && event.tool == TinkerTools.mattock && !this.allowCrafting(head = toolTag.getInteger("Head"), handle = toolTag.getInteger("Handle"), accessory = toolTag.getInteger("Accessory"))) {
            event.setResult(Event.Result.DENY);
            return;
        }
        this.handlePaper(toolTag, event.tool);
        this.handleThaumium(toolTag, event.tool);
        if (event.tool == TinkerTools.battlesign) {
            int modifiers = toolTag.getInteger("Modifiers");
            toolTag.setInteger("Modifiers", ++modifiers);
        }
    }

    private void handlePaper(NBTTagCompound toolTag, ToolCore tool) {
        int modifiers = toolTag.getInteger("Modifiers");
        if (toolTag.getInteger("Head") == 9) {
            ++modifiers;
        }
        if (toolTag.getInteger("Handle") == 9) {
            ++modifiers;
        }
        if (toolTag.getInteger("Accessory") == 9) {
            ++modifiers;
        }
        if (toolTag.getInteger("Extra") == 9) {
            ++modifiers;
        }
        if (tool.getPartAmount() == 2 && toolTag.getInteger("Head") == 9) {
            ++modifiers;
        }
        toolTag.setInteger("Modifiers", modifiers);
    }

    private void handleThaumium(NBTTagCompound toolTag, ToolCore tool) {
        int thaum = 0;
        if (toolTag.getInteger("Head") == 31) {
            ++thaum;
        }
        if (toolTag.getInteger("Handle") == 31) {
            ++thaum;
        }
        if (toolTag.getInteger("Accessory") == 31) {
            ++thaum;
        }
        if (toolTag.getInteger("Extra") == 31) {
            ++thaum;
        }
        int bonusModifiers = (int)Math.ceil((double)thaum / 2.0);
        if (tool.getPartAmount() == 2) {
            bonusModifiers = thaum;
        }
        int modifiers = toolTag.getInteger("Modifiers");
        toolTag.setInteger("Modifiers", modifiers += bonusModifiers);
    }

    private boolean allowCrafting(int head, int handle, int accessory) {
        int[] nonMetals = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 17};
        for (int i = 0; i < nonMetals.length; ++i) {
            if (head != nonMetals[i] && handle != nonMetals[i] && accessory != nonMetals[i]) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void craftPart(PartBuilderEvent.NormalPart event) {
        ItemStack result;
        if (event.pattern.getItem() == TinkerTools.woodPattern && event.pattern.getItemDamage() == 23 && (result = TinkerToolEvents.craftBowString(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
        if (event.pattern.getItem() == TinkerTools.woodPattern && event.pattern.getItemDamage() == 24 && (result = TinkerToolEvents.craftFletching(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
    }

    public static ItemStack craftBowString(ItemStack stack) {
        if (stack.stackSize < 3) {
            return null;
        }
        BowstringMaterial mat = (BowstringMaterial)TConstructRegistry.getCustomMaterial(stack, BowstringMaterial.class);
        if (mat != null) {
            return mat.craftingItem.copy();
        }
        return null;
    }

    public static ItemStack craftFletching(ItemStack stack) {
        FletchingMaterial mat = (FletchingMaterial)TConstructRegistry.getCustomMaterial(stack, FletchingMaterial.class);
        if (mat == null) {
            mat = (FletchingMaterial)TConstructRegistry.getCustomMaterial(stack, FletchlingLeafMaterial.class);
        }
        if (mat != null) {
            return mat.craftingItem.copy();
        }
        return null;
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.entityLiving instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.entityLiving).getCurrentEquippedItem()) != null && stack.getItem() == TinkerTools.battlesign) {
            if (!stack.hasTagCompound() || stack.getTagCompound().getCompoundTag("InfiTool").getBoolean("Broken")) {
                return;
            }
            DamageSource source = event.source;
            if (!(source.isUnblockable() || source.isMagicDamage() || source.isExplosion())) {
                if (source.isProjectile()) {
                    Entity projectile = source.getSourceOfDamage();
                    if (projectile == null) {
                        return;
                    }
                    Vec3 motion = Vec3.createVectorHelper((double)projectile.motionX, (double)projectile.motionY, (double)projectile.motionZ);
                    Vec3 look = player.getLookVec();
                    double strength = -look.dotProduct(motion.normalize());
                    if (strength < 0.1) {
                        return;
                    }
                    event.setCanceled(true);
                    double speed = projectile.motionX * projectile.motionX + projectile.motionY * projectile.motionY + projectile.motionZ * projectile.motionZ;
                    speed = Math.sqrt(speed);
                    speed = (speed + 2.0) * strength;
                    projectile.motionX = look.xCoord * speed;
                    projectile.motionY = look.yCoord * speed;
                    projectile.motionZ = look.zCoord * speed;
                    projectile.rotationYaw = (float)(Math.atan2(projectile.motionX, projectile.motionZ) * 180.0 / Math.PI);
                    projectile.rotationPitch = (float)(Math.atan2(projectile.motionY, speed) * 180.0 / Math.PI);
                    TConstruct.packetPipeline.sendToAll(new MovementUpdatePacket(projectile));
                    if (projectile instanceof EntityArrow) {
                        ((EntityArrow)projectile).shootingEntity = player;
                        projectile.motionX /= (double)-0.1f;
                        projectile.motionY /= (double)-0.1f;
                        projectile.motionZ /= (double)-0.1f;
                        if (projectile instanceof ProjectileBase) {
                            ((ProjectileBase)projectile).defused = false;
                        }
                    }
                } else {
                    Entity attacker = source.getEntity();
                    if (attacker != null) {
                        attacker.attackEntityFrom(DamageSource.causeThornsDamage((Entity)player), event.ammount);
                    }
                }
                AbilityHelper.damageTool(stack, (int)Math.ceil(event.ammount / 2.0f), (EntityLivingBase)player, false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        int beheading;
        ItemStack stack;
        if (event.entityLiving == null) {
            return;
        }
        if (event.recentlyHit) {
            EntityPlayer player;
            EntitySkeleton enemy;
            if (event.entityLiving instanceof EntitySkeleton) {
                enemy = (EntitySkeleton)event.entityLiving;
                if (event.source.damageType.equals("player") && (stack = (player = (EntityPlayer)event.source.getEntity()).getCurrentEquippedItem()) != null && stack.hasTagCompound() && stack.getItem() instanceof ToolCore) {
                    beheading = stack.getTagCompound().getCompoundTag("InfiTool").getInteger("Beheading");
                    if (stack.getItem() == TinkerTools.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && TConstruct.random.nextInt(100) < beheading * 10) {
                        ItemHelper.addDrops(event, new ItemStack(Items.skull, 1, enemy.getSkeletonType()));
                    }
                }
                if (enemy.getSkeletonType() == 1 && TConstruct.random.nextInt(Math.max(1, 5 - event.lootingLevel)) == 0) {
                    ItemHelper.addDrops(event, new ItemStack(TinkerTools.materials, 1, 8));
                }
            }
            if (event.entityLiving.getClass() == EntityZombie.class) {
                enemy = (EntityZombie)event.entityLiving;
                if (event.source.damageType.equals("player")) {
                    player = (EntityPlayer)event.source.getEntity();
                    stack = player.getCurrentEquippedItem();
                    if (stack != null && stack.hasTagCompound() && stack.getItem() instanceof ToolCore) {
                        beheading = stack.getTagCompound().getCompoundTag("InfiTool").getInteger("Beheading");
                        if (stack != null && stack.hasTagCompound() && stack.getItem() == TinkerTools.cleaver) {
                            beheading += 2;
                        }
                        if (beheading > 0 && TConstruct.random.nextInt(100) < beheading * 10) {
                            ItemHelper.addDrops(event, new ItemStack(Items.skull, 1, 2));
                        }
                    }
                    if (stack != null && stack.hasTagCompound() && stack.getItem() == TinkerTools.cleaver && TConstruct.random.nextInt(100) < 10) {
                        ItemHelper.addDrops(event, new ItemStack(Items.skull, 1, 2));
                    }
                }
            }
            if (event.entityLiving.getClass() == EntityCreeper.class) {
                enemy = (EntityCreeper)event.entityLiving;
                if (event.source.damageType.equals("player") && (stack = (player = (EntityPlayer)event.source.getEntity()).getCurrentEquippedItem()) != null && stack.hasTagCompound() && stack.getItem() instanceof ToolCore) {
                    beheading = stack.getTagCompound().getCompoundTag("InfiTool").getInteger("Beheading");
                    if (stack.getItem() == TinkerTools.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && TConstruct.random.nextInt(100) < beheading * 5) {
                        ItemHelper.addDrops(event, new ItemStack(Items.skull, 1, 4));
                    }
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer source;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (PHConstruct.dropPlayerHeads) {
                ItemStack dropStack = new ItemStack(Items.skull, 1, 3);
                NBTTagCompound nametag = new NBTTagCompound();
                nametag.setString("SkullOwner", player.getDisplayName());
                dropStack.setTagCompound(nametag);
                ItemHelper.addDrops(event, dropStack);
            } else if (event.source.damageType.equals("player") && (stack = (source = (EntityPlayer)event.source.getEntity()).getCurrentEquippedItem()) != null && stack.hasTagCompound() && stack.getItem() instanceof ToolCore) {
                beheading = stack.getTagCompound().getCompoundTag("InfiTool").getInteger("Beheading");
                if (stack.getItem() == TinkerTools.cleaver) {
                    beheading += 2;
                }
                if (beheading > 0 && TConstruct.random.nextInt(100) < beheading * 50) {
                    ItemStack dropStack = new ItemStack(Items.skull, 1, 3);
                    NBTTagCompound nametag = new NBTTagCompound();
                    nametag.setString("SkullOwner", player.getDisplayName());
                    dropStack.setTagCompound(nametag);
                    ItemHelper.addDrops(event, dropStack);
                }
            }
        }
    }

    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent evt) {
        if (evt.Name.equals("crystalQuartz")) {
            TinkerTools.modAttack.addStackToMatchList(evt.Ore, 2);
        } else if (evt.Name.equals("crystalCertusQuartz")) {
            TinkerTools.modAttack.addStackToMatchList(evt.Ore, 24);
        }
    }

    @SubscribeEvent
    public void damageToolsOnDeath(PlayerDropsEvent event) {
        if (!PHConstruct.deathPenality) {
            return;
        }
        EnumDifficulty difficulty = event.entityPlayer.worldObj.difficultySetting;
        if (difficulty == EnumDifficulty.PEACEFUL || difficulty == EnumDifficulty.EASY) {
            return;
        }
        int punishment = 20;
        if (difficulty == EnumDifficulty.HARD) {
            punishment = 10;
        }
        int derp = 1;
        if (event.entityPlayer.ticksExisted < 6000) {
            derp = TPlayerStats.get((EntityPlayer)event.entityPlayer).derpLevel;
            if (derp <= 0) {
                derp = 1;
            }
            punishment *= derp;
        }
        boolean damaged = false;
        for (EntityItem drop : event.drops) {
            if (!(drop.getEntityItem().getItem() instanceof ToolCore) || !drop.getEntityItem().hasTagCompound()) continue;
            NBTTagCompound tags = drop.getEntityItem().getTagCompound().getCompoundTag("InfiTool");
            int dur = tags.getInteger("TotalDurability");
            AbilityHelper.damageTool(drop.getEntityItem(), dur /= punishment, (EntityLivingBase)event.entityPlayer, true);
            damaged = true;
        }
        if (damaged) {
            ++derp;
        }
        TPlayerStats.get((EntityPlayer)event.entityPlayer).derpLevel = derp + 1;
    }
}

