/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.InventorySlab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.logic.CraftingStationLogic;
import tconstruct.tools.logic.PartBuilderLogic;
import tconstruct.tools.logic.PatternChestLogic;
import tconstruct.tools.logic.StencilTableLogic;
import tconstruct.tools.logic.ToolForgeLogic;
import tconstruct.tools.logic.ToolStationLogic;
import tconstruct.util.config.PHConstruct;

public class CraftingSlab
extends InventorySlab {
    public CraftingSlab(Material material) {
        super(material);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setHardness(2.0f);
        this.stepSound = Block.soundTypeWood;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"craftingstation_top", "craftingstation_slab_side", "craftingstation_bottom", "toolstation_top", "toolstation_slab_side", "toolstation_bottom", "partbuilder_oak_top", "partbuilder_slab_side", "partbuilder_oak_bottom", "stenciltable_oak_top", "stenciltable_slab_side", "stenciltable_oak_bottom", "patternchest_top", "patternchest_slab_side", "patternchest_bottom", "toolforge_top", "toolforge_slab_side", "toolforge_top"};
        return textureNames;
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icons[meta % 8 * 3 + this.getTextureIndex(side)];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 5) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY - 0.125), (double)((double)z + this.maxZ));
        }
        return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY), (double)((double)z + this.maxZ));
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata % 8) {
            case 0: {
                return new CraftingStationLogic();
            }
            case 1: {
                return new ToolStationLogic();
            }
            case 2: {
                return new PartBuilderLogic();
            }
            case 3: {
                return new StencilTableLogic();
            }
            case 4: {
                return new PatternChestLogic();
            }
            case 5: {
                return new ToolForgeLogic();
            }
        }
        return null;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.getBlockMetadata(x, y, z) % 8;
        switch (meta) {
            case 0: {
                return 11;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public void getSubBlocks(Item b, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 6; ++iter) {
            list.add(new ItemStack(b, 1, iter));
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        int meta;
        boolean keptInventory = false;
        if (stack.hasTagCompound()) {
            NBTTagCompound inventory = stack.getTagCompound().getCompoundTag("Inventory");
            TileEntity te = world.getTileEntity(x, y, z);
            if (inventory != null && te instanceof PatternChestLogic) {
                PatternChestLogic logic = (PatternChestLogic)te;
                logic.readInventoryFromNBT(inventory);
                logic.xCoord = x;
                logic.yCoord = y;
                logic.zCoord = z;
                keptInventory = true;
            }
        }
        if (!keptInventory && PHConstruct.freePatterns && (meta = world.getBlockMetadata(x, y, z)) == 4) {
            PatternChestLogic logic = (PatternChestLogic)world.getTileEntity(x, y, z);
            for (int i = 1; i <= 13; ++i) {
                logic.setInventorySlotContents(i - 1, new ItemStack(TinkerTools.woodPattern, 1, i));
            }
            logic.setInventorySlotContents(13, new ItemStack(TinkerTools.woodPattern, 1, 22));
        }
        super.onBlockPlacedBy(world, x, y, z, entityliving, stack);
    }

    public TileEntity createNewTileEntity(World var1, int metadata) {
        switch (metadata % 8) {
            case 0: {
                return new CraftingStationLogic();
            }
            case 1: {
                return new ToolStationLogic();
            }
            case 2: {
                return new PartBuilderLogic();
            }
            case 3: {
                return new StencilTableLogic();
            }
            case 4: {
                return new PatternChestLogic();
            }
            case 5: {
                return new ToolForgeLogic();
            }
        }
        return null;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        int meta;
        player.addExhaustion(0.025f);
        if (!world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops") && (meta = world.getBlockMetadata(x, y, z)) == 4) {
            ItemStack chest = new ItemStack((Block)this, 1, 4);
            NBTTagCompound inventory = new NBTTagCompound();
            PatternChestLogic logic = (PatternChestLogic)world.getTileEntity(x, y, z);
            logic.writeInventoryToNBT(inventory);
            NBTTagCompound baseTag = new NBTTagCompound();
            baseTag.setTag("Inventory", (NBTBase)inventory);
            chest.setTagCompound(baseTag);
            for (int i = 0; i < logic.getSizeInventory(); ++i) {
                logic.setInventorySlotContents(i, null);
            }
            if (!player.capabilities.isCreativeMode || player.isSneaking()) {
                float f = 0.7f;
                double d0 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, chest);
                entityitem.delayBeforeCanPickup = 10;
                world.spawnEntityInWorld((Entity)entityitem);
            }
        }
        return world.setBlockToAir(x, y, z);
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (meta != 4) {
            super.harvestBlock(world, player, x, y, z, meta);
        }
    }
}

