/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.entity;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Deprecated
public class ArrowEntity
extends EntityArrow
implements IEntityAdditionalSpawnData {
    public ItemStack returnStack;
    public float mass;
    public int baseDamage;
    private float knockbackStrengthMod;
    Random random = new Random();

    public ArrowEntity(World par1World) {
        super(par1World);
    }

    public ArrowEntity(World world, EntityLivingBase living, float baseSpeed, ItemStack stack) {
        super(world, living, baseSpeed);
        this.returnStack = stack;
        NBTTagCompound toolTag = stack.getTagCompound().getCompoundTag("InfiTool");
        this.mass = toolTag.getFloat("Mass");
        this.baseDamage = toolTag.getInteger("Attack");
    }

    public ArrowEntity(World world, double x, double y, double z, ItemStack stack) {
        super(world, x, y, z);
        this.returnStack = stack;
        NBTTagCompound toolTag = stack.getTagCompound().getCompoundTag("InfiTool");
        this.mass = toolTag.getFloat("Mass");
        this.baseDamage = toolTag.getInteger("Attack");
    }

    public void onCollideWithPlayer(EntityPlayer par1EntityPlayer) {
        if (!this.worldObj.isRemote && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.canBePickedUp == 1 || this.canBePickedUp == 2 && par1EntityPlayer.capabilities.isCreativeMode;
            if (this.canBePickedUp == 1 && !par1EntityPlayer.inventory.addItemStackToInventory(this.returnStack)) {
                flag = false;
            }
            if (flag) {
                this.playSound("random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                par1EntityPlayer.onItemPickup((Entity)this, 1);
                if (this.returnStack.stackSize <= 0 || this.canBePickedUp == 2) {
                    this.setDead();
                }
            }
        }
    }

    public void onUpdate() {
        this.onEntityUpdate();
        if (this.returnStack == null || this.returnStack.stackSize < 1) {
            this.setDead();
        }
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
        }
        Block i = this.worldObj.getBlock(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        i.setBlockBoundsBasedOnState((IBlockAccess)this.worldObj, this.field_145791_d, this.field_145792_e, this.field_145789_f);
        AxisAlignedBB axisalignedbb = i.getCollisionBoundingBoxFromPool(this.worldObj, this.field_145791_d, this.field_145792_e, this.field_145789_f);
        if (axisalignedbb != null && axisalignedbb.isVecInside(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            if (!this.worldObj.isRemote) {
                Block j = this.worldObj.getBlock(this.field_145791_d, this.field_145792_e, this.field_145789_f);
                int k = this.worldObj.getBlockMetadata(this.field_145791_d, this.field_145792_e, this.field_145789_f);
                if (j == this.field_145790_g && k == this.inData) {
                    ++this.ticksInGround;
                    if (this.ticksInGround == 120000) {
                        this.setDead();
                    }
                } else {
                    this.inGround = false;
                    this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                    this.ticksInGround = 0;
                    this.ticksInAir = 0;
                }
            }
        } else {
            float ySpeed;
            int l;
            ++this.ticksInAir;
            Vec3 vec3 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            Vec3 vec31 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            MovingObjectPosition movingobjectposition = this.worldObj.func_147447_a(vec3, vec31, false, true, false);
            vec3 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            vec31 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            if (movingobjectposition != null) {
                vec31 = Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord);
            }
            Entity entity = null;
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (l = 0; l < list.size(); ++l) {
                double d1;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(l);
                if (!entity1.canBeCollidedWith() || entity1 == this.shootingEntity && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.boundingBox.expand((double)(ySpeed = 0.3f), (double)ySpeed, (double)ySpeed)).calculateIntercept(vec3, vec31)) == null || !((d1 = vec3.distanceTo(movingobjectposition1.hitVec)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null && movingobjectposition.entityHit != null && movingobjectposition.entityHit instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.entityHit;
                if (entityplayer.capabilities.disableDamage || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).canAttackPlayer(entityplayer)) {
                    movingobjectposition = null;
                }
            }
            if (movingobjectposition != null) {
                if (movingobjectposition.entityHit != null) {
                    float speed = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
                    double damageSpeed = (double)speed * this.getDamage();
                    damageSpeed *= (double)this.baseDamage;
                    int damageInflicted = MathHelper.ceiling_double_int((double)(damageSpeed /= 5.0));
                    if (this.getIsCritical()) {
                        damageInflicted += this.rand.nextInt(damageInflicted / 2 + 2);
                    }
                    DamageSource damagesource = null;
                    damagesource = this.shootingEntity == null ? DamageSource.causeArrowDamage((EntityArrow)this, (Entity)this) : DamageSource.causeArrowDamage((EntityArrow)this, (Entity)this.shootingEntity);
                    if (this.isBurning() && !(movingobjectposition.entityHit instanceof EntityEnderman)) {
                        movingobjectposition.entityHit.setFire(5);
                    }
                    if (this.returnStack.hasTagCompound()) {
                        int drain;
                        int fireAspect = 0;
                        NBTTagCompound toolTags = this.returnStack.getTagCompound().getCompoundTag("InfiTool");
                        if (toolTags.hasKey("Fiery") || toolTags.hasKey("Lava")) {
                            fireAspect *= 4;
                            if (toolTags.hasKey("Fiery")) {
                                fireAspect += toolTags.getInteger("Fiery") / 5 + 1;
                            }
                            if (toolTags.getBoolean("Lava")) {
                                fireAspect += 3;
                            }
                            entity.setFire(fireAspect);
                        }
                        if ((drain = toolTags.getInteger("Necrotic") * 2) > 0 && this.shootingEntity != null && this.shootingEntity instanceof EntityLiving) {
                            ((EntityLiving)this.shootingEntity).heal((float)this.random.nextInt(drain + 1));
                        }
                    }
                    if (movingobjectposition.entityHit.attackEntityFrom(damagesource, (float)damageInflicted)) {
                        if (movingobjectposition.entityHit instanceof EntityLivingBase) {
                            float f3;
                            EntityLivingBase entityliving = (EntityLivingBase)movingobjectposition.entityHit;
                            if (!this.worldObj.isRemote) {
                                entityliving.setArrowCountInEntity(entityliving.getArrowCountInEntity() + 1);
                            }
                            if ((this.knockbackStrength > 0 || this.knockbackStrengthMod > 0.0f) && (f3 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) > 0.0f) {
                                float knockback = (float)this.knockbackStrength + this.knockbackStrengthMod;
                                movingobjectposition.entityHit.addVelocity(this.motionX * (double)this.knockbackStrength * (double)0.6f / (double)f3, 0.1, this.motionZ * (double)knockback * (double)0.6f / (double)f3);
                            }
                            damagesource = this.shootingEntity != null ? DamageSource.causeArrowDamage((EntityArrow)this, (Entity)this) : DamageSource.causeArrowDamage((EntityArrow)this, (Entity)this.shootingEntity);
                            if (this.shootingEntity != null && movingobjectposition.entityHit != this.shootingEntity && movingobjectposition.entityHit instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)this.shootingEntity).playerNetServerHandler.sendPacket((Packet)new S2BPacketChangeGameState(6, 0.0f));
                            }
                        }
                        this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                        if (!(movingobjectposition.entityHit instanceof EntityEnderman)) {
                            this.motionX = 0.0;
                            this.motionZ = 0.0;
                            if (movingobjectposition.entityHit instanceof EntityPlayer) {
                                EntityPlayer player = (EntityPlayer)movingobjectposition.entityHit;
                                if (this.canBePickedUp == 2 || player.inventory.addItemStackToInventory(this.returnStack)) {
                                    this.setDead();
                                }
                            } else if (movingobjectposition.entityHit instanceof EntityLivingBase) {
                                EntityLivingBase living = (EntityLivingBase)movingobjectposition.entityHit;
                                if (this.canBePickedUp == 2 || this.addItemStackToInventory(this.returnStack, living)) {
                                    this.setDead();
                                }
                            }
                        }
                    } else {
                        this.motionX *= (double)-0.1f;
                        this.motionY *= (double)-0.1f;
                        this.motionZ *= (double)-0.1f;
                        this.rotationYaw += 180.0f;
                        this.prevRotationYaw += 180.0f;
                        this.ticksInAir = 0;
                    }
                } else {
                    this.field_145791_d = movingobjectposition.blockX;
                    this.field_145792_e = movingobjectposition.blockY;
                    this.field_145789_f = movingobjectposition.blockZ;
                    this.field_145790_g = this.worldObj.getBlock(this.field_145791_d, this.field_145792_e, this.field_145789_f);
                    this.inData = this.worldObj.getBlockMetadata(this.field_145791_d, this.field_145792_e, this.field_145789_f);
                    this.motionX = (float)(movingobjectposition.hitVec.xCoord - this.posX);
                    this.motionY = (float)(movingobjectposition.hitVec.yCoord - this.posY);
                    this.motionZ = (float)(movingobjectposition.hitVec.zCoord - this.posZ);
                    float speed = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
                    this.posX -= this.motionX / (double)speed * (double)0.05f;
                    this.posY -= this.motionY / (double)speed * (double)0.05f;
                    this.posZ -= this.motionZ / (double)speed * (double)0.05f;
                    this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.arrowShake = 0;
                    this.setIsCritical(false);
                    if (this.field_145790_g != Blocks.air) {
                        this.field_145790_g.onEntityCollidedWithBlock(this.worldObj, this.field_145791_d, this.field_145792_e, this.field_145789_f, (Entity)this);
                    }
                }
            }
            if (this.getIsCritical()) {
                for (l = 0; l < 4; ++l) {
                    this.worldObj.spawnParticle("crit", this.posX + this.motionX * (double)l / 4.0, this.posY + this.motionY * (double)l / 4.0, this.posZ + this.motionZ * (double)l / 4.0, -this.motionX, -this.motionY + 0.2, -this.motionZ);
                }
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            float speed = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.rotationPitch = (float)(Math.atan2(this.motionY, speed) * 180.0 / Math.PI);
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float dropSpeed = 0.99f;
            float speedMod = 1.05f + this.mass / 1.26f / 6.0f;
            ySpeed = 0.05f * speedMod;
            if (this.isInWater()) {
                for (int j1 = 0; j1 < 4; ++j1) {
                    float f3 = 0.25f;
                    this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ);
                }
                dropSpeed = 0.8f;
            }
            this.motionX *= (double)dropSpeed;
            this.motionY *= (double)dropSpeed;
            this.motionZ *= (double)dropSpeed;
            this.motionY -= (double)ySpeed;
            this.setPosition(this.posX, this.posY, this.posZ);
            this.func_145775_I();
        }
    }

    public boolean addItemStackToInventory(ItemStack par1ItemStack, EntityLivingBase living) {
        if (par1ItemStack == null) {
            return false;
        }
        try {
            int stackSize;
            do {
                stackSize = par1ItemStack.stackSize;
                par1ItemStack.stackSize = this.storePartialItemStack(par1ItemStack, living);
            } while (par1ItemStack.stackSize > 0 && par1ItemStack.stackSize < stackSize);
            return par1ItemStack.stackSize < stackSize;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport((Throwable)throwable, (String)"Adding item to inventory");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Item being added");
            crashreportcategory.addCrashSection("Item data", (Object)par1ItemStack.getItemDamage());
            throw new ReportedException(crashreport);
        }
    }

    public int getFirstEmptyStack(EntityLivingBase living) {
        for (int i = 0; i < 5; ++i) {
            if (living.getEquipmentInSlot(i) != null) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack par1ItemStack, EntityLivingBase living) {
        int stackSize = par1ItemStack.stackSize;
        if (!par1ItemStack.isStackable()) {
            int slotID = this.getFirstEmptyStack(living);
            if (slotID < 0) {
                return stackSize;
            }
            living.setCurrentItemOrArmor(slotID, par1ItemStack.copy());
            if (living instanceof EntityLiving) {
                ((EntityLiving)living).setEquipmentDropChance(slotID, 2.0f);
            }
            return 0;
        }
        int slotID = this.storeItemStack(par1ItemStack, living);
        if (slotID < 0) {
            slotID = this.getFirstEmptyStack(living);
        }
        if (slotID < 0) {
            return stackSize;
        }
        ItemStack stack = living.getEquipmentInSlot(slotID);
        if (stack == null) {
            living.setCurrentItemOrArmor(slotID, par1ItemStack.copy());
            if (living instanceof EntityLiving) {
                ((EntityLiving)living).setEquipmentDropChance(slotID, 2.0f);
            }
            return 0;
        }
        int l = stackSize;
        if (stackSize > stack.getMaxStackSize() - stack.stackSize) {
            l = stack.getMaxStackSize() - stack.stackSize;
        }
        if (l > 64 - stack.stackSize) {
            l = 64 - stack.stackSize;
        }
        if (l == 0) {
            return stackSize;
        }
        stackSize -= l;
        stack.stackSize += l;
        living.setCurrentItemOrArmor(slotID, stack);
        if (living instanceof EntityLiving) {
            ((EntityLiving)living).setEquipmentDropChance(slotID, 2.0f);
        }
        return stackSize;
    }

    private int storeItemStack(ItemStack par1ItemStack, EntityLivingBase living) {
        for (int slotID = 0; slotID < 5; ++slotID) {
            ItemStack stack = living.getEquipmentInSlot(slotID);
            if (stack == null || !stack.isItemEqual(par1ItemStack) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)par1ItemStack) || !stack.isStackable() || stack.stackSize >= stack.getMaxStackSize()) continue;
            return slotID;
        }
        return -1;
    }

    public void setKnockbackModStrength(float par1) {
        this.knockbackStrengthMod = par1;
    }

    public void writeEntityToNBT(NBTTagCompound tags) {
        super.writeEntityToNBT(tags);
        tags.setTag("Throwable", (NBTBase)this.returnStack.writeToNBT(new NBTTagCompound()));
    }

    public void readEntityFromNBT(NBTTagCompound tags) {
        super.readEntityFromNBT(tags);
        this.returnStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)tags.getCompoundTag("Throwable"));
    }

    public void writeSpawnData(ByteBuf data) {
        if (!this.returnStack.hasTagCompound()) {
            this.kill();
        }
        NBTTagCompound tags = this.returnStack.getTagCompound().getCompoundTag("InfiTool");
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.returnStack);
        data.writeFloat(this.rotationYaw);
        data.writeFloat(this.mass);
        data.writeInt(tags.getInteger("RenderHandle"));
        data.writeInt(tags.getInteger("RenderHead"));
        data.writeInt(tags.getInteger("RenderAccessory"));
        int effects = 0;
        if (tags.hasKey("Effect1")) {
            ++effects;
        }
        if (tags.hasKey("Effect2")) {
            ++effects;
        }
        if (tags.hasKey("Effect3")) {
            ++effects;
        }
        if (tags.hasKey("Effect4")) {
            ++effects;
        }
        if (tags.hasKey("Effect5")) {
            ++effects;
        }
        if (tags.hasKey("Effect6")) {
            ++effects;
        }
        data.writeInt(effects);
        switch (effects) {
            case 6: {
                data.writeInt(tags.getInteger("Effect6"));
            }
            case 5: {
                data.writeInt(tags.getInteger("Effect5"));
            }
            case 4: {
                data.writeInt(tags.getInteger("Effect4"));
            }
            case 3: {
                data.writeInt(tags.getInteger("Effect3"));
            }
            case 2: {
                data.writeInt(tags.getInteger("Effect2"));
            }
            case 1: {
                data.writeInt(tags.getInteger("Effect1"));
            }
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.returnStack = ByteBufUtils.readItemStack((ByteBuf)data);
        this.rotationYaw = data.readFloat();
        this.mass = data.readFloat();
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound toolTag = new NBTTagCompound();
        toolTag.setInteger("RenderHandle", data.readInt());
        toolTag.setInteger("RenderHead", data.readInt());
        toolTag.setInteger("RenderAccessory", data.readInt());
        switch (data.readInt()) {
            case 6: {
                toolTag.setInteger("Effect6", data.readInt());
            }
            case 5: {
                toolTag.setInteger("Effect5", data.readInt());
            }
            case 4: {
                toolTag.setInteger("Effect4", data.readInt());
            }
            case 3: {
                toolTag.setInteger("Effect3", data.readInt());
            }
            case 2: {
                toolTag.setInteger("Effect2", data.readInt());
            }
            case 1: {
                toolTag.setInteger("Effect1", data.readInt());
            }
        }
        compound.setTag("InfiTool", (NBTBase)toolTag);
        this.returnStack.setTagCompound(compound);
    }

    public ItemStack getEntityItem() {
        return this.returnStack;
    }
}

