/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class LaunchedPotion
extends EntityThrowable {
    private ItemStack potionDamage;

    public LaunchedPotion(World par1World) {
        super(par1World);
    }

    public LaunchedPotion(World par1World, EntityLivingBase par2EntityLiving, int par3) {
        this(par1World, par2EntityLiving, new ItemStack((Item)Items.potionitem, 1, par3));
    }

    public LaunchedPotion(World par1World, EntityLivingBase par2EntityLiving, ItemStack par3ItemStack) {
        super(par1World, par2EntityLiving);
        this.potionDamage = par3ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public LaunchedPotion(World par1World, double par2, double par4, double par6, int par8) {
        this(par1World, par2, par4, par6, new ItemStack((Item)Items.potionitem, 1, par8));
    }

    public LaunchedPotion(World par1World, double par2, double par4, double par6, ItemStack par8ItemStack) {
        super(par1World, par2, par4, par6);
        this.potionDamage = par8ItemStack;
    }

    protected float getGravityVelocity() {
        return 0.05f;
    }

    protected float func_70182_d() {
        return 1.0f;
    }

    protected float func_70183_g() {
        return -10.0f;
    }

    public void setPotionDamage(int par1) {
        if (this.potionDamage == null) {
            this.potionDamage = new ItemStack((Item)Items.potionitem, 1, 0);
        }
        this.potionDamage.setItemDamage(par1);
    }

    public int getPotionDamage() {
        if (this.potionDamage == null) {
            this.potionDamage = new ItemStack((Item)Items.potionitem, 1, 0);
        }
        return this.potionDamage.getItemDamage();
    }

    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (!this.worldObj.isRemote) {
            AxisAlignedBB axisalignedbb;
            List list1;
            List list = Items.potionitem.getEffects(this.potionDamage);
            if (list != null && !list.isEmpty() && (list1 = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb = this.boundingBox.expand(4.0, 2.0, 4.0))) != null && !list1.isEmpty()) {
                for (EntityLivingBase entityliving : list1) {
                    double d0 = this.getDistanceSqToEntity((Entity)entityliving);
                    if (!(d0 < 16.0)) continue;
                    double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                    if (entityliving == par1MovingObjectPosition.entityHit) {
                        d1 = 1.0;
                    }
                    for (PotionEffect potioneffect : list) {
                        int i = potioneffect.getPotionID();
                        if (Potion.potionTypes[i].isInstant()) {
                            Potion.potionTypes[i].affectEntity(this.getThrower(), entityliving, potioneffect.getAmplifier(), d1);
                            continue;
                        }
                        int j = (int)(d1 * (double)potioneffect.getDuration() + 0.5);
                        if (j <= 20) continue;
                        entityliving.addPotionEffect(new PotionEffect(i, j, potioneffect.getAmplifier()));
                    }
                }
            }
            this.worldObj.playAuxSFX(2002, (int)Math.round(this.posX), (int)Math.round(this.posY), (int)Math.round(this.posZ), this.getPotionDamage());
            this.setDead();
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasKey("Potion")) {
            this.potionDamage = ItemStack.loadItemStackFromNBT((NBTTagCompound)par1NBTTagCompound.getCompoundTag("Potion"));
        } else {
            this.setPotionDamage(par1NBTTagCompound.getInteger("potionValue"));
        }
        if (this.potionDamage == null) {
            this.setDead();
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        if (this.potionDamage != null) {
            par1NBTTagCompound.setTag("Potion", (NBTBase)this.potionDamage.writeToNBT(new NBTTagCompound()));
        }
    }
}

