/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.entity;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import tconstruct.library.tools.AbilityHelper;

@Deprecated
public class RotatingBase
extends Entity
implements IEntityAdditionalSpawnData {
    public int age = 0;
    public int hoverStart = 0;
    public int texID = 0;
    public int tex2ID = 48;
    public ItemStack returnStack;
    public int returnStackSlot = -1;
    public boolean hasHitGround = false;
    public boolean hasHitMob = false;
    public float prevBoomerangRotation;
    public float boomerangRotation;
    public Entity returnsTo;
    public int damageDealt = 4;
    public int maxGroundTicks = 2400;
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected Block inTile = Blocks.air;
    public int arrowShake;
    public EntityPlayer owner;
    protected int ticksInGround;
    protected int ticksInAir;
    public boolean doNotRetrieve;

    public RotatingBase(World world) {
        super(world);
        this.onGround = false;
        this.arrowShake = 0;
        this.ticksInAir = 0;
        this.setSize(0.5f, 0.5f);
    }

    public RotatingBase(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1, d2);
        this.yOffset = 0.0f;
    }

    public RotatingBase(World world, EntityPlayer entityliving, float f, float f1) {
        this(world);
        this.owner = entityliving;
        this.setLocationAndAngles(entityliving.posX, entityliving.posY + (double)entityliving.getEyeHeight(), entityliving.posZ, entityliving.rotationYaw, entityliving.rotationPitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * 3.141593f)) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * 3.141593f)) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * 3.141593f));
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * 3.141593f));
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * 3.141593f - 0.2f));
        this.setArrowHeading(this.motionX, this.motionY, this.motionZ, f, f1);
    }

    protected void entityInit() {
    }

    public void damageItem(int i, boolean flag) {
        if (!flag) {
            return;
        }
        if (this.returnStack.stackSize < 1) {
            for (int j = 0; j < 8; ++j) {
                this.worldObj.spawnParticle("snowballpoof", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void determineRotation() {
        this.rotationPitch = -57.29578f * (float)Math.atan2(this.motionY, this.motionX);
        double d = Math.sqrt((double)(this.rotationYaw * this.rotationYaw) + this.motionY * this.motionY);
        this.prevRotationYaw = -57.29578f * (float)Math.atan2(this.motionZ, d);
    }

    public void onHit(MovingObjectPosition movingobjectposition) {
    }

    public void setArrowHeading(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.sqrt_double((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d2 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        this.motionX = d *= (double)f;
        this.motionY = d1 *= (double)f;
        this.motionZ = d2 *= (double)f;
        float f3 = MathHelper.sqrt_double((double)(d * d + d2 * d2));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.ticksInGround = 0;
    }

    public void setVelocity(double d, double d1, double d2) {
        this.motionX = d;
        this.motionY = d1;
        this.motionZ = d2;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(d * d + d2 * d2));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f) * 180.0 / 3.1415927410125732);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.onGround) {
            Block i = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile);
            if (i != this.inTile) {
                this.onGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            } else {
                if (!this.hasHitGround) {
                    this.hasHitGround = true;
                    this.damageItem(1, true);
                }
                return;
            }
            this.ticksInGround = 0;
            this.ticksInAir = 0;
            return;
        }
        ++this.ticksInAir;
        Vec3 vec3d = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        Vec3 vec3d1 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec3d, vec3d1);
        vec3d = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        vec3d1 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        if (movingobjectposition != null) {
            vec3d1 = Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord);
        }
        Entity entity = null;
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int j = 0; j < list.size(); ++j) {
            double d1;
            float f3;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition movingobjectposition2;
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.canBeCollidedWith() || entity1 == this.owner && this.ticksInAir < 5 || (movingobjectposition2 = (axisalignedbb = entity1.boundingBox.expand((double)(f3 = 0.3f), (double)f3, (double)f3)).calculateIntercept(vec3d, vec3d1)) == null || !((d1 = vec3d.distanceTo(movingobjectposition2.hitVec)) < d) && d != 0.0) continue;
            entity = entity1;
            d = d1;
        }
        if (entity != null) {
            MovingObjectPosition movingobjectposition1 = new MovingObjectPosition(entity);
            this.onHit(movingobjectposition1);
        }
        if (movingobjectposition != null) {
            this.onHit(movingobjectposition);
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f1 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f1) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f2 = 0.99f;
        float f4 = 0.03f;
        if (this.isInWater()) {
            for (int k = 0; k < 4; ++k) {
                float f5 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f5, this.posY - this.motionY * (double)f5, this.posZ - this.motionZ * (double)f5, this.motionX, this.motionY, this.motionZ);
            }
            f2 = 0.8f;
        }
        this.motionX *= (double)f2;
        this.motionY *= (double)f2;
        this.motionZ *= (double)f2;
        this.motionY -= (double)f4;
        this.setPosition(this.posX, this.posY, this.posZ);
        if (!this.onGround) {
            this.prevBoomerangRotation = this.boomerangRotation;
            this.boomerangRotation += 36.0f;
            while (this.boomerangRotation > 360.0f) {
                this.boomerangRotation -= 360.0f;
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound tags) {
        tags.setTag("Throwable", (NBTBase)this.returnStack.writeToNBT(new NBTTagCompound()));
        tags.setShort("xTile", (short)this.xTile);
        tags.setShort("yTile", (short)this.yTile);
        tags.setShort("zTile", (short)this.zTile);
        tags.setString("inTile", this.inTile.getUnlocalizedName());
        tags.setByte("shake", (byte)this.arrowShake);
        tags.setByte("onGround", (byte)(this.onGround ? 1 : 0));
        tags.setBoolean("Retrieval", this.doNotRetrieve);
    }

    public void readEntityFromNBT(NBTTagCompound tags) {
        this.returnStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)tags.getCompoundTag("Throwable"));
        this.xTile = tags.getShort("xTile");
        this.yTile = tags.getShort("yTile");
        this.zTile = tags.getShort("zTile");
        this.arrowShake = tags.getByte("shake") & 0xFF;
        this.onGround = tags.getByte("onGround") == 1;
        this.doNotRetrieve = tags.getBoolean("Retrieval");
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        this.onCollideWithPlayer(entityplayer, true);
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer, boolean flag) {
        if (this.returnStack == null || this.returnStack.stackSize == 0 || this.worldObj.isRemote) {
            return;
        }
        if (!flag || this.onGround && this.arrowShake <= 0) {
            if (!flag || this.returnsTo != null && !this.returnsTo.isDead && this.returnsTo != entityplayer) {
                return;
            }
            if (!this.doNotRetrieve) {
                AbilityHelper.addToInv(entityplayer, this.returnStack, true);
            }
            this.worldObj.playSoundAtEntity((Entity)this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.onItemPickup((Entity)this, 1);
            this.kill();
        }
    }

    public float getShadowSize() {
        return 0.0f;
    }

    public ItemStack getEntityItem() {
        return this.returnStack;
    }

    public void writeSpawnData(ByteBuf data) {
        NBTTagCompound tags = this.returnStack.getTagCompound().getCompoundTag("InfiTool");
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.returnStack);
        data.writeFloat(this.rotationYaw);
        data.writeInt(tags.getInteger("RenderHandle"));
        data.writeInt(tags.getInteger("RenderHead"));
        data.writeInt(tags.getInteger("RenderAccessory"));
        data.writeInt(tags.getInteger("RenderExtra"));
        int effects = 0;
        if (tags.hasKey("Effect1")) {
            ++effects;
        }
        if (tags.hasKey("Effect2")) {
            ++effects;
        }
        if (tags.hasKey("Effect3")) {
            ++effects;
        }
        if (tags.hasKey("Effect4")) {
            ++effects;
        }
        if (tags.hasKey("Effect5")) {
            ++effects;
        }
        if (tags.hasKey("Effect6")) {
            ++effects;
        }
        data.writeInt(effects);
        switch (effects) {
            case 6: {
                data.writeInt(tags.getInteger("Effect6"));
            }
            case 5: {
                data.writeInt(tags.getInteger("Effect5"));
            }
            case 4: {
                data.writeInt(tags.getInteger("Effect4"));
            }
            case 3: {
                data.writeInt(tags.getInteger("Effect3"));
            }
            case 2: {
                data.writeInt(tags.getInteger("Effect2"));
            }
            case 1: {
                data.writeInt(tags.getInteger("Effect1"));
            }
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.returnStack = ByteBufUtils.readItemStack((ByteBuf)data);
        this.rotationYaw = data.readFloat();
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound toolTag = new NBTTagCompound();
        toolTag.setInteger("RenderHandle", data.readInt());
        toolTag.setInteger("RenderHead", data.readInt());
        toolTag.setInteger("RenderAccessory", data.readInt());
        toolTag.setInteger("RenderExtra", data.readInt());
        switch (data.readInt()) {
            case 6: {
                toolTag.setInteger("Effect6", data.readInt());
            }
            case 5: {
                toolTag.setInteger("Effect5", data.readInt());
            }
            case 4: {
                toolTag.setInteger("Effect4", data.readInt());
            }
            case 3: {
                toolTag.setInteger("Effect3", data.readInt());
            }
            case 2: {
                toolTag.setInteger("Effect2", data.readInt());
            }
            case 1: {
                toolTag.setInteger("Effect1", data.readInt());
            }
        }
        compound.setTag("InfiTool", (NBTBase)toolTag);
        this.returnStack.setTagCompound(compound);
    }
}

