/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.HarvestLevels;
import tconstruct.tools.gui.ToolStationGuiHelper;
import tconstruct.tools.logic.CraftingStationLogic;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class CraftingStationGui
extends GuiContainer
implements INEIGuiHandler {
    public boolean active;
    public String toolName;
    public GuiTextField text;
    public String title;
    public String body = "";
    CraftingStationLogic logic;
    public static final int CHEST_WIDTH = 116;
    private int craftingLeft = 0;
    private int craftingTop = 0;
    private int craftingTextLeft = 0;
    private int descLeft = 0;
    private int descTop = 0;
    private int descTextLeft = 0;
    private int chestLeft = 0;
    private int chestTop = 0;
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/tinkertable.png");
    private static final ResourceLocation description = new ResourceLocation("tinker", "textures/gui/description.png");
    private static final ResourceLocation icons = new ResourceLocation("tinker", "textures/gui/icons.png");
    private static final ResourceLocation chest = new ResourceLocation("tinker", "textures/gui/chestside.png");

    public CraftingStationGui(InventoryPlayer inventory, CraftingStationLogic logic, World world, int x, int y, int z) {
        super(logic.getGuiContainer(inventory, world, x, y, z));
        this.logic = logic;
        this.title = "\u00a7n" + StatCollector.translateToLocal((String)"gui.toolforge1");
        this.body = StatCollector.translateToLocal((String)"gui.toolforge2");
        this.toolName = "";
    }

    public void initGui() {
        super.initGui();
        this.xSize = 176;
        this.ySize = 166;
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.craftingLeft = this.guiLeft;
        this.craftingTop = this.guiTop;
        if (this.logic.tinkerTable) {
            this.descLeft = this.guiLeft + 176;
            this.descTop = this.craftingTop;
        }
        if (this.logic.chest != null) {
            this.xSize += 116;
            this.guiLeft -= 116;
            this.chestLeft = this.guiLeft;
            this.chestTop = this.craftingTop;
            if (this.logic.doubleChest != null) {
                this.ySize = 187;
            }
        }
        this.craftingTextLeft = this.craftingLeft - this.guiLeft;
        this.descTextLeft = this.descLeft - this.guiLeft;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        if (this.logic.chest != null) {
            TileEntity te;
            if (this.logic.chest.get() instanceof TileEntity && (te = (TileEntity)this.logic.chest.get()).getWorldObj().getTileEntity(te.xCoord, te.yCoord, te.zCoord) == null && te.getWorldObj().isRemote) {
                this.mc.thePlayer.closeScreen();
                return;
            }
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)((IInventory)this.logic.chest.get()).getInventoryName()), 8, 6, 0x202020);
        }
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)(this.logic.tinkerTable ? "crafters.TinkerTable" : this.logic.getInvName())), this.craftingTextLeft + 8, 6, 0x202020);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), this.craftingTextLeft + 8, 72, 0x202020);
        if (this.logic.tinkerTable) {
            if (this.logic.isStackInSlot(0)) {
                this.drawToolStats(this.logic.getStackInSlot(0));
            } else if (this.logic.isStackInSlot(5)) {
                if (!(this.logic.isStackInSlot(1) || this.logic.isStackInSlot(2) || this.logic.isStackInSlot(3) || this.logic.isStackInSlot(4) || this.logic.isStackInSlot(6) || this.logic.isStackInSlot(7) || this.logic.isStackInSlot(8) || this.logic.isStackInSlot(9))) {
                    this.drawToolStats(this.logic.getStackInSlot(5));
                } else {
                    this.drawToolInformation();
                }
            } else {
                this.drawToolInformation();
            }
        }
    }

    void drawToolStats(ItemStack stack) {
        ToolMaterial material;
        int matID;
        if (stack.getItem() instanceof IModifyable) {
            ToolStationGuiHelper.drawToolStats(stack, this.descTextLeft + 10, 0);
        }
        if ((matID = PatternBuilder.instance.getPartID(stack)) != Short.MAX_VALUE && matID > 0 && (material = TConstructRegistry.getMaterial(matID)) != null) {
            this.drawMaterialStats(material);
        }
    }

    protected void drawMaterialStats(ToolMaterial materialEnum) {
        String heart;
        int baseX = this.descTextLeft + 8;
        int baseY = 8;
        String centerTitle = "\u00a7n" + materialEnum.localizedName();
        this.drawCenteredString(this.fontRendererObj, centerTitle, baseX + 55, 8, 0xFFFFFF);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter4") + materialEnum.durability(), baseX, 24, 0xFFFFFF);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter5") + materialEnum.handleDurability() + "x", baseX, 35, 0xFFFFFF);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter6") + (float)materialEnum.toolSpeed() / 100.0f, baseX, 46, 0xFFFFFF);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter7") + HarvestLevels.getHarvestLevelName(materialEnum.harvestLevel()), baseX, 57, 0xFFFFFF);
        int attack = materialEnum.attack();
        String string = heart = attack == 2 ? StatCollector.translateToLocal((String)"gui.partcrafter8") : StatCollector.translateToLocal((String)"gui.partcrafter9");
        if (attack % 2 == 0) {
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter10") + attack / 2 + heart, baseX, 68, 0xFFFFFF);
        } else {
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter10") + (float)attack / 2.0f + heart, baseX, 68, 0xFFFFFF);
        }
    }

    void drawToolInformation() {
        int offsetX = this.descTextLeft + 63;
        this.drawCenteredString(this.fontRendererObj, this.title, offsetX, 8, 0xFFFFFF);
        this.fontRendererObj.drawSplitString(this.body, offsetX - 56, 24, 115, 0xFFFFFF);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(background);
        this.drawTexturedModalRect(this.craftingLeft, this.craftingTop, 0, 0, 176, 166);
        if (this.active) {
            this.drawTexturedModalRect(this.craftingLeft + 62, this.craftingTop, 0, 166, 112, 22);
        }
        this.mc.getTextureManager().bindTexture(icons);
        if (this.logic.tinkerTable && !this.logic.isStackInSlot(5)) {
            this.drawTexturedModalRect(this.craftingLeft + 47, this.craftingTop + 33, 0, 233, 18, 18);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(icons);
        if (this.logic.chest != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.getTextureManager().bindTexture(chest);
            if (this.logic.doubleChest == null) {
                this.drawTexturedModalRect(this.chestLeft, this.chestTop, 0, 0, 122, 114);
            } else {
                this.drawTexturedModalRect(this.chestLeft, this.chestTop, 125, 0, 122, 187);
            }
        }
        if (this.logic.tinkerTable) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.getTextureManager().bindTexture(description);
            this.drawTexturedModalRect(this.descLeft, this.descTop, 0, 0, 126, 172);
        }
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showWidgets = this.width - this.xSize >= 107;
        if (this.guiLeft < 58) {
            currentVisibility.showStateButtons = false;
        }
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (y + h - 4 < this.guiTop || y + 4 > this.guiTop + this.ySize) {
            return false;
        }
        return x + 4 <= this.guiLeft + this.xSize + (this.logic.tinkerTable ? 126 : 0);
    }

    public boolean hasChest() {
        return this.logic.chest != null;
    }
}

