/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.inventory;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.library.event.ToolCraftedEvent;
import tconstruct.library.modifier.IModifyable;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.inventory.SlotToolForge;
import tconstruct.tools.inventory.ToolStationContainer;
import tconstruct.tools.logic.ToolForgeLogic;
import tconstruct.tools.logic.ToolStationLogic;

public class ToolForgeContainer
extends ToolStationContainer {
    public ToolForgeContainer(InventoryPlayer inventoryplayer, ToolForgeLogic logic) {
        super(inventoryplayer, logic);
    }

    @Override
    public void initializeContainer(InventoryPlayer inventoryplayer, ToolStationLogic builderlogic) {
        int column;
        this.invPlayer = inventoryplayer;
        this.logic = builderlogic;
        this.toolSlot = new SlotToolForge(inventoryplayer.player, (IInventory)this.logic, 0, 225, 38);
        this.addSlotToContainer(this.toolSlot);
        this.slots = new Slot[]{new Slot((IInventory)this.logic, 1, 167, 29), new Slot((IInventory)this.logic, 2, 169, 29), new Slot((IInventory)this.logic, 3, 167, 47), new Slot((IInventory)this.logic, 4, 149, 47)};
        for (int iter = 0; iter < 4; ++iter) {
            this.addSlotToContainer(this.slots[iter]);
        }
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, row + column * 9 + 9, 118 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, column, 118 + column * 18, 142));
        }
    }

    @Override
    public void resetSlots(int[] posX, int[] posY) {
        int column;
        this.inventorySlots.clear();
        this.inventoryItemStacks.clear();
        this.addSlotToContainer(this.toolSlot);
        for (int iter = 0; iter < 4; ++iter) {
            this.slots[iter].xDisplayPosition = posX[iter] + 111;
            this.slots[iter].yDisplayPosition = posY[iter] + 1;
            this.addSlotToContainer(this.slots[iter]);
        }
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)this.invPlayer, row + column * 9 + 9, 118 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)this.invPlayer, column, 118 + column * 18, 142));
        }
    }

    @Override
    protected void craftTool(ItemStack stack) {
        if (stack.getItem() instanceof IModifyable) {
            NBTTagCompound tags = stack.getTagCompound().getCompoundTag(((IModifyable)stack.getItem()).getBaseTagName());
            Boolean full = this.logic.getStackInSlot(2) != null || this.logic.getStackInSlot(3) != null || this.logic.getStackInSlot(4) != null;
            for (int i = 2; i <= 4; ++i) {
                this.logic.decrStackSize(i, 1);
            }
            ItemStack compare = this.logic.getStackInSlot(1);
            int amount = compare.getItem() instanceof IModifyable ? compare.stackSize : 1;
            this.logic.decrStackSize(1, amount);
            EntityPlayer player = this.invPlayer.player;
            if (!player.worldObj.isRemote && full.booleanValue()) {
                player.worldObj.playAuxSFX(1021, (int)player.posX, (int)player.posY, (int)player.posZ, 0);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ToolCraftedEvent((IInventory)this.logic, player, stack));
        } else {
            ItemStack stack2 = this.logic.getStackInSlot(1);
            int amount = this.logic.getStackInSlot((int)1).stackSize;
            this.logic.decrStackSize(1, amount);
            if (!ToolStationLogic.canRename(stack2.getTagCompound(), stack2)) {
                for (int i = 0; i < this.logic.getSizeInventory(); ++i) {
                    if (this.logic.getStackInSlot(i) == null || this.logic.getStackInSlot(i).getItem() != Items.name_tag) continue;
                    this.logic.decrStackSize(i, 1);
                    break;
                }
            }
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        Block block = this.logic.getWorldObj().getBlock(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord);
        if (block != TinkerTools.toolForge && block != TinkerTools.craftingSlabWood) {
            return false;
        }
        return this.logic.isUseableByPlayer(entityplayer);
    }
}

