/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.logic;

import cpw.mods.fml.common.registry.GameRegistry;
import mantle.blocks.BlockUtils;
import mantle.blocks.iface.IActiveLogic;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import tconstruct.tools.inventory.FrypanContainer;
import tconstruct.tools.logic.EquipLogic;

public class FrypanLogic
extends EquipLogic
implements IActiveLogic {
    boolean active = false;
    public int fuel;
    public int fuelGague;
    public int progress;

    public FrypanLogic() {
        super(10);
    }

    public String getDefaultName() {
        return "crafters.frypan";
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / 1000;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = 1000;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void updateEntity() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel <= 0 && this.canCook()) {
            this.fuel = this.fuelGague = (int)((double)FrypanLogic.getItemBurnTime(this.inventory[1]) * 2.5);
            if (this.fuel > 0) {
                if (this.inventory[1].getItem().hasContainerItem(this.inventory[1])) {
                    this.inventory[1] = this.inventory[1].getItem().getContainerItem(this.inventory[1]);
                } else {
                    --this.inventory[1].stackSize;
                }
                if (this.inventory[1].stackSize <= 0) {
                    this.inventory[1] = null;
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canCook()) {
            ++this.progress;
            if (this.progress >= 1000) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (burning != this.isBurning()) {
            this.setActive(this.isBurning());
            updateInventory = true;
        }
        if (updateInventory) {
            this.markDirty();
        }
    }

    public void cookItems() {
        if (!this.canCook()) {
            return;
        }
        for (int id = 2; id < 10; ++id) {
            int ids;
            ItemStack result;
            if (!this.canCook() || (result = this.getResultFor(this.inventory[id])) == null) continue;
            boolean placed = false;
            for (ids = 2; ids < 10 && !placed; ++ids) {
                if (this.inventory[ids] == null || !this.inventory[ids].isItemEqual(result) || this.inventory[ids].stackSize >= this.inventory[ids].getMaxStackSize()) continue;
                if (this.inventory[ids].stackSize + result.stackSize <= this.inventory[ids].getMaxStackSize()) {
                    this.inventory[ids].stackSize += result.stackSize;
                    placed = true;
                    continue;
                }
                int decrement = this.inventory[ids].getMaxStackSize() - this.inventory[ids].stackSize;
                this.inventory[ids].stackSize = this.inventory[ids].getMaxStackSize();
                result.stackSize -= decrement;
            }
            for (ids = 2; !placed && ids < 10; ++ids) {
                if (this.inventory[ids] != null) continue;
                this.inventory[ids] = result;
                placed = true;
            }
            if (!placed) continue;
            this.decrStackSize(id, 1);
        }
    }

    public boolean canCook() {
        for (int id = 2; id < 10; ++id) {
            ItemStack result;
            if (this.inventory[id] == null || (result = this.getResultFor(this.inventory[id])) == null) continue;
            for (int slotid = 2; slotid < 10; ++slotid) {
                if (this.inventory[slotid] == null) {
                    return true;
                }
                if (!this.inventory[slotid].isItemEqual(result) || this.inventory[slotid].stackSize + result.stackSize > this.inventory[slotid].getMaxStackSize()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack result = FurnaceRecipes.smelting().getSmeltingResult(stack);
        if (result != null && result.getItem() instanceof ItemFood) {
            return result.copy();
        }
        return null;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.getItem();
        if (stack.getItem() instanceof ItemBlock && BlockUtils.getBlockFromItem((Item)item) != null) {
            Block block = BlockUtils.getBlockFromItem((Item)item);
            if (block == Blocks.wooden_slab) {
                return 150;
            }
            if (block == Blocks.log) {
                return 2400;
            }
            if (block.getMaterial() == Material.wood) {
                return 300;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item == Items.stick) {
            return 100;
        }
        if (item == Items.coal) {
            return 800;
        }
        if (item == Items.lava_bucket) {
            return 20000;
        }
        if (new ItemStack(item).equals(new ItemStack(Blocks.sapling))) {
            return 100;
        }
        if (item == Items.blaze_rod) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.active = tags.getBoolean("Active");
        this.fuel = tags.getInteger("Fuel");
        this.fuelGague = tags.getInteger("FuelGague");
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        tags.setBoolean("Active", this.active);
        tags.setInteger("Fuel", this.fuel);
        tags.setInteger("FuelGague", this.fuelGague);
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new FrypanContainer(inventoryplayer.player, this);
    }

    public String getInventoryName() {
        return this.getDefaultName();
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }
}

