/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import tconstruct.TConstruct;
import tconstruct.tools.TinkerTools;
import tconstruct.util.ItemHelper;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorld;

public class TinkerWorldEvents {
    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase living = event.entityLiving;
        if (living.getClass() == EntitySpider.class && TConstruct.random.nextInt(100) == 0) {
            EntityCreeper creeper = new EntityCreeper(living.worldObj);
            TinkerWorldEvents.spawnEntityLiving(living.posX, living.posY + 1.0, living.posZ, (EntityLiving)creeper, living.worldObj);
            if (living.riddenByEntity != null) {
                creeper.mountEntity(living.riddenByEntity);
            } else {
                creeper.mountEntity((Entity)living);
            }
            EntityXPOrb orb = new EntityXPOrb(living.worldObj, living.posX, living.posY, living.posZ, TConstruct.random.nextInt(20) + 20);
            orb.mountEntity((Entity)creeper);
        }
    }

    public static void spawnEntityLiving(double x, double y, double z, EntityLiving entity, World world) {
        if (!world.isRemote) {
            entity.setPosition(x, y, z);
            entity.onSpawnWithEgg((IEntityLivingData)null);
            world.spawnEntityInWorld((Entity)entity);
        }
    }

    @SubscribeEvent
    public void bonemealEvent(BonemealEvent event) {
        if (!event.world.isRemote && event.block == TinkerWorld.slimeSapling && TinkerWorld.slimeSapling.boneFertilize(event.world, event.x, event.y, event.z, event.world.rand, event.entityPlayer)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        EntityLivingBase target;
        Entity attacker;
        EntityLivingBase reciever = event.entityLiving;
        if (reciever instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            ItemStack stack = player.getCurrentEquippedItem();
            if (stack != null && player.isUsingItem()) {
                Item item = stack.getItem();
                if (item == TinkerTools.cutlass) {
                    player.addPotionEffect(new PotionEffect(Potion.moveSpeed.id, 60, 1));
                } else if (item == TinkerTools.battlesign) {
                    event.ammount = (float)((double)event.ammount * 1.5);
                }
            }
        } else if (reciever instanceof EntityCreeper && (attacker = event.source.getEntity()) instanceof EntityLivingBase && (target = ((EntityCreeper)reciever).getAttackTarget()) != null) {
            float d1 = reciever.getDistanceToEntity((Entity)((EntityCreeper)reciever).getAttackTarget());
            float d2 = reciever.getDistanceToEntity(attacker);
            if (d2 < d1) {
                ((EntityCreeper)event.entityLiving).setAttackTarget((EntityLivingBase)event.source.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        if (event.entityLiving == null) {
            return;
        }
        if (event.entityLiving.getClass() == EntityGhast.class) {
            if (PHConstruct.uhcGhastDrops) {
                for (EntityItem o : event.drops) {
                    if (o.getEntityItem().getItem() != Items.ghast_tear) continue;
                    o.setEntityItemStack(new ItemStack(Items.gold_ingot, 1));
                }
            } else {
                ItemHelper.addDrops(event, new ItemStack(Items.ghast_tear, 1));
            }
        }
    }
}

