/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mantle.blocks.MantleBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.world.model.SlimeChannelRender;

public class ConveyorBase
extends MantleBlock {
    String texturename;
    public IIcon[] icons;

    public ConveyorBase(Material material, String name) {
        super(material);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        this.texturename = name;
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (!world.isBlockIndirectlyGettingPowered(x, y, z)) {
            double moveX = 0.0;
            double moveZ = 0.0;
            double speed = 0.01;
            int meta = world.getBlockMetadata(x, y, z);
            switch (meta % 8) {
                case 6: {
                    moveX += speed;
                    break;
                }
                case 7: {
                    moveX += speed;
                    moveZ += speed;
                    break;
                }
                case 0: {
                    moveZ += speed;
                    break;
                }
                case 1: {
                    moveZ += speed;
                    moveX -= speed;
                    break;
                }
                case 2: {
                    moveX -= speed;
                    break;
                }
                case 3: {
                    moveX -= speed;
                    moveZ -= speed;
                    break;
                }
                case 4: {
                    moveZ -= speed;
                    break;
                }
                case 5: {
                    moveZ -= speed;
                    moveX += speed;
                }
            }
            entity.addVelocity(moveX, 0.0, moveZ);
        }
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).age = 0;
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int face = MathHelper.floor_double((double)((double)(entity.rotationYaw * 8.0f / 360.0f) + 0.5)) + (entity.isSneaking() ? 4 : 0) & 7;
        int meta = world.getBlockMetadata(x, y, z) & 8;
        world.setBlockMetadataWithNotify(x, y, z, face | meta, 2);
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 1) {
            return false;
        }
        return super.shouldSideBeRendered(world, x, y, z, side);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public int getRenderType() {
        return SlimeChannelRender.model;
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        String[] textureNames = new String[]{this.texturename, this.texturename + "_flow"};
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("tinker:" + textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta >= 8) {
            return this.icons[0];
        }
        return side == 1 ? this.icons[1] : this.icons[0];
    }
}

