/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.world.TinkerWorld;
import tconstruct.world.model.OreberryRender;

public class OreberryBush
extends BlockLeavesBase
implements IPlantable {
    Random random;
    public IIcon[] fastIcons;
    public IIcon[] fancyIcons;
    public String[] textureNames;
    public String[] oreTypes;
    public int itemMeat;
    private int subitems;

    public OreberryBush(String[] textureNames, int meta, int sub, String[] oreTypes) {
        super(Material.leaves, false);
        this.textureNames = textureNames;
        this.itemMeat = meta;
        this.subitems = sub;
        this.oreTypes = oreTypes;
        this.setTickRandomly(true);
        this.random = new Random();
        this.setHardness(0.3f);
        this.setStepSound(Block.soundTypeMetal);
        this.setCreativeTab(TConstructRegistry.blockTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.fastIcons = new IIcon[this.textureNames.length];
        this.fancyIcons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.fastIcons.length; ++i) {
            if (this.textureNames[i] == "") continue;
            this.fastIcons[i] = iconRegister.registerIcon("tinker:crops/" + this.textureNames[i] + "_fast");
            this.fancyIcons[i] = iconRegister.registerIcon("tinker:crops/" + this.textureNames[i] + "_fancy");
        }
    }

    public IIcon getIcon(int side, int metadata) {
        this.setGraphicsLevel(Minecraft.getMinecraft().gameSettings.fancyGraphics);
        if (this.field_150121_P) {
            if (metadata < 12) {
                return this.fancyIcons[metadata % 4];
            }
            return this.fancyIcons[metadata % 4 + 4];
        }
        if (metadata < 12) {
            return this.fastIcons[metadata % 4];
        }
        return this.fastIcons[metadata % 4 + 4];
    }

    public int damageDropped(int metadata) {
        return metadata % 4;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (l < 4) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
        }
        if (l < 8) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 0.75), (double)((double)z + 0.875));
        }
        return AxisAlignedBB.getBoundingBox((double)((double)x + 0.0625), (double)y, (double)((double)z + 0.0625), (double)((double)x + 0.9375), (double)((double)y + 0.9375), (double)((double)z + 0.9375));
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (l < 4) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
        }
        if (l < 8) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 0.75), (double)((double)z + 0.875));
        }
        return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int x, int y, int z) {
        float maxY;
        float maxX;
        float maxZ;
        float minX;
        float minZ;
        int md = iblockaccess.getBlockMetadata(x, y, z);
        float minY = 0.0f;
        if (md < 4) {
            minZ = 0.25f;
            minX = 0.25f;
            maxZ = 0.75f;
            maxX = 0.75f;
            maxY = 0.5f;
        } else if (md < 8) {
            minZ = 0.125f;
            minX = 0.125f;
            maxZ = 0.875f;
            maxX = 0.875f;
            maxY = 0.75f;
        } else {
            minZ = 0.0f;
            minX = 0.0f;
            maxZ = 1.0f;
            maxX = 1.0f;
            maxY = 1.0f;
        }
        this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.harvest(world, x, y, z, player);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        return this.harvest(world, x, y, z, player);
    }

    public boolean harvest(World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta >= 12) {
            if (world.isRemote) {
                return true;
            }
            world.setBlock(x, y, z, (Block)this, meta - 4, 3);
            AbilityHelper.spawnItemAtPlayer(player, new ItemStack(TinkerWorld.oreBerries, this.random.nextInt(3) + 1, meta % 4 + this.itemMeat));
        }
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public void setGraphicsLevel(boolean flag) {
        this.field_150121_P = flag;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return OreberryRender.model;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int x, int y, int z, int meta) {
        if (meta > 7 || this.field_150121_P) {
            return super.shouldSideBeRendered(iblockaccess, x, y, z, meta);
        }
        return true;
    }

    public void updateTick(World world, int x, int y, int z, Random random1) {
        int meta;
        if (world.isRemote) {
            return;
        }
        if (random1.nextInt(20) == 0 && world.getFullBlockLightValue(x, y, z) < 10 && (meta = world.getBlockMetadata(x, y, z)) < 12) {
            world.setBlock(x, y, z, (Block)this, meta + 4, 3);
        }
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        if (plant instanceof OreberryBush) {
            return world.getBlockMetadata(x, y, z) > 7;
        }
        return super.canSustainPlant((IBlockAccess)world, x, y, z, direction, plant);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (world.getFullBlockLightValue(x, y, z) < 13) {
            return super.canPlaceBlockAt(world, x, y, z);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 8; var4 < 8 + this.subitems; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) - 4;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (!(entity instanceof EntityItem)) {
            entity.attackEntityFrom(DamageSource.cactus, 1.0f);
        }
    }
}

