/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class OreberryBushGen
extends WorldGenerator {
    private Block blockB;
    private int metadata;
    int chance;
    private Block[] replaceBlocks;

    public OreberryBushGen(Block block, int meta, int chance) {
        this(block, meta, chance, new Block[]{Blocks.stone, Blocks.grass, Blocks.dirt, Blocks.water, Blocks.sand, Blocks.gravel, Blocks.snow});
        this.blockB = block;
    }

    public OreberryBushGen(Block block, int meta, int chance, Block ... target) {
        this.blockB = block;
        this.metadata = meta;
        this.chance = chance;
        this.replaceBlocks = target;
    }

    public boolean generate(World world, Random random, int x, int y, int z) {
        int type = random.nextInt(this.chance);
        if (type == 11) {
            this.generateMediumNode(world, random, x, y, z);
        } else if (type >= 5) {
            this.generateSmallNode(world, random, x, y, z);
        } else {
            this.generateTinyNode(world, random, x, y, z);
        }
        return true;
    }

    public void generateMediumNode(World world, Random random, int x, int y, int z) {
        for (int xPos = -1; xPos <= 1; ++xPos) {
            for (int yPos = -1; yPos <= 1; ++yPos) {
                for (int zPos = -1; zPos <= 1; ++zPos) {
                    if (random.nextInt(4) != 0) continue;
                    this.generateBerryBlock(world, x + xPos, y + yPos, z + zPos, random);
                }
            }
        }
        this.generateSmallNode(world, random, x, y, z);
    }

    public void generateSmallNode(World world, Random random, int x, int y, int z) {
        this.generateBerryBlock(world, x, y, z, random);
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x + 1, y, z, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x - 1, y, z, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x, y, z + 1, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x, y, z - 1, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x, y + 1, z, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, x, y + 1, z, random);
        }
    }

    public void generateTinyNode(World world, Random random, int x, int y, int z) {
        this.generateBerryBlock(world, x, y, z, random);
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x + 1, y, z, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x - 1, y, z, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x, y, z + 1, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x, y, z - 1, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x, y + 1, z, random);
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, x, y + 1, z, random);
        }
    }

    void generateBerryBlock(World world, int x, int y, int z, Random random) {
        Block block = world.getBlock(x, y, z);
        if (block == null || block != Blocks.end_portal_frame && !world.getBlock(x, y, z).func_149730_j()) {
            world.setBlock(x, y, z, this.blockB, this.metadata, 2);
        } else {
            for (int iter = 0; iter < this.replaceBlocks.length; ++iter) {
                if (!world.getBlock(x, y, z).isReplaceableOreGen(world, x, y, z, this.replaceBlocks[iter])) continue;
                world.setBlock(x, y, z, this.blockB, this.metadata, 2);
                break;
            }
        }
    }
}

