/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import tconstruct.world.entity.KingBlueSlime;
import tconstruct.world.entity.SlimeBase;

@SideOnly(value=Side.CLIENT)
public class SlimeRender
extends RenderLiving {
    static final ResourceLocation texture = new ResourceLocation("tinker", "textures/mob/slimeedible.png");
    private ModelBase scaleAmount;

    public SlimeRender(ModelBase par1ModelBase, ModelBase par2ModelBase, float par3) {
        super(par1ModelBase, par3);
        this.scaleAmount = par2ModelBase;
    }

    public void doRender(EntityLiving par1EntityLiving, double par2, double par4, double par6, float par8, float par9) {
        super.doRender(par1EntityLiving, par2, par4, par6, par8, par9);
        if (par1EntityLiving instanceof KingBlueSlime) {
            BossStatus.setBossStatus((IBossDisplayData)((KingBlueSlime)par1EntityLiving), (boolean)true);
        }
    }

    protected int shouldSlimeRenderPass(SlimeBase slime, int par2, float par3) {
        if (slime.isInvisible()) {
            return 0;
        }
        if (par2 == 0) {
            this.setRenderPassModel(this.scaleAmount);
            GL11.glEnable((int)2977);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            return 1;
        }
        if (par2 == 1) {
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return -1;
    }

    protected void scaleSlime(SlimeBase par1EdibleSlime, float par2) {
        float f1 = par1EdibleSlime.getSlimeSize();
        float f2 = (par1EdibleSlime.sizeHeight + (par1EdibleSlime.sizeFactor - par1EdibleSlime.sizeHeight) * par2) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        GL11.glScalef((float)(f3 * f1), (float)(1.0f / f3 * f1), (float)(f3 * f1));
    }

    protected void preRenderCallback(EntityLivingBase par1EntityLiving, float par2) {
        this.scaleSlime((SlimeBase)par1EntityLiving, par2);
    }

    protected int shouldRenderPass(EntityLivingBase par1EntityLiving, int par2, float par3) {
        return this.shouldSlimeRenderPass((SlimeBase)par1EntityLiving, par2, par3);
    }

    protected ResourceLocation getEntityTexture(Entity par1Entity) {
        return texture;
    }
}

