/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.crafting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;

public class InfusionEnchantmentRecipe {
    public AspectList aspects;
    public String research;
    public ItemStack[] components;
    public Enchantment enchantment;
    public int recipeXP;
    public int instability;

    public InfusionEnchantmentRecipe(String research, Enchantment input, int inst, AspectList aspects2, ItemStack[] recipe) {
        this.research = research;
        this.enchantment = input;
        this.aspects = aspects2;
        this.components = recipe;
        this.instability = inst;
        this.recipeXP = Math.max(1, input.getMinEnchantability(1) / 3);
    }

    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (this.research.length() > 0 && !ThaumcraftApiHelper.isResearchComplete(player.getCommandSenderName(), this.research)) {
            return false;
        }
        if (!this.enchantment.canApply(central) || !central.getItem().isItemTool(central)) {
            return false;
        }
        Map map1 = EnchantmentHelper.getEnchantments((ItemStack)central);
        Iterator iterator = map1.keySet().iterator();
        while (iterator.hasNext()) {
            int j1 = (Integer)iterator.next();
            Enchantment ench = Enchantment.enchantmentsList[j1];
            if (j1 == this.enchantment.effectId && EnchantmentHelper.getEnchantmentLevel((int)j1, (ItemStack)central) >= ench.getMaxLevel()) {
                return false;
            }
            if (this.enchantment.effectId == ench.effectId || this.enchantment.canApplyTogether(ench) && ench.canApplyTogether(this.enchantment)) continue;
            return false;
        }
        ItemStack i2 = null;
        ArrayList<ItemStack> ii = new ArrayList<ItemStack>();
        for (ItemStack is : input) {
            ii.add(is.copy());
        }
        for (ItemStack comp : this.components) {
            boolean b = false;
            for (int a = 0; a < ii.size(); ++a) {
                i2 = ((ItemStack)ii.get(a)).copy();
                if (comp.getItemDamage() == Short.MAX_VALUE) {
                    i2.setItemDamage(Short.MAX_VALUE);
                }
                if (!this.areItemStacksEqual(i2, comp, true)) continue;
                ii.remove(a);
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return ii.size() == 0;
    }

    protected boolean areItemStacksEqual(ItemStack stack0, ItemStack stack1, boolean fuzzy) {
        ItemStack[] ores;
        Integer od;
        if (stack0 == null && stack1 != null) {
            return false;
        }
        if (stack0 != null && stack1 == null) {
            return false;
        }
        if (stack0 == null && stack1 == null) {
            return true;
        }
        boolean t1 = ThaumcraftApiHelper.areItemStackTagsEqualForCrafting(stack0, stack1);
        if (!t1) {
            return false;
        }
        if (fuzzy && (od = Integer.valueOf(OreDictionary.getOreID((ItemStack)stack0))) != -1 && ThaumcraftApiHelper.containsMatch(false, new ItemStack[]{stack1}, ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0]))) {
            return true;
        }
        return stack0.getItem() != stack1.getItem() ? false : (stack0.getItemDamage() != stack1.getItemDamage() ? false : stack0.stackSize <= stack0.getMaxStackSize());
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public AspectList getAspects() {
        return this.aspects;
    }

    public String getResearch() {
        return this.research;
    }

    public int calcInstability(ItemStack recipeInput) {
        int i = 0;
        Map map1 = EnchantmentHelper.getEnchantments((ItemStack)recipeInput);
        Iterator iterator = map1.keySet().iterator();
        while (iterator.hasNext()) {
            int j1 = (Integer)iterator.next();
            i += EnchantmentHelper.getEnchantmentLevel((int)j1, (ItemStack)recipeInput);
        }
        return i / 2 + this.instability;
    }

    public int calcXP(ItemStack recipeInput) {
        return this.recipeXP * (1 + EnchantmentHelper.getEnchantmentLevel((int)this.enchantment.effectId, (ItemStack)recipeInput));
    }

    public float getEssentiaMod(ItemStack recipeInput) {
        float mod = EnchantmentHelper.getEnchantmentLevel((int)this.enchantment.effectId, (ItemStack)recipeInput);
        Map map1 = EnchantmentHelper.getEnchantments((ItemStack)recipeInput);
        Iterator iterator = map1.keySet().iterator();
        while (iterator.hasNext()) {
            int j1 = (Integer)iterator.next();
            if (j1 == this.enchantment.effectId) continue;
            mod += (float)EnchantmentHelper.getEnchantmentLevel((int)j1, (ItemStack)recipeInput) * 0.1f;
        }
        return mod;
    }
}

