/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.wands;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;

public class ItemFocusBasic
extends Item {
    public IIcon icon;

    public ItemFocusBasic() {
        this.maxStackSize = 1;
        this.canRepair = false;
        this.setMaxDamage(0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public boolean isDamageable() {
        return false;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        AspectList al = this.getVisCost(stack);
        if (al != null && al.size() > 0) {
            list.add(StatCollector.translateToLocal((String)(this.isVisCostPerTick(stack) ? "item.Focus.cost2" : "item.Focus.cost1")));
            for (Aspect aspect : al.getAspectsSorted()) {
                DecimalFormat myFormatter = new DecimalFormat("#####.##");
                String amount = myFormatter.format((float)al.getAmount(aspect) / 100.0f);
                list.add(" \u00a7" + aspect.getChatcolor() + aspect.getName() + "\u00a7r x " + amount);
            }
        }
        this.addFocusInformation(stack, player, list, par4);
    }

    public void addFocusInformation(ItemStack focusstack, EntityPlayer player, List list, boolean par4) {
        LinkedHashMap<Short, Integer> map = new LinkedHashMap<Short, Integer>();
        for (short id : this.getAppliedUpgrades(focusstack)) {
            if (id < 0) continue;
            int amt = 1;
            if (map.containsKey(id)) {
                amt = (Integer)map.get(id) + 1;
            }
            map.put(id, amt);
        }
        for (Short id : map.keySet()) {
            list.add(EnumChatFormatting.DARK_PURPLE + FocusUpgradeType.types[id].getLocalizedName() + ((Integer)map.get(id) > 1 ? " " + StatCollector.translateToLocal((String)("enchantment.level." + map.get(id))) : ""));
        }
    }

    public boolean isVisCostPerTick(ItemStack focusstack) {
        return false;
    }

    public EnumRarity getRarity(ItemStack focusstack) {
        return EnumRarity.rare;
    }

    public int getFocusColor(ItemStack focusstack) {
        return 0;
    }

    public IIcon getOrnament(ItemStack focusstack) {
        return null;
    }

    public IIcon getFocusDepthLayerIcon(ItemStack focusstack) {
        return null;
    }

    public WandFocusAnimation getAnimation(ItemStack focusstack) {
        return WandFocusAnimation.WAVE;
    }

    public String getSortingHelper(ItemStack focusstack) {
        String out = "";
        for (short id : this.getAppliedUpgrades(focusstack)) {
            out = out + id;
        }
        return out;
    }

    public AspectList getVisCost(ItemStack focusstack) {
        return null;
    }

    public int getActivationCooldown(ItemStack focusstack) {
        return 0;
    }

    public int getMaxAreaSize(ItemStack focusstack) {
        return 1;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        return null;
    }

    public short[] getAppliedUpgrades(ItemStack focusstack) {
        short[] l = new short[]{-1, -1, -1, -1, -1};
        NBTTagList nbttaglist = this.getFocusUpgradeTagList(focusstack);
        if (nbttaglist == null) {
            return l;
        }
        for (int j = 0; j < nbttaglist.tagCount() && j < 5; ++j) {
            l[j] = nbttaglist.getCompoundTagAt(j).getShort("id");
        }
        return l;
    }

    public boolean applyUpgrade(ItemStack focusstack, FocusUpgradeType type, int rank) {
        short[] upgrades = this.getAppliedUpgrades(focusstack);
        if (upgrades[rank - 1] != -1 || rank < 1 || rank > 5) {
            return false;
        }
        upgrades[rank - 1] = type.id;
        this.setFocusUpgradeTagList(focusstack, upgrades);
        return true;
    }

    public boolean canApplyUpgrade(ItemStack focusstack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return true;
    }

    public boolean isUpgradedWith(ItemStack focusstack, FocusUpgradeType focusUpgradetype) {
        return this.getUpgradeLevel(focusstack, focusUpgradetype) > 0;
    }

    public int getUpgradeLevel(ItemStack focusstack, FocusUpgradeType focusUpgradetype) {
        short[] list = this.getAppliedUpgrades(focusstack);
        int level = 0;
        for (short id : list) {
            if (id != focusUpgradetype.id) continue;
            ++level;
        }
        return level;
    }

    public ItemStack onFocusRightClick(ItemStack wandstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        return null;
    }

    public void onUsingFocusTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onPlayerStoppedUsingFocus(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    public boolean onFocusBlockStartBreak(ItemStack wandstack, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    private NBTTagList getFocusUpgradeTagList(ItemStack focusstack) {
        return focusstack.stackTagCompound == null ? null : focusstack.stackTagCompound.getTagList("upgrade", 10);
    }

    private void setFocusUpgradeTagList(ItemStack focusstack, short[] upgrades) {
        if (!focusstack.hasTagCompound()) {
            focusstack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbttagcompound = focusstack.getTagCompound();
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.setTag("upgrade", (NBTBase)tlist);
        for (short id : upgrades) {
            NBTTagCompound f = new NBTTagCompound();
            f.setShort("id", id);
            tlist.appendTag((NBTBase)f);
        }
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (stack.stackTagCompound != null && stack.stackTagCompound.hasKey("ench")) {
            stack.stackTagCompound.removeTag("ench");
        }
        super.onUpdate(stack, world, entity, p_77663_4_, p_77663_5_);
    }

    public static enum WandFocusAnimation {
        WAVE,
        CHARGE;

    }
}

