/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.other;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;

public class FXSonic
extends EntityFX {
    Entity target = null;
    float yaw = 0.0f;
    float pitch = 0.0f;
    private IModelCustom model;
    private static final ResourceLocation MODEL = new ResourceLocation("thaumcraft", "textures/models/hemis.obj");

    public FXSonic(World world, double d, double d1, double d2, Entity target, int age) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.particleGravity = 0.0f;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.particleMaxAge = age + this.rand.nextInt(age / 2);
        this.noClip = false;
        this.setSize(0.01f, 0.01f);
        this.noClip = true;
        this.particleScale = 1.0f;
        this.target = target;
        this.yaw = target.getRotationYawHead();
        this.pitch = target.rotationPitch;
        this.prevPosX = this.posX = target.posX;
        this.prevPosY = this.posY = target.posY + (double)target.getEyeHeight();
        this.prevPosZ = this.posZ = target.posZ;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        tessellator.draw();
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (this.model == null) {
            this.model = AdvancedModelLoader.loadModel((ResourceLocation)MODEL);
        }
        float fade = ((float)this.particleAge + f) / (float)this.particleMaxAge;
        float xx = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float yy = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float zz = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float b = 1.0f;
        int frame = Math.min(15, (int)(14.0f * fade) + 1);
        UtilsFX.bindTexture("textures/models/ripple" + frame + ".png");
        b = 0.5f;
        int i = 220;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        GL11.glRotatef((float)(-this.yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(2.0f * this.target.height + this.target.width / 2.0f));
        GL11.glScaled((double)(0.25 * (double)this.target.height), (double)(0.25 * (double)this.target.height), (double)(-1.0f * this.target.height));
        GL11.glColor4f((float)b, (float)b, (float)b, (float)1.0f);
        this.model.renderAll();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        Minecraft.getMinecraft().renderEngine.bindTexture(UtilsFX.getParticleTexture());
        tessellator.startDrawingQuads();
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
        this.posX = this.target.posX;
        this.posY = this.target.posY + (double)this.target.getEyeHeight();
        this.posZ = this.target.posZ;
    }
}

