/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.particles;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class FXBoreParticles
extends EntityFX {
    private Block blockInstance;
    private Item itemInstance;
    private int metadata;
    private int side;
    private double targetX;
    private double targetY;
    private double targetZ;

    public FXBoreParticles(World par1World, double par2, double par4, double par6, double tx, double ty, double tz, Block par14Block, int par15, int par16) {
        super(par1World, par2, par4, par6, 0.0, 0.0, 0.0);
        this.blockInstance = par14Block;
        this.setParticleIcon(par14Block.getIcon(par15, par16));
        this.particleGravity = par14Block.blockParticleGravity;
        this.particleBlue = 0.6f;
        this.particleGreen = 0.6f;
        this.particleRed = 0.6f;
        this.particleScale = this.rand.nextFloat() * 0.3f + 0.4f;
        this.side = par15;
        this.targetX = tx;
        this.targetY = ty;
        this.targetZ = tz;
        double dx = tx - this.posX;
        double dy = ty - this.posY;
        double dz = tz - this.posZ;
        int base = (int)(MathHelper.sqrt_double((double)(dx * dx + dy * dy + dz * dz)) * 3.0f);
        if (base < 1) {
            base = 1;
        }
        this.particleMaxAge = base / 2 + this.rand.nextInt(base);
        float f3 = 0.01f;
        this.motionX = (float)this.worldObj.rand.nextGaussian() * f3;
        this.motionY = (float)this.worldObj.rand.nextGaussian() * f3;
        this.motionZ = (float)this.worldObj.rand.nextGaussian() * f3;
        this.particleGravity = 0.2f;
        this.noClip = false;
        EntityLivingBase renderentity = FMLClientHandler.instance().getClient().renderViewEntity;
        int visibleDistance = 64;
        if (!FMLClientHandler.instance().getClient().gameSettings.fancyGraphics) {
            visibleDistance = 32;
        }
        if (renderentity.getDistance(this.posX, this.posY, this.posZ) > (double)visibleDistance) {
            this.particleMaxAge = 0;
        }
    }

    public FXBoreParticles(World par1World, double par2, double par4, double par6, double tx, double ty, double tz, Item item, int par15, int par16) {
        super(par1World, par2, par4, par6, 0.0, 0.0, 0.0);
        this.itemInstance = item;
        this.setParticleIcon(item.getIconFromDamage(par16));
        this.metadata = par16;
        this.particleGravity = Blocks.snow_layer.blockParticleGravity;
        this.particleBlue = 0.6f;
        this.particleGreen = 0.6f;
        this.particleRed = 0.6f;
        this.particleScale = this.rand.nextFloat() * 0.3f + 0.4f;
        this.side = par15;
        this.targetX = tx;
        this.targetY = ty;
        this.targetZ = tz;
        double dx = tx - this.posX;
        double dy = ty - this.posY;
        double dz = tz - this.posZ;
        int base = (int)(MathHelper.sqrt_double((double)(dx * dx + dy * dy + dz * dz)) * 3.0f);
        if (base < 1) {
            base = 1;
        }
        this.particleMaxAge = base / 2 + this.rand.nextInt(base);
        float f3 = 0.01f;
        this.motionX = (float)this.worldObj.rand.nextGaussian() * f3;
        this.motionY = (float)this.worldObj.rand.nextGaussian() * f3;
        this.motionZ = (float)this.worldObj.rand.nextGaussian() * f3;
        this.particleGravity = 0.2f;
        this.noClip = false;
        EntityLivingBase renderentity = FMLClientHandler.instance().getClient().renderViewEntity;
        int visibleDistance = 64;
        if (!FMLClientHandler.instance().getClient().gameSettings.fancyGraphics) {
            visibleDistance = 32;
        }
        if (renderentity.getDistance(this.posX, this.posY, this.posZ) > (double)visibleDistance) {
            this.particleMaxAge = 0;
        }
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge || MathHelper.floor_double((double)this.posX) == MathHelper.floor_double((double)this.targetX) && MathHelper.floor_double((double)this.posY) == MathHelper.floor_double((double)this.targetY) && MathHelper.floor_double((double)this.posZ) == MathHelper.floor_double((double)this.targetZ)) {
            this.setDead();
            return;
        }
        if (!this.noClip) {
            this.pushOutOfBlocks(this.posX, this.posY, this.posZ);
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= 0.985;
        this.motionY *= 0.985;
        this.motionZ *= 0.985;
        double dx = this.targetX - this.posX;
        double dy = this.targetY - this.posY;
        double dz = this.targetZ - this.posZ;
        double d13 = 0.3;
        double d11 = MathHelper.sqrt_double((double)(dx * dx + dy * dy + dz * dz));
        if (d11 < 4.0) {
            this.particleScale *= 0.9f;
            d13 = 0.6;
        }
        this.motionX += (dx /= d11) * d13;
        this.motionY += (dy /= d11) * d13;
        this.motionZ += (dz /= d11) * d13;
        this.motionX = MathHelper.clamp_float((float)((float)this.motionX), (float)-0.35f, (float)0.35f);
        this.motionY = MathHelper.clamp_float((float)((float)this.motionY), (float)-0.35f, (float)0.35f);
        this.motionZ = MathHelper.clamp_float((float)((float)this.motionZ), (float)-0.35f, (float)0.35f);
    }

    public FXBoreParticles applyColourMultiplier(int par1, int par2, int par3) {
        if (this.blockInstance != null && this.worldObj.getBlock(par1, par2, par3) == this.blockInstance) {
            if (this.blockInstance == Blocks.grass && this.side != 1) {
                return this;
            }
            try {
                int var4 = this.blockInstance.colorMultiplier((IBlockAccess)this.worldObj, par1, par2, par3);
                this.particleRed *= (float)(var4 >> 16 & 0xFF) / 255.0f;
                this.particleGreen *= (float)(var4 >> 8 & 0xFF) / 255.0f;
                this.particleBlue *= (float)(var4 & 0xFF) / 255.0f;
            }
            catch (Exception e) {
                // empty catch block
            }
            return this;
        }
        try {
            int var4 = this.itemInstance.getColorFromItemStack(new ItemStack(this.itemInstance, 1, this.metadata), 0);
            this.particleRed *= (float)(var4 >> 16 & 0xFF) / 255.0f;
            this.particleGreen *= (float)(var4 >> 8 & 0xFF) / 255.0f;
            this.particleBlue *= (float)(var4 & 0xFF) / 255.0f;
        }
        catch (Exception e) {
            // empty catch block
        }
        return this;
    }

    public FXBoreParticles applyRenderColor(int par1) {
        if (this.blockInstance != null) {
            if (this.blockInstance == Blocks.grass) {
                return this;
            }
            int var2 = this.blockInstance.getRenderColor(par1);
            this.particleRed *= (float)(var2 >> 16 & 0xFF) / 255.0f;
            this.particleGreen *= (float)(var2 >> 8 & 0xFF) / 255.0f;
            this.particleBlue *= (float)(var2 & 0xFF) / 255.0f;
            return this;
        }
        int var4 = this.itemInstance.getColorFromItemStack(new ItemStack(this.itemInstance, 1, this.metadata), this.metadata);
        this.particleRed *= (float)(var4 >> 16 & 0xFF) / 255.0f;
        this.particleGreen *= (float)(var4 >> 8 & 0xFF) / 255.0f;
        this.particleBlue *= (float)(var4 & 0xFF) / 255.0f;
        return this;
    }

    public int getFXLayer() {
        return this.blockInstance != null ? 1 : 2;
    }

    public void renderParticle(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        float f6 = ((float)this.particleTextureIndexX + this.particleTextureJitterX / 4.0f) / 16.0f;
        float f7 = f6 + 0.015609375f;
        float f8 = ((float)this.particleTextureIndexY + this.particleTextureJitterY / 4.0f) / 16.0f;
        float f9 = f8 + 0.015609375f;
        float f10 = 0.1f * this.particleScale;
        if (this.particleIcon != null) {
            f6 = this.particleIcon.getInterpolatedU((double)(this.particleTextureJitterX / 4.0f * 16.0f));
            f7 = this.particleIcon.getInterpolatedU((double)((this.particleTextureJitterX + 1.0f) / 4.0f * 16.0f));
            f8 = this.particleIcon.getInterpolatedV((double)(this.particleTextureJitterY / 4.0f * 16.0f));
            f9 = this.particleIcon.getInterpolatedV((double)((this.particleTextureJitterY + 1.0f) / 4.0f * 16.0f));
        }
        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)par2 - interpPosX);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)par2 - interpPosY);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)par2 - interpPosZ);
        float f14 = 1.0f;
        par1Tessellator.setColorOpaque_F(f14 * this.particleRed, f14 * this.particleGreen, f14 * this.particleBlue);
        par1Tessellator.addVertexWithUV((double)(f11 - par3 * f10 - par6 * f10), (double)(f12 - par4 * f10), (double)(f13 - par5 * f10 - par7 * f10), (double)f6, (double)f9);
        par1Tessellator.addVertexWithUV((double)(f11 - par3 * f10 + par6 * f10), (double)(f12 + par4 * f10), (double)(f13 - par5 * f10 + par7 * f10), (double)f6, (double)f8);
        par1Tessellator.addVertexWithUV((double)(f11 + par3 * f10 + par6 * f10), (double)(f12 + par4 * f10), (double)(f13 + par5 * f10 + par7 * f10), (double)f7, (double)f8);
        par1Tessellator.addVertexWithUV((double)(f11 + par3 * f10 - par6 * f10), (double)(f12 - par4 * f10), (double)(f13 + par5 * f10 - par7 * f10), (double)f7, (double)f9);
    }

    protected boolean pushOutOfBlocks(double par1, double par3, double par5) {
        int var7 = MathHelper.floor_double((double)par1);
        int var8 = MathHelper.floor_double((double)par3);
        int var9 = MathHelper.floor_double((double)par5);
        double var10 = par1 - (double)var7;
        double var12 = par3 - (double)var8;
        double var14 = par5 - (double)var9;
        if (!this.worldObj.isAirBlock(var7, var8, var9) && !this.worldObj.isAnyLiquid(this.boundingBox)) {
            boolean var16 = !this.worldObj.isBlockNormalCubeDefault(var7 - 1, var8, var9, true);
            boolean var17 = !this.worldObj.isBlockNormalCubeDefault(var7 + 1, var8, var9, true);
            boolean var18 = !this.worldObj.isBlockNormalCubeDefault(var7, var8 - 1, var9, true);
            boolean var19 = !this.worldObj.isBlockNormalCubeDefault(var7, var8 + 1, var9, true);
            boolean var20 = !this.worldObj.isBlockNormalCubeDefault(var7, var8, var9 - 1, true);
            boolean var21 = !this.worldObj.isBlockNormalCubeDefault(var7, var8, var9 + 1, true);
            int var22 = -1;
            double var23 = 9999.0;
            if (var16 && var10 < var23) {
                var23 = var10;
                var22 = 0;
            }
            if (var17 && 1.0 - var10 < var23) {
                var23 = 1.0 - var10;
                var22 = 1;
            }
            if (var18 && var12 < var23) {
                var23 = var12;
                var22 = 2;
            }
            if (var19 && 1.0 - var12 < var23) {
                var23 = 1.0 - var12;
                var22 = 3;
            }
            if (var20 && var14 < var23) {
                var23 = var14;
                var22 = 4;
            }
            if (var21 && 1.0 - var14 < var23) {
                var23 = 1.0 - var14;
                var22 = 5;
            }
            float var25 = this.rand.nextFloat() * 0.05f + 0.025f;
            float var26 = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f;
            if (var22 == 0) {
                this.motionX = -var25;
                this.motionY = this.motionZ = (double)var26;
            }
            if (var22 == 1) {
                this.motionX = var25;
                this.motionY = this.motionZ = (double)var26;
            }
            if (var22 == 2) {
                this.motionY = -var25;
                this.motionX = this.motionZ = (double)var26;
            }
            if (var22 == 3) {
                this.motionY = var25;
                this.motionX = this.motionZ = (double)var26;
            }
            if (var22 == 4) {
                this.motionZ = -var25;
                this.motionY = this.motionX = (double)var26;
            }
            if (var22 == 5) {
                this.motionZ = var25;
                this.motionY = this.motionX = (double)var26;
            }
            return true;
        }
        return false;
    }
}

