/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.particles;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class FXVisSparkle
extends EntityFX {
    private double targetX;
    private double targetY;
    private double targetZ;
    float sizeMod = 0.0f;

    public FXVisSparkle(World par1World, double par2, double par4, double par6, double tx, double ty, double tz) {
        super(par1World, par2, par4, par6, 0.0, 0.0, 0.0);
        this.particleBlue = 0.6f;
        this.particleGreen = 0.6f;
        this.particleRed = 0.6f;
        this.particleScale = 0.0f;
        this.targetX = tx;
        this.targetY = ty;
        this.targetZ = tz;
        this.particleMaxAge = 1000;
        float f3 = 0.01f;
        this.motionX = (float)this.rand.nextGaussian() * f3;
        this.motionY = (float)this.rand.nextGaussian() * f3;
        this.motionZ = (float)this.rand.nextGaussian() * f3;
        this.sizeMod = 45 + this.rand.nextInt(15);
        this.particleRed = 0.2f;
        this.particleGreen = 0.6f + this.rand.nextFloat() * 0.3f;
        this.particleBlue = 0.2f;
        this.particleGravity = 0.2f;
        this.noClip = true;
        EntityLivingBase renderentity = FMLClientHandler.instance().getClient().renderViewEntity;
        int visibleDistance = 64;
        if (!FMLClientHandler.instance().getClient().gameSettings.fancyGraphics) {
            visibleDistance = 32;
        }
        if (renderentity.getDistance(this.posX, this.posY, this.posZ) > (double)visibleDistance) {
            this.particleMaxAge = 0;
        }
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float bob = MathHelper.sin((float)((float)this.particleAge / 3.0f)) * 0.3f + 6.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        int part = this.particleAge % 16;
        float var8 = (float)part / 16.0f;
        float var9 = var8 + 0.0624375f;
        float var10 = 0.5f;
        float var11 = var10 + 0.0624375f;
        float var12 = 0.1f * this.particleScale * bob;
        float var13 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float var14 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float var15 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        float var16 = 1.0f;
        tessellator.setBrightness(240);
        tessellator.setColorRGBA_F(this.particleRed * var16, this.particleGreen * var16, this.particleBlue * var16, 0.5f);
        tessellator.addVertexWithUV((double)(var13 - f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 - f3 * var12 - f5 * var12), (double)var9, (double)var11);
        tessellator.addVertexWithUV((double)(var13 - f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 - f3 * var12 + f5 * var12), (double)var9, (double)var10);
        tessellator.addVertexWithUV((double)(var13 + f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 + f3 * var12 + f5 * var12), (double)var8, (double)var10);
        tessellator.addVertexWithUV((double)(var13 + f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 + f3 * var12 - f5 * var12), (double)var8, (double)var11);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
            return;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= 0.985;
        this.motionY *= 0.985;
        this.motionZ *= 0.985;
        double dx = this.targetX - this.posX;
        double dy = this.targetY - this.posY;
        double dz = this.targetZ - this.posZ;
        double d13 = 0.1f;
        double d11 = MathHelper.sqrt_double((double)(dx * dx + dy * dy + dz * dz));
        if (d11 < 2.0) {
            this.particleScale *= 0.95f;
        }
        if (d11 < 0.2) {
            this.particleMaxAge = this.particleAge;
        }
        if (this.particleAge < 10) {
            this.particleScale = (float)this.particleAge / this.sizeMod;
        }
        this.motionX += (dx /= d11) * d13;
        this.motionY += (dy /= d11) * d13;
        this.motionZ += (dz /= d11) * d13;
        this.motionX = MathHelper.clamp_float((float)((float)this.motionX), (float)-0.1f, (float)0.1f);
        this.motionY = MathHelper.clamp_float((float)((float)this.motionY), (float)-0.1f, (float)0.1f);
        this.motionZ = MathHelper.clamp_float((float)((float)this.motionZ), (float)-0.1f, (float)0.1f);
    }

    public void setGravity(float value) {
        this.particleGravity = value;
    }
}

