/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.container.ContainerSpa;
import thaumcraft.common.tiles.TileSpa;

@SideOnly(value=Side.CLIENT)
public class GuiSpa
extends GuiContainer {
    private TileSpa spa;
    private float xSize_lo;
    private float ySize_lo;

    public GuiSpa(InventoryPlayer par1InventoryPlayer, TileSpa teSpa) {
        super((Container)new ContainerSpa(par1InventoryPlayer, teSpa));
        this.spa = teSpa;
    }

    public void drawScreen(int par1, int par2, float par3) {
        ArrayList<String> list;
        super.drawScreen(par1, par2, par3);
        this.xSize_lo = par1;
        this.ySize_lo = par2;
        int baseX = this.guiLeft;
        int baseY = this.guiTop;
        int mposx = par1 - (baseX + 104);
        int mposy = par2 - (baseY + 10);
        if (mposx >= 0 && mposy >= 0 && mposx < 10 && mposy < 55) {
            list = new ArrayList<String>();
            FluidStack fluid = this.spa.tank.getFluid();
            if (fluid != null) {
                list.add(fluid.getFluid().getLocalizedName(fluid));
                list.add(fluid.amount + " mb");
                this.drawHoveringText(list, par1, par2, this.fontRendererObj);
            }
        }
        mposx = par1 - (baseX + 88);
        mposy = par2 - (baseY + 34);
        if (mposx >= 0 && mposy >= 0 && mposx < 10 && mposy < 10) {
            list = new ArrayList();
            if (this.spa.getMix()) {
                list.add(StatCollector.translateToLocal((String)"text.spa.mix.true"));
            } else {
                list.add(StatCollector.translateToLocal((String)"text.spa.mix.false"));
            }
            this.drawHoveringText(list, par1, par2, this.fontRendererObj);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        IIcon icon;
        FluidStack fluid;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.bindTexture("textures/gui/gui_spa.png");
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        if (this.spa.getMix()) {
            this.drawTexturedModalRect(k + 89, l + 35, 208, 16, 8, 8);
        } else {
            this.drawTexturedModalRect(k + 89, l + 35, 208, 32, 8, 8);
        }
        if (this.spa.tank.getFluidAmount() > 0 && (fluid = this.spa.tank.getFluid()) != null && (icon = fluid.getFluid().getIcon()) != null) {
            float bar = (float)this.spa.tank.getFluidAmount() / (float)this.spa.tank.getCapacity();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.guiLeft + 107), (float)(this.guiTop + 15), (float)0.0f);
            GuiSpa.renderFluid(icon);
            GL11.glPopMatrix();
            UtilsFX.bindTexture("textures/gui/gui_spa.png");
            this.drawTexturedModalRect(k + 107, l + 15, 107, 15, 10, (int)(48.0f - 48.0f * bar));
        }
        this.drawTexturedModalRect(k + 106, l + 11, 232, 0, 10, 55);
        GL11.glDisable((int)3042);
    }

    public static void renderFluid(IIcon icon) {
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationBlocksTexture);
        Tessellator tessellator = Tessellator.instance;
        float f1 = icon.getMaxU();
        float f2 = icon.getMinV();
        float f3 = icon.getMinU();
        float f4 = icon.getMaxV();
        GL11.glScalef((float)8.0f, (float)8.0f, (float)8.0f);
        for (int a = 0; a < 6; ++a) {
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            tessellator.addVertexWithUV(0.0, (double)(1 + a), 0.0, (double)f1, (double)f4);
            tessellator.addVertexWithUV(1.0, (double)(1 + a), 0.0, (double)f3, (double)f4);
            tessellator.addVertexWithUV(1.0, (double)(0 + a), 0.0, (double)f3, (double)f2);
            tessellator.addVertexWithUV(0.0, (double)(0 + a), 0.0, (double)f1, (double)f2);
            tessellator.draw();
        }
    }

    protected void mouseClicked(int mx, int my, int par3) {
        super.mouseClicked(mx, my, par3);
        int gx = (this.width - this.xSize) / 2;
        int gy = (this.height - this.ySize) / 2;
        int var7 = mx - (gx + 89);
        int var8 = my - (gy + 35);
        if (var7 >= 0 && var8 >= 0 && var7 < 8 && var8 < 8) {
            this.mc.playerController.sendEnchantPacket(this.inventorySlots.windowId, 1);
            this.playButtonClick();
            return;
        }
    }

    private void playButtonClick() {
        this.mc.renderViewEntity.worldObj.playSound(this.mc.renderViewEntity.posX, this.mc.renderViewEntity.posY, this.mc.renderViewEntity.posZ, "thaumcraft:cameraclack", 0.4f, 1.0f, false);
    }
}

