/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.util.JsonException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.gui.GuiResearchPopup;
import thaumcraft.client.gui.GuiResearchRecipe;
import thaumcraft.client.gui.MappingThread;
import thaumcraft.client.lib.RenderEventHandler;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.relics.ItemSanityChecker;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.items.wands.foci.ItemFocusTrade;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.tiles.TileInfusionMatrix;

public class ClientTickEventsFML {
    public static GuiResearchPopup researchPopup = null;
    public int tickCount = 0;
    int prevWorld;
    boolean checkedDate = false;
    final ResourceLocation HUD = new ResourceLocation("thaumcraft", "textures/gui/hud.png");
    RenderItem ri = new RenderItem();
    DecimalFormat myFormatter = new DecimalFormat("#######.##");
    DecimalFormat myFormatter2 = new DecimalFormat("#######.#");
    HashMap<Integer, AspectList> oldvals = new HashMap();
    long nextsync = 0L;
    boolean startThread = false;
    public static int warpVignette = 0;
    private static final int SHADER_DESAT = 0;
    private static final int SHADER_BLUR = 1;
    private static final int SHADER_HUNGER = 2;
    private static final int SHADER_SUNSCORNED = 3;
    ResourceLocation[] shader_resources = new ResourceLocation[]{new ResourceLocation("shaders/post/desaturatetc.json"), new ResourceLocation("shaders/post/blurtc.json"), new ResourceLocation("shaders/post/hunger.json"), new ResourceLocation("shaders/post/sunscorned.json")};
    ItemStack lastItem = null;
    int lastCount = 0;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            if (!this.startThread && GuiResearchRecipe.cache.size() <= 0) {
                HashMap idMappings = Maps.newHashMap();
                GameData.getBlockRegistry().serializeInto((Map)idMappings);
                GameData.getItemRegistry().serializeInto((Map)idMappings);
                Thread t = new Thread(new MappingThread(idMappings));
                t.start();
                this.startThread = true;
            }
            Minecraft mc = Minecraft.getMinecraft();
            if (event.player.getItemInUse() != null && event.player.getItemInUse().getItem() instanceof ItemWandCasting) {
                event.player.setItemInUse(event.player.inventory.getCurrentItem(), event.player.getItemInUseCount());
            }
            try {
                if (event.player.getEntityId() == mc.thePlayer.getEntityId()) {
                    this.checkShaders(event, mc);
                    if (warpVignette > 0) {
                        --warpVignette;
                        RenderEventHandler.targetBrightness = 0.0f;
                    } else {
                        RenderEventHandler.targetBrightness = 1.0f;
                    }
                    if (RenderEventHandler.fogFiddled) {
                        if (RenderEventHandler.fogDuration < 100) {
                            RenderEventHandler.fogTarget = 0.1f * ((float)RenderEventHandler.fogDuration / 100.0f);
                        } else if (RenderEventHandler.fogTarget < 0.1f) {
                            RenderEventHandler.fogTarget += 0.001f;
                        }
                        if (--RenderEventHandler.fogDuration < 0) {
                            RenderEventHandler.fogFiddled = false;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkShaders(TickEvent.PlayerTickEvent event, Minecraft mc) {
        if (event.player.isPotionActive(Config.potionDeathGazeID)) {
            warpVignette = 10;
            if (!RenderEventHandler.shaderGroups.containsKey(0)) {
                try {
                    this.setShader(new ShaderGroup(mc.getTextureManager(), mc.getResourceManager(), mc.getFramebuffer(), this.shader_resources[0]), 0);
                }
                catch (JsonException e) {}
            }
        } else if (RenderEventHandler.shaderGroups.containsKey(0)) {
            this.deactivateShader(0);
        }
        if (event.player.isPotionActive(Config.potionBlurredID)) {
            if (!RenderEventHandler.shaderGroups.containsKey(1)) {
                try {
                    this.setShader(new ShaderGroup(mc.getTextureManager(), mc.getResourceManager(), mc.getFramebuffer(), this.shader_resources[1]), 1);
                }
                catch (JsonException e) {}
            }
        } else if (RenderEventHandler.shaderGroups.containsKey(1)) {
            this.deactivateShader(1);
        }
        if (event.player.isPotionActive(Config.potionUnHungerID)) {
            if (!RenderEventHandler.shaderGroups.containsKey(2)) {
                try {
                    this.setShader(new ShaderGroup(mc.getTextureManager(), mc.getResourceManager(), mc.getFramebuffer(), this.shader_resources[2]), 2);
                }
                catch (JsonException e) {}
            }
        } else if (RenderEventHandler.shaderGroups.containsKey(2)) {
            this.deactivateShader(2);
        }
        if (event.player.isPotionActive(Config.potionSunScornedID)) {
            if (!RenderEventHandler.shaderGroups.containsKey(3)) {
                try {
                    this.setShader(new ShaderGroup(mc.getTextureManager(), mc.getResourceManager(), mc.getFramebuffer(), this.shader_resources[3]), 3);
                }
                catch (JsonException jsonException) {}
            }
        } else if (RenderEventHandler.shaderGroups.containsKey(3)) {
            this.deactivateShader(3);
        }
    }

    void setShader(ShaderGroup target, int shaderId) {
        if (OpenGlHelper.shadersSupported) {
            Minecraft mc = Minecraft.getMinecraft();
            if (RenderEventHandler.shaderGroups.containsKey(shaderId)) {
                RenderEventHandler.shaderGroups.get(shaderId).deleteShaderGroup();
                RenderEventHandler.shaderGroups.remove(shaderId);
            }
            try {
                if (target == null) {
                    this.deactivateShader(shaderId);
                } else {
                    RenderEventHandler.resetShaders = true;
                    RenderEventHandler.shaderGroups.put(shaderId, target);
                }
            }
            catch (Exception ioexception) {
                RenderEventHandler.shaderGroups.remove(shaderId);
            }
        }
    }

    public void deactivateShader(int shaderId) {
        if (RenderEventHandler.shaderGroups.containsKey(shaderId)) {
            RenderEventHandler.shaderGroups.get(shaderId).deleteShaderGroup();
        }
        RenderEventHandler.shaderGroups.remove(shaderId);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientWorldTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient world = mc.theWorld;
        if (event.phase == TickEvent.Phase.START) {
            ++this.tickCount;
            for (String fxk : EssentiaHandler.sourceFX.keySet().toArray(new String[0])) {
                EssentiaHandler.EssentiaSourceFX fx = EssentiaHandler.sourceFX.get(fxk);
                if (fx.ticks <= 0) {
                    EssentiaHandler.sourceFX.remove(fxk);
                    continue;
                }
                if (world == null) continue;
                int mod = 0;
                TileEntity tile = world.getTileEntity(fx.start.posX, fx.start.posY, fx.start.posZ);
                if (tile != null && tile instanceof TileInfusionMatrix) {
                    mod = -1;
                }
                if (fx.ticks > 5) {
                    Thaumcraft.proxy.essentiaTrailFx((World)world, fx.end.posX, fx.end.posY, fx.end.posZ, fx.start.posX, fx.start.posY + mod, fx.start.posZ, this.tickCount, fx.color, 1.0f);
                } else {
                    float scale = (float)(fx.ticks * fx.ticks) / 25.0f;
                    Thaumcraft.proxy.essentiaTrailFx((World)world, fx.end.posX, fx.end.posY, fx.end.posZ, fx.start.posX, fx.start.posY + mod, fx.start.posZ, this.tickCount - (5 - fx.ticks), fx.color, scale);
                }
                --fx.ticks;
                EssentiaHandler.sourceFX.put(fxk, fx);
            }
        } else if (mc.theWorld != null && !this.checkedDate) {
            this.checkedDate = true;
            Calendar calendar = mc.theWorld.getCurrentDate();
            if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31) {
                Thaumcraft.isHalloween = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        block13: {
            long time;
            EntityPlayer player;
            Minecraft mc;
            block14: {
                GuiScreen gui;
                block16: {
                    block15: {
                        mc = FMLClientHandler.instance().getClient();
                        WorldClient world = mc.theWorld;
                        if (event.phase == TickEvent.Phase.START || !(Minecraft.getMinecraft().renderViewEntity instanceof EntityPlayer)) break block13;
                        player = (EntityPlayer)Minecraft.getMinecraft().renderViewEntity;
                        time = System.currentTimeMillis();
                        if (researchPopup == null) {
                            researchPopup = new GuiResearchPopup(mc);
                        }
                        researchPopup.updateResearchWindow();
                        gui = mc.currentScreen;
                        if (!(gui instanceof GuiContainer)) break block14;
                        if (!gui.isShiftKeyDown()) break block15;
                        if (!Config.showTags) break block16;
                    }
                    if (gui.isShiftKeyDown() || !Config.showTags) break block14;
                }
                if (!Mouse.isGrabbed()) {
                    this.renderAspectsInGui((GuiContainer)gui, player);
                }
            }
            if (player != null && mc.inGameHasFocus) {
                if (mc.isGuiEnabled()) {
                    if (player.inventory.armorItemInSlot(2) != null && player.inventory.armorItemInSlot(2).getItem() == ConfigItems.itemHoverHarness) {
                        this.renderHoverHUD(event.renderTickTime, player, time, player.inventory.armorItemInSlot(2));
                    }
                    if (!player.capabilities.isCreativeMode && Thaumcraft.instance.runicEventHandler.runicCharge.containsKey(player.getEntityId()) && Thaumcraft.instance.runicEventHandler.runicCharge.get(player.getEntityId()) > 0 && Thaumcraft.instance.runicEventHandler.runicInfo.containsKey(player.getEntityId())) {
                        this.renderRunicArmorBar(event.renderTickTime, player, time);
                    }
                    if (player.inventory.getCurrentItem() != null) {
                        if (player.inventory.getCurrentItem().getItem() instanceof ItemWandCasting) {
                            this.renderCastingWandHud(Float.valueOf(event.renderTickTime), player, time, player.inventory.getCurrentItem());
                        } else if (player.inventory.getCurrentItem().getItem() instanceof ItemSanityChecker) {
                            this.renderSanityHud(Float.valueOf(event.renderTickTime), player, time);
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderSanityHud(Float partialTicks, EntityPlayer player, long time) {
        Minecraft mc = Minecraft.getMinecraft();
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.getMinecraft(), mc.displayWidth, mc.displayHeight);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.getScaledWidth_double(), (double)sr.getScaledHeight_double(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        int k = sr.getScaledWidth();
        int l = sr.getScaledHeight();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.renderEngine.bindTexture(this.HUD);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad(1, 1, 152, 0, 20, 76, -90.0);
        GL11.glPopMatrix();
        float tw = Thaumcraft.proxy.getPlayerKnowledge().getWarpTotal(player.getCommandSenderName());
        int p = Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(player.getCommandSenderName());
        int s = Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(player.getCommandSenderName());
        int t = Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(player.getCommandSenderName());
        float mod = 1.0f;
        if (tw > 100.0f) {
            mod = 100.0f / tw;
            tw = 100.0f;
        }
        int gap = (int)((100.0f - tw) / 100.0f * 48.0f);
        int wt = (int)((float)t / 100.0f * 48.0f * mod);
        int ws = (int)((float)s / 100.0f * 48.0f * mod);
        if (t > 0) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)0.5f, (float)1.0f, (float)1.0f);
            UtilsFX.drawTexturedQuad(7, 21 + gap, 200, gap, 8, wt + gap, -90.0);
            GL11.glPopMatrix();
        }
        if (s > 0) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)0.75f, (float)0.0f, (float)0.75f, (float)1.0f);
            UtilsFX.drawTexturedQuad(7, 21 + wt + gap, 200, wt + gap, 8, wt + ws + gap, -90.0);
            GL11.glPopMatrix();
        }
        if (p > 0) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)0.5f, (float)0.0f, (float)0.5f, (float)1.0f);
            UtilsFX.drawTexturedQuad(7, 21 + wt + ws + gap, 200, wt + ws + gap, 8, 48, -90.0);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad(1, 1, 176, 0, 20, 76, -90.0);
        GL11.glPopMatrix();
        if (tw >= 100.0f) {
            GL11.glPushMatrix();
            UtilsFX.drawTexturedQuad(1, 1, 216, 0, 20, 16, -90.0);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderCastingWandHud(Float partialTicks, EntityPlayer player, long time, ItemStack wandstack) {
        Minecraft mc = Minecraft.getMinecraft();
        ItemWandCasting wand = (ItemWandCasting)wandstack.getItem();
        if (this.oldvals.get(player.inventory.currentItem) == null) {
            this.oldvals.put(player.inventory.currentItem, wand.getAllVis(wandstack));
        } else if (this.nextsync <= time) {
            this.oldvals.put(player.inventory.currentItem, wand.getAllVis(wandstack));
            this.nextsync = time + 1000L;
        }
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.getMinecraft(), mc.displayWidth, mc.displayHeight);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.getScaledWidth_double(), (double)sr.getScaledHeight_double(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        int k = sr.getScaledWidth();
        int l = sr.getScaledHeight();
        int dailLocation = Config.dialBottom ? l - 32 : 0;
        GL11.glTranslatef((float)0.0f, (float)dailLocation, (float)-2000.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.renderEngine.bindTexture(this.HUD);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        UtilsFX.drawTexturedQuad(0, 0, 0, 0, 64, 64, -90.0);
        GL11.glPopMatrix();
        GL11.glTranslatef((float)16.0f, (float)16.0f, (float)0.0f);
        int max = wand.getMaxVis(wandstack);
        ItemFocusBasic focus = wand.getFocus(wandstack);
        ItemStack focusStack = wand.getFocusItem(wandstack);
        int count = 0;
        AspectList aspects = wand.getAllVis(wandstack);
        for (Aspect aspect : aspects.getAspects()) {
            int amt = aspects.getAmount(aspect);
            GL11.glPushMatrix();
            if (!Config.dialBottom) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glRotatef((float)(-15 + count * 24), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)-32.0f, (float)0.0f);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            int loc = (int)(30.0f * (float)amt / (float)max);
            GL11.glPushMatrix();
            Color ac = new Color(aspect.getColor());
            GL11.glColor4f((float)((float)ac.getRed() / 255.0f), (float)((float)ac.getGreen() / 255.0f), (float)((float)ac.getBlue() / 255.0f), (float)0.8f);
            UtilsFX.drawTexturedQuad(-4, 35 - loc, 104, 0, 8, loc, -90.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            UtilsFX.drawTexturedQuad(-8, -3, 72, 0, 16, 42, -90.0);
            GL11.glPopMatrix();
            int sh = 0;
            if (focus != null && focus.getVisCost(focusStack).getAmount(aspect) > 0) {
                GL11.glPushMatrix();
                UtilsFX.drawTexturedQuad(-4, -8, 136, 0, 8, 8, -90.0);
                sh = 8;
                GL11.glPopMatrix();
            }
            if (this.oldvals.get(player.inventory.currentItem).getAmount(aspect) > amt) {
                GL11.glPushMatrix();
                UtilsFX.drawTexturedQuad(-4, -8 - sh, 128, 0, 8, 8, -90.0);
                GL11.glPopMatrix();
            } else if (this.oldvals.get(player.inventory.currentItem).getAmount(aspect) < amt) {
                GL11.glPushMatrix();
                UtilsFX.drawTexturedQuad(-4, -8 - sh, 120, 0, 8, 8, -90.0);
                GL11.glPopMatrix();
            }
            if (player.isSneaking()) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                String msg = amt / 100 + "";
                mc.ingameGUI.drawString(mc.fontRenderer, msg, -32, -4, 0xFFFFFF);
                GL11.glPopMatrix();
                if (focus != null && focus.getVisCost(focusStack).getAmount(aspect) > 0) {
                    float mod = wand.getConsumptionModifier(wandstack, player, aspect, false);
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    msg = this.myFormatter.format((float)focus.getVisCost(focusStack).getAmount(aspect) * mod / 100.0f);
                    mc.ingameGUI.drawString(mc.fontRenderer, msg, 8, -4, 0xFFFFFF);
                    GL11.glPopMatrix();
                }
                mc.renderEngine.bindTexture(this.HUD);
            }
            GL11.glPopMatrix();
            ++count;
        }
        if (focus != null) {
            ItemFocusTrade wt;
            ItemStack picked = null;
            if (focus instanceof ItemFocusTrade && (picked = (wt = (ItemFocusTrade)focus).getPickedBlock(player.inventory.getCurrentItem())) != null) {
                this.renderWandTradeHud(partialTicks.floatValue(), player, time, picked);
            }
            if (picked == null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-24.0f, (float)-24.0f, (float)90.0f);
                GL11.glEnable((int)2896);
                this.ri.renderItemAndEffectIntoGUI(mc.fontRenderer, mc.renderEngine, wand.getFocusItem(wandstack), 16, 16);
                GL11.glDisable((int)2896);
                GL11.glPopMatrix();
                float f = WandManager.getCooldown((EntityLivingBase)player);
                if (f > 0.0f) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
                    GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                    String secs = this.myFormatter2.format(f) + "s";
                    int w = mc.fontRenderer.getStringWidth(secs) / 2;
                    mc.ingameGUI.drawString(mc.fontRenderer, secs, -w, -4, 0xFFFFFF);
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRunicArmorBar(float partialTicks, EntityPlayer player, long time) {
        Minecraft mc = Minecraft.getMinecraft();
        float total = Thaumcraft.instance.runicEventHandler.runicInfo.get(player.getEntityId())[0].intValue();
        float current = Thaumcraft.instance.runicEventHandler.runicCharge.get(player.getEntityId()).intValue();
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.getMinecraft(), mc.displayWidth, mc.displayHeight);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.getScaledWidth_double(), (double)sr.getScaledHeight_double(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        int k = sr.getScaledWidth();
        int l = sr.getScaledHeight();
        GL11.glTranslatef((float)(k / 2 - 91), (float)(l - 39), (float)0.0f);
        mc.renderEngine.bindTexture(ParticleEngine.particleTexture);
        float fill = current / total;
        int a = 0;
        while ((float)a < fill * 10.0f) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            UtilsFX.drawTexturedQuad(a * 8, 0, 160, 16, 9, 9, -90.0);
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            GL11.glColor4f((float)1.0f, (float)0.75f, (float)0.24f, (float)(MathHelper.sin((float)((float)player.ticksExisted / 4.0f + (float)a)) * 0.4f + 0.6f));
            UtilsFX.drawTexturedQuad(a * 16, 0, a * 16, 96, 16, 16, -90.0);
            GL11.glPopMatrix();
            ++a;
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHoverHUD(float partialTicks, EntityPlayer player, long time, ItemStack armor) {
        AspectList aspects;
        ItemStack jar;
        Minecraft mc = Minecraft.getMinecraft();
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.getMinecraft(), mc.displayWidth, mc.displayHeight);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.getScaledWidth_double(), (double)sr.getScaledHeight_double(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        int k = sr.getScaledWidth();
        int l = sr.getScaledHeight();
        short fuel = 0;
        if (armor.hasTagCompound() && armor.stackTagCompound.hasKey("jar") && (jar = ItemStack.loadItemStackFromNBT((NBTTagCompound)armor.stackTagCompound.getCompoundTag("jar"))) != null && jar.getItem() instanceof ItemJarFilled && jar.hasTagCompound() && (aspects = ((ItemJarFilled)jar.getItem()).getAspects(jar)) != null && aspects.size() > 0) {
            fuel = (short)aspects.getAmount(Aspect.ENERGY);
        }
        int level = Math.round((float)fuel / 64.0f * 48.0f);
        mc.renderEngine.bindTexture(ParticleEngine.particleTexture);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.75f, (float)1.0f);
        UtilsFX.drawTexturedQuad(6, l / 2 + 24 - level, 224, 48 - level, 8, level, -91.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad(5, l / 2 - 28, 240, 0, 10, 56, -90.0);
        if (armor.hasTagCompound() && armor.stackTagCompound.hasKey("hover") && armor.stackTagCompound.getByte("hover") == 1) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.66f);
            UtilsFX.drawTexturedQuad(2, l / 2 - 43, 16 * ((int)(mc.getSystemTime() % 700L) / 50), 32, 16, 16, -90.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        try {
            ResourceLocation resourcelocation = mc.renderEngine.getResourceLocation(armor.getItemSpriteNumber());
            mc.renderEngine.bindTexture(resourcelocation);
            IIcon object = armor.getIconIndex();
            if (object == null) {
                object = ((TextureMap)Minecraft.getMinecraft().getTextureManager().getTexture(resourcelocation)).getAtlasSprite("missingno");
            }
            int i1 = armor.getItem().getColorFromItemStack(armor, 0);
            float f2 = (float)(i1 >> 16 & 0xFF) / 255.0f;
            float f = (float)(i1 >> 8 & 0xFF) / 255.0f;
            float f1 = (float)(i1 & 0xFF) / 255.0f;
            GL11.glColor4f((float)f2, (float)f, (float)f1, (float)1.0f);
            this.ri.renderIcon(2, l / 2 - 43, object, 16, 16);
        }
        catch (Exception e) {
            // empty catch block
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderWandTradeHud(float partialTicks, EntityPlayer player, long time, ItemStack picked) {
        Minecraft mc = Minecraft.getMinecraft();
        int amount = this.lastCount;
        if (player.inventory.inventoryChanged || !picked.isItemEqual(this.lastItem)) {
            amount = 0;
            for (ItemStack is : player.inventory.mainInventory) {
                if (is == null || !is.isItemEqual(picked)) continue;
                amount += is.stackSize;
            }
            this.lastItem = picked;
            player.inventory.inventoryChanged = false;
        }
        this.lastCount = amount;
        GL11.glPushMatrix();
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        try {
            this.ri.renderItemAndEffectIntoGUI(mc.fontRenderer, mc.renderEngine, picked, -8, -8);
        }
        catch (Exception e) {
            // empty catch block
        }
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        String am = "" + amount;
        int sw = mc.fontRenderer.getStringWidth(am);
        GL11.glTranslatef((float)0.0f, (float)(-mc.fontRenderer.FONT_HEIGHT), (float)500.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        for (int a = -1; a <= 1; ++a) {
            for (int b = -1; b <= 1; ++b) {
                if (a != 0 && b != 0 || a == 0 && b == 0) continue;
                mc.fontRenderer.drawString(am, a + 16 - sw, b + 24, 0);
            }
        }
        mc.fontRenderer.drawString(am, 16 - sw, 24, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void renderAspectsInGui(GuiContainer gui, EntityPlayer player) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        ScaledResolution var13 = new ScaledResolution(Minecraft.getMinecraft(), mc.displayWidth, mc.displayHeight);
        int var14 = var13.getScaledWidth();
        int var15 = var13.getScaledHeight();
        int var16 = Mouse.getX() * var14 / mc.displayWidth;
        int var17 = var15 - Mouse.getY() * var15 / mc.displayHeight - 1;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        for (int var20 = 0; var20 < gui.inventorySlots.inventorySlots.size(); ++var20) {
            int guiTop;
            int guiLeft;
            Slot var23;
            int xs = UtilsFX.getGuiXSize(gui);
            int ys = UtilsFX.getGuiYSize(gui);
            int shift = 0;
            int shift2 = 0;
            int shiftx = -8;
            int shifty = -8;
            if (Thaumcraft.instance.aspectShift) {
                shiftx -= 8;
                shifty -= 8;
            }
            if (!this.isMouseOverSlot(var23 = (Slot)gui.inventorySlots.inventorySlots.get(var20), var16, var17, guiLeft = shift + (gui.width - xs - shift2) / 2, guiTop = (gui.height - ys) / 2) || var23.getStack() == null) continue;
            int h = ScanManager.generateItemHash(var23.getStack().getItem(), var23.getStack().getItemDamage());
            List list = Thaumcraft.proxy.getScannedObjects().get(player.getCommandSenderName());
            if (list == null || !list.contains("@" + h) && !list.contains("#" + h)) continue;
            AspectList tags = ThaumcraftCraftingManager.getObjectTags(var23.getStack());
            tags = ThaumcraftCraftingManager.getBonusTags(var23.getStack(), tags);
            if (tags == null) continue;
            int x = var16 + 17;
            int y = var17 + 7 - 33;
            GL11.glDisable((int)2929);
            int index = 0;
            if (tags.size() > 0) {
                for (Aspect tag : tags.getAspectsSortedAmount()) {
                    if (tag == null) continue;
                    x = var16 + 17 + index * 18;
                    y = var17 + 7 - 33;
                    UtilsFX.bindTexture("textures/aspects/_back.png");
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glTranslated((double)(x + shiftx - 2), (double)(y + shifty - 2), (double)0.0);
                    GL11.glScaled((double)1.25, (double)1.25, (double)0.0);
                    UtilsFX.drawTexturedQuadFull(0, 0, UtilsFX.getGuiZLevel((Gui)gui));
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                    if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(player.getCommandSenderName(), tag)) {
                        UtilsFX.drawTag(x + shiftx, y + shifty, tag, tags.getAmount(tag), 0, UtilsFX.getGuiZLevel((Gui)gui));
                    } else {
                        UtilsFX.bindTexture("textures/aspects/_unknown.png");
                        GL11.glPushMatrix();
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glTranslated((double)(x + shiftx), (double)(y + shifty), (double)0.0);
                        UtilsFX.drawTexturedQuadFull(0, 0, UtilsFX.getGuiZLevel((Gui)gui));
                        GL11.glDisable((int)3042);
                        GL11.glPopMatrix();
                    }
                    ++index;
                }
            }
            GL11.glEnable((int)2929);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3, int par4, int par5) {
        int var4 = par4;
        int var5 = par5;
        return (par2 -= var4) >= par1Slot.xDisplayPosition - 1 && par2 < par1Slot.xDisplayPosition + 16 + 1 && (par3 -= var5) >= par1Slot.yDisplayPosition - 1 && par3 < par1Slot.yDisplayPosition + 16 + 1;
    }
}

