/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.entities.monster.boss.EntityCultistPortal;

@SideOnly(value=Side.CLIENT)
public class RenderCultistPortal
extends Render {
    public static final ResourceLocation portaltex = new ResourceLocation("thaumcraft", "textures/misc/cultist_portal.png");

    public RenderCultistPortal() {
        this.shadowSize = 0.1f;
        this.shadowOpaque = 0.5f;
    }

    public void renderPortal(EntityCultistPortal portal, double px, double py, double pz, float par8, float f) {
        double d;
        if (BossStatus.statusBarTime < 100) {
            BossStatus.setBossStatus((IBossDisplayData)portal, (boolean)false);
        }
        long nt = System.nanoTime();
        long time = nt / 50000000L;
        float scaley = 1.5f;
        int e = (int)Math.min(50.0f, (float)portal.ticksExisted + f);
        if (portal.hurtTime > 0) {
            d = Math.sin((double)(portal.hurtTime * 72) * Math.PI / 180.0);
            scaley = (float)((double)scaley - d / 4.0);
            e = (int)((double)e + 6.0 * d);
        }
        if (portal.pulse > 0) {
            d = Math.sin((double)(portal.pulse * 36) * Math.PI / 180.0);
            scaley = (float)((double)scaley + d / 4.0);
            e = (int)((double)e + 12.0 * d);
        }
        float scale = (float)e / 50.0f * 1.3f;
        py += (double)(portal.height / 2.0f);
        float m = (1.0f - portal.getHealth() / portal.getMaxHealth()) / 3.0f;
        float bob = MathHelper.sin((float)((float)portal.ticksExisted / (5.0f - 12.0f * m))) * m + m;
        float bob2 = MathHelper.sin((float)((float)portal.ticksExisted / (6.0f - 15.0f * m))) * m + m;
        float alpha = 1.0f - bob;
        scaley -= bob / 4.0f;
        scale -= bob2 / 3.0f;
        UtilsFX.bindTexture(portaltex);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (Minecraft.getMinecraft().renderViewEntity instanceof EntityPlayer) {
            Tessellator tessellator = Tessellator.instance;
            float arX = ActiveRenderInfo.rotationX;
            float arZ = ActiveRenderInfo.rotationZ;
            float arYZ = ActiveRenderInfo.rotationYZ;
            float arXY = ActiveRenderInfo.rotationXY;
            float arXZ = ActiveRenderInfo.rotationXZ;
            EntityPlayer player = (EntityPlayer)Minecraft.getMinecraft().renderViewEntity;
            double iPX = player.prevPosX + (player.posX - player.prevPosX) * (double)f;
            double iPY = player.prevPosY + (player.posY - player.prevPosY) * (double)f;
            double iPZ = player.prevPosZ + (player.posZ - player.prevPosZ) * (double)f;
            tessellator.startDrawingQuads();
            tessellator.setBrightness(220);
            tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, alpha);
            Vec3 v1 = Vec3.createVectorHelper((double)(-arX - arYZ), (double)(-arXZ), (double)(-arZ - arXY));
            Vec3 v2 = Vec3.createVectorHelper((double)(-arX + arYZ), (double)arXZ, (double)(-arZ + arXY));
            Vec3 v3 = Vec3.createVectorHelper((double)(arX + arYZ), (double)arXZ, (double)(arZ + arXY));
            Vec3 v4 = Vec3.createVectorHelper((double)(arX - arYZ), (double)(-arXZ), (double)(arZ - arXY));
            int frame = 15 - (int)time % 16;
            float f2 = (float)frame / 16.0f;
            float f3 = f2 + 0.0625f;
            float f4 = 0.0f;
            float f5 = 1.0f;
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            tessellator.addVertexWithUV(px + v1.xCoord * (double)scale, py + v1.yCoord * (double)scaley, pz + v1.zCoord * (double)scale, (double)f3, (double)f4);
            tessellator.addVertexWithUV(px + v2.xCoord * (double)scale, py + v2.yCoord * (double)scaley, pz + v2.zCoord * (double)scale, (double)f3, (double)f5);
            tessellator.addVertexWithUV(px + v3.xCoord * (double)scale, py + v3.yCoord * (double)scaley, pz + v3.zCoord * (double)scale, (double)f2, (double)f5);
            tessellator.addVertexWithUV(px + v4.xCoord * (double)scale, py + v4.yCoord * (double)scaley, pz + v4.zCoord * (double)scale, (double)f2, (double)f4);
            tessellator.draw();
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.renderPortal((EntityCultistPortal)par1Entity, par2, par4, par6, par8, par9);
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        return AbstractClientPlayer.locationStevePng;
    }
}

