/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.models;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.renderers.models.ModelRendererTaintacle;
import thaumcraft.common.entities.monster.EntityTaintacle;

public class ModelTaintacle
extends ModelBase {
    public ModelRenderer tentacle = new ModelRendererTaintacle(this);
    public ModelRenderer[] tents;
    public ModelRenderer orb = new ModelRendererTaintacle(this);
    private int length = 10;

    public ModelTaintacle(int length) {
        boolean var3 = false;
        this.length = length;
        this.textureHeight = 64;
        this.textureWidth = 64;
        this.tentacle = new ModelRendererTaintacle(this, 0, 0);
        this.tentacle.addBox(-4.0f, -4.0f, -4.0f, 8, 8, 8);
        this.tentacle.rotationPointX = 0.0f;
        this.tentacle.rotationPointZ = 0.0f;
        this.tentacle.rotationPointY = 12.0f;
        this.tents = new ModelRendererTaintacle[length];
        for (int k = 0; k < length - 1; ++k) {
            this.tents[k] = new ModelRendererTaintacle(this, 0, 16);
            this.tents[k].addBox(-4.0f, -4.0f, -4.0f, 8, 8, 8);
            this.tents[k].rotationPointY = -8.0f;
            if (k == 0) {
                this.tentacle.addChild(this.tents[k]);
                continue;
            }
            this.tents[k - 1].addChild(this.tents[k]);
        }
        this.orb = new ModelRendererTaintacle(this, 0, 56);
        this.orb.addBox(-2.0f, -2.0f, -2.0f, 4, 4, 4);
        this.orb.rotationPointY = -8.0f;
        this.tents[length - 2].addChild(this.orb);
        this.tents[length - 1] = new ModelRendererTaintacle(this, 0, 32);
        this.tents[length - 1].addBox(-6.0f, -6.0f, -6.0f, 12, 12, 12);
        this.tents[length - 1].rotationPointY = -8.0f;
        this.tents[length - 2].addChild(this.tents[length - 1]);
    }

    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, Entity entity) {
        boolean agi = false;
        float flail = 0.0f;
        int ht = 0;
        int at = 0;
        if (entity instanceof EntityTaintacle) {
            EntityTaintacle tentacle = (EntityTaintacle)entity;
            agi = tentacle.getAgitationState();
            flail = tentacle.flailIntensity;
            ht = tentacle.hurtTime;
            at = tentacle.attackTime;
        }
        float mod = par6 * 0.2f;
        float fs = agi ? 3.0f : 1.0f + (agi ? mod : -mod);
        float fi = flail + (ht > 0 || at > 0 ? mod : -mod);
        this.tentacle.rotateAngleX = 0.0f;
        for (int k = 0; k < this.length - 1; ++k) {
            this.tents[k].rotateAngleX = 0.15f * fi * MathHelper.sin((float)(par3 * 0.1f * fs - (float)k / 2.0f));
            this.tents[k].rotateAngleZ = 0.1f / fi * MathHelper.sin((float)(par3 * 0.15f - (float)k / 2.0f));
        }
    }

    public void render(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        this.setRotationAngles(par2, par3, par4, par5, par6, par7, par1Entity);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float height = 0.0f;
        float hc = par1Entity.height * 10.0f;
        if ((float)par1Entity.ticksExisted < hc) {
            height = (hc - (float)par1Entity.ticksExisted) / hc * par1Entity.height;
        }
        GL11.glTranslatef((float)0.0f, (float)((par1Entity.height == 3.0f ? 0.6f : 1.2f) + height), (float)0.0f);
        GL11.glScalef((float)(par1Entity.height / 3.0f), (float)(par1Entity.height / 3.0f), (float)(par1Entity.height / 3.0f));
        ((ModelRendererTaintacle)this.tentacle).render(par7, 0.88f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

