/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.tiles.TileJarFillable;
import thaumcraft.common.tiles.TileJarFillableVoid;

public class ItemJarFilledRenderer
implements IItemRenderer {
    RenderBlocks rb = new RenderBlocks();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return item != null && item.getItem() == ConfigItems.itemJarFilled;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (item.getItem() == ConfigItems.itemJarFilled) {
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)-0.5f);
            } else if (type == IItemRenderer.ItemRenderType.EQUIPPED && data[1] instanceof EntityPlayer) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
            }
            TileJarFillable tjf = new TileJarFillable();
            if (item.hasTagCompound()) {
                String tf;
                AspectList aspects;
                if (item.getItemDamage() == 3) {
                    tjf = new TileJarFillableVoid();
                }
                if ((aspects = ((ItemJarFilled)item.getItem()).getAspects(item)) != null && aspects.size() == 1) {
                    tjf.amount = aspects.getAmount(aspects.getAspects()[0]);
                    tjf.aspect = aspects.getAspects()[0];
                }
                if ((tf = item.stackTagCompound.getString("AspectFilter")) != null) {
                    tjf.aspectFilter = Aspect.getAspect(tf);
                }
            }
            tjf.facing = 5;
            tjf.blockType = ConfigBlocks.blockJar;
            tjf.blockMetadata = 0;
            TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)tjf, 0.0, 0.0, 0.0, 0.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationBlocksTexture);
            this.rb.useInventoryTint = true;
            this.rb.renderBlockAsItem(ConfigBlocks.blockJar, item.getItemDamage(), 1.0f);
            GL11.glPopMatrix();
            GL11.glEnable((int)32826);
        }
    }
}

