/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.tiles.TileEldritchAltar;

public class TileEldritchCapRenderer
extends TileEntitySpecialRenderer {
    private IModelCustom model;
    private static final ResourceLocation CAP = new ResourceLocation("thaumcraft", "textures/models/obelisk_cap.obj");
    private String tex = "textures/models/obelisk_cap.png";
    private String tex2 = "textures/models/obelisk_cap_2.png";
    private ItemStack eye = null;
    EntityItem entityitem = null;

    public TileEldritchCapRenderer(String texture) {
        this.tex = texture;
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)CAP);
    }

    public TileEldritchCapRenderer() {
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)CAP);
    }

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float f) {
        String tempTex = this.tex;
        GL11.glPushMatrix();
        if (te.getWorldObj() != null) {
            int j = te.getBlockType().getMixedBrightnessForBlock((IBlockAccess)te.getWorldObj(), te.xCoord, te.yCoord, te.zCoord);
            int k = j % 65536;
            int l = j / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
            if (te.getWorldObj().provider.dimensionId == Config.dimensionOuterId) {
                tempTex = this.tex2;
            }
        }
        GL11.glPushMatrix();
        UtilsFX.bindTexture(tempTex);
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
        this.model.renderPart("Cap");
        GL11.glPopMatrix();
        if (te.getWorldObj() != null && te instanceof TileEldritchAltar && ((TileEldritchAltar)te).getEyes() > 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.0f), (float)((float)z + 0.5f));
            if (this.entityitem == null || this.eye == null) {
                this.eye = new ItemStack(ConfigItems.itemEldritchObject, 1, 0);
                this.entityitem = new EntityItem(te.getWorldObj(), 0.0, 0.0, 0.0, this.eye);
                this.entityitem.hoverStart = 0.0f;
            }
            if (this.entityitem != null && this.eye != null) {
                for (int a = 0; a < ((TileEldritchAltar)te).getEyes(); ++a) {
                    GL11.glPushMatrix();
                    GL11.glRotated((double)(a * 90), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)0.46f, (float)0.2f, (float)0.0f);
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)18.0, (double)-1.0, (double)0.0, (double)0.0);
                    RenderItem.renderInFrame = true;
                    RenderManager.instance.renderEntityWithPosYaw((Entity)this.entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                    RenderItem.renderInFrame = false;
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

