/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.tiles.TileEldritchPortal;

public class TileEldritchPortalRenderer
extends TileEntitySpecialRenderer {
    public static final ResourceLocation portaltex = new ResourceLocation("thaumcraft", "textures/misc/eldritch_portal.png");

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        if (te.getWorldObj() != null) {
            this.renderPortal((TileEldritchPortal)te, x, y, z, f);
        }
        GL11.glPopMatrix();
    }

    private void renderPortal(TileEldritchPortal te, double x, double y, double z, float f) {
        long nt = System.nanoTime();
        long time = nt / 50000000L;
        int c = (int)Math.min(30.0f, (float)te.opencount + f);
        int e = (int)Math.min(5.0f, (float)te.opencount + f);
        float scale = (float)e / 5.0f;
        float scaley = (float)c / 30.0f;
        UtilsFX.bindTexture(portaltex);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        if (Minecraft.getMinecraft().renderViewEntity instanceof EntityPlayer) {
            Tessellator tessellator = Tessellator.instance;
            float arX = ActiveRenderInfo.rotationX;
            float arZ = ActiveRenderInfo.rotationZ;
            float arYZ = ActiveRenderInfo.rotationYZ;
            float arXY = ActiveRenderInfo.rotationXY;
            float arXZ = ActiveRenderInfo.rotationXZ;
            EntityPlayer player = (EntityPlayer)Minecraft.getMinecraft().renderViewEntity;
            double iPX = player.prevPosX + (player.posX - player.prevPosX) * (double)f;
            double iPY = player.prevPosY + (player.posY - player.prevPosY) * (double)f;
            double iPZ = player.prevPosZ + (player.posZ - player.prevPosZ) * (double)f;
            tessellator.startDrawingQuads();
            tessellator.setBrightness(220);
            tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
            double px = x + 0.5;
            double py = y + 0.5;
            double pz = z + 0.5;
            Vec3 v1 = Vec3.createVectorHelper((double)(-arX - arYZ), (double)(-arXZ), (double)(-arZ - arXY));
            Vec3 v2 = Vec3.createVectorHelper((double)(-arX + arYZ), (double)arXZ, (double)(-arZ + arXY));
            Vec3 v3 = Vec3.createVectorHelper((double)(arX + arYZ), (double)arXZ, (double)(arZ + arXY));
            Vec3 v4 = Vec3.createVectorHelper((double)(arX - arYZ), (double)(-arXZ), (double)(arZ - arXY));
            int frame = (int)time % 16;
            float f2 = (float)frame / 16.0f;
            float f3 = f2 + 0.0625f;
            float f4 = 0.0f;
            float f5 = 1.0f;
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            tessellator.addVertexWithUV(px + v1.xCoord * (double)scale, py + v1.yCoord * (double)scaley, pz + v1.zCoord * (double)scale, (double)f2, (double)f5);
            tessellator.addVertexWithUV(px + v2.xCoord * (double)scale, py + v2.yCoord * (double)scaley, pz + v2.zCoord * (double)scale, (double)f3, (double)f5);
            tessellator.addVertexWithUV(px + v3.xCoord * (double)scale, py + v3.yCoord * (double)scaley, pz + v3.zCoord * (double)scale, (double)f3, (double)f4);
            tessellator.addVertexWithUV(px + v4.xCoord * (double)scale, py + v4.yCoord * (double)scaley, pz + v4.zCoord * (double)scale, (double)f2, (double)f4);
            tessellator.draw();
        }
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }
}

