/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.nodes.INode;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXSpark;
import thaumcraft.client.fx.particles.FXSparkle;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemWispEssence;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.tiles.TileNitor;
import thaumcraft.common.tiles.TileNode;
import thaumcraft.common.tiles.TileNodeConverter;
import thaumcraft.common.tiles.TileNodeEnergized;
import thaumcraft.common.tiles.TileNodeStabilizer;
import thaumcraft.common.tiles.TileWardingStone;
import thaumcraft.common.tiles.TileWardingStoneFence;

public class BlockAiry
extends BlockContainer {
    public IIcon blankIcon;

    public BlockAiry() {
        super(Config.airyMaterial);
        this.setStepSound(new Block.SoundType("cloth", 0.0f, 1.0f));
        this.setCreativeTab(Thaumcraft.tabTC);
        this.setTickRandomly(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister ir) {
        this.blankIcon = ir.registerIcon("thaumcraft:blank");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.blankIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int md = worldObj.getBlockMetadata(target.blockX, target.blockY, target.blockZ);
        if ((md == 0 || md == 5) && worldObj.rand.nextBoolean()) {
            UtilsFX.infusedStoneSparkle(worldObj, target.blockX, target.blockY, target.blockZ, 0);
        }
        return super.addHitEffects(worldObj, target, effectRenderer);
    }

    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        if (meta == 0 || meta == 5) {
            Thaumcraft.proxy.burst(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f);
            world.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:craftfail", 1.0f, 1.0f, false);
        }
        return super.addDestroyEffects(world, x, y, z, meta, effectRenderer);
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 0 || md == 5) {
            return 2.0f;
        }
        if (md == 10 || md == 11) {
            return 100.0f;
        }
        if (md == 12) {
            return -1.0f;
        }
        return super.getBlockHardness(world, x, y, z);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 0 || md == 5) {
            return 200.0f;
        }
        if (md == 10 || md == 11) {
            return 50.0f;
        }
        if (md == 12) {
            return Float.MAX_VALUE;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 1 || md == 2 || md == 3) {
            return 15;
        }
        if (md == 4 || md == 12) {
            return 0;
        }
        if (md == 0 || md == 5 || md == 10 || md == 11) {
            return 8;
        }
        return super.getLightValue(world, x, y, z);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess ba, int x, int y, int z) {
        int md = ba.getBlockMetadata(x, y, z);
        if (md == 3 || md == 4 || md == 10 || md == 11 || md == 12) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.setBlockBounds(0.3f, 0.3f, 0.3f, 0.7f, 0.7f, 0.7f);
        }
        super.setBlockBoundsBasedOnState(ba, x, y, z);
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        int md = world.getBlockMetadata(x, y, z);
        return md == 2 || md == 3 || md == 4 || md == 10 || md == 11;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 2 || md == 3 || md == 4) {
            return true;
        }
        return super.canBeReplacedByLeaves(world, x, y, z);
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 2 || md == 3) {
            return true;
        }
        return super.isLeaves(world, x, y, z);
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 4 && par7Entity != null && par7Entity instanceof EntityLivingBase && !(par7Entity instanceof EntityPlayer)) {
            int a = 1;
            if (world.getBlock(x, y - a, z) != ConfigBlocks.blockCosmeticSolid) {
                ++a;
            }
            if (!world.isBlockIndirectlyGettingPowered(x, y - a, z)) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.addCollisionBoxesToList(world, x, y, z, par5AxisAlignedBB, par6List, par7Entity);
            }
        } else if (metadata == 12) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, x, y, z, par5AxisAlignedBB, par6List, par7Entity);
        }
    }

    public boolean getBlocksMovement(IBlockAccess world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 4) {
            for (int a = 1; a < 3; ++a) {
                TileEntity te = world.getTileEntity(x, y - a, z);
                if (te == null || !(te instanceof TileWardingStone)) continue;
                return te.getWorldObj().isBlockIndirectlyGettingPowered(x, y - a, z);
            }
        }
        return true;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata != 4 && metadata != 12) {
            return null;
        }
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        int md = par1World.getBlockMetadata(par2, par3, par4);
        if (md == 0 || md == 2 || md == 3 || md == 4 || md == 5 || md == 10 || md == 11 || md == 12) {
            return AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return super.getSelectedBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int damageDropped(int par1) {
        return par1;
    }

    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return par1 == 1 ? ConfigItems.itemResource : Item.getItemById((int)0);
    }

    public Item getItem(World world, int x, int y, int z) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 1) {
            return ConfigItems.itemResource;
        }
        return Item.getItemById((int)0);
    }

    public void onBlockHarvested(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        TileEntity te;
        if (par5 == 0 && !par1World.isRemote && (te = par1World.getTileEntity(par2, par3, par4)) != null && te instanceof INode && ((INode)te).getAspects().size() > 0) {
            for (Aspect aspect : ((INode)te).getAspects().getAspects()) {
                for (int a = 0; a <= ((INode)te).getAspects().getAmount(aspect) / 10; ++a) {
                    if (((INode)te).getAspects().getAmount(aspect) < 5) continue;
                    ItemStack ess = new ItemStack(ConfigItems.itemWispEssence);
                    AspectList al = new AspectList();
                    ((ItemWispEssence)ess.getItem()).setAspects(ess, new AspectList().add(aspect, 2));
                    this.dropBlockAsItem(par1World, par2, par3, par4, ess);
                }
            }
        }
        super.onBlockHarvested(par1World, par2, par3, par4, par5, par6EntityPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int i, int j, int k, Random r) {
        int md = w.getBlockMetadata(i, j, k);
        if (md == 1) {
            FXSparkle ef2 = new FXSparkle(w, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, (float)i + 0.5f + (r.nextFloat() - r.nextFloat()) / 3.0f, (float)j + 0.5f + (r.nextFloat() - r.nextFloat()) / 3.0f, (float)k + 0.5f + (r.nextFloat() - r.nextFloat()) / 3.0f, 1.0f, 6, 3);
            ef2.setGravity(0.05f);
            ef2.noClip = true;
            ParticleEngine.instance.addEffect(w, ef2);
        } else if (md == 2 && r.nextInt(500) == 0) {
            int x1 = i + r.nextInt(3) - r.nextInt(3);
            int y1 = j + r.nextInt(3) - r.nextInt(3);
            int z1 = k + r.nextInt(3) - r.nextInt(3);
            int x2 = x1 + r.nextInt(3) - r.nextInt(3);
            int y2 = y1 + r.nextInt(3) - r.nextInt(3);
            int z2 = z1 + r.nextInt(3) - r.nextInt(3);
            Thaumcraft.proxy.wispFX3(w, x1, y1, z1, x2, y2, z2, 0.1f + r.nextFloat() * 0.1f, 7, false, r.nextBoolean() ? -0.033f : 0.033f);
        } else if (md == 10 || md == 11) {
            float h = r.nextFloat() * 0.33f;
            FXSpark ef = new FXSpark(w, (float)i + w.rand.nextFloat(), (float)j + 0.1515f + h / 2.0f, (float)k + w.rand.nextFloat(), 0.33f + h);
            if (md == 10) {
                ef.setRBGColorF(0.65f + w.rand.nextFloat() * 0.1f, 1.0f, 1.0f);
                ef.setAlphaF(0.8f);
            } else {
                ef.setRBGColorF(0.3f - w.rand.nextFloat() * 0.1f, 0.0f, 0.5f + w.rand.nextFloat() * 0.2f);
            }
            ParticleEngine.instance.addEffect(w, ef);
            if (r.nextInt(50) == 0) {
                w.playSound((double)i, (double)j, (double)k, "thaumcraft:jacobs", 0.5f, 1.0f + (r.nextFloat() - r.nextFloat()) * 0.2f, false);
            }
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0) {
            return new TileNode();
        }
        if (metadata == 1) {
            return new TileNitor();
        }
        if (metadata == 4) {
            return new TileWardingStoneFence();
        }
        if (metadata == 5) {
            return new TileNodeEnergized();
        }
        return super.createTileEntity(world, metadata);
    }

    public TileEntity createNewTileEntity(World var1, int md) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (stack.getItemDamage() == 0 && entity instanceof EntityPlayer) {
            ThaumcraftWorldGenerator.createRandomNodeAt(world, x, y, z, world.rand, false, false, false);
        }
        super.onBlockPlacedBy(world, x, y, z, entity, stack);
    }

    public boolean isAir(IBlockAccess world, int x, int y, int z) {
        int md = world.getBlockMetadata(x, y, z);
        return md == 2 || md == 3 || md == 10 || md == 11;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 5) {
            TileEntity te = world.getTileEntity(x, y - 1, z);
            if (world.isBlockIndirectlyGettingPowered(x, y - 1, z) || te == null || !(te instanceof TileNodeStabilizer)) {
                BlockAiry.explodify(world, x, y, z);
            } else {
                te = world.getTileEntity(x, y + 1, z);
                if (te == null || !(te instanceof TileNodeConverter)) {
                    BlockAiry.explodify(world, x, y, z);
                }
            }
        }
        super.onNeighborBlockChange(world, x, y, z, block);
    }

    public static void explodify(World world, int x, int y, int z) {
        if (!world.isRemote) {
            world.setBlockToAir(x, y, z);
            world.createExplosion(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, false);
            for (int a = 0; a < 50; ++a) {
                int zz;
                int yy;
                int xx = x + world.rand.nextInt(8) - world.rand.nextInt(8);
                if (!world.isAirBlock(xx, yy = y + world.rand.nextInt(8) - world.rand.nextInt(8), zz = z + world.rand.nextInt(8) - world.rand.nextInt(8))) continue;
                if (yy < y) {
                    world.setBlock(xx, yy, zz, ConfigBlocks.blockFluxGoo, 8, 3);
                    continue;
                }
                world.setBlock(xx, yy, zz, ConfigBlocks.blockFluxGas, 8, 3);
            }
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 10) {
            entity.attackEntityFrom(DamageSource.magic, (float)(1 + world.rand.nextInt(2)));
            entity.motionX *= 0.8;
            entity.motionZ *= 0.8;
            if (!world.isRemote && world.rand.nextInt(100) == 0) {
                world.setBlockToAir(x, y, z);
            }
        } else if (md == 11 && !(entity instanceof IEldritchMob)) {
            if (world.rand.nextInt(100) == 0) {
                entity.attackEntityFrom(DamageSource.wither, 1.0f);
            }
            entity.motionX *= 0.66;
            entity.motionZ *= 0.66;
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).addExhaustion(0.05f);
            }
            if (entity instanceof EntityLivingBase) {
                PotionEffect pe = new PotionEffect(Potion.weakness.id, 100, 1, true);
                ((EntityLivingBase)entity).addPotionEffect(pe);
            }
        }
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        int md = world.getBlockMetadata(x, y, z);
        if (!(md != 10 && md != 11 || world.isRemote)) {
            world.setBlockToAir(x, y, z);
        }
    }
}

