/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.CustomStepSound;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.blocks.ItemJarNode;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.tiles.TileJarBrain;
import thaumcraft.common.tiles.TileJarFillable;
import thaumcraft.common.tiles.TileJarFillableVoid;
import thaumcraft.common.tiles.TileJarNode;

public class BlockJar
extends BlockContainer {
    public IIcon iconLiquid;
    public IIcon iconJarBottom;
    public IIcon iconJarSide;
    public IIcon iconJarTop;
    public IIcon iconJarTopVoid;
    public IIcon iconJarSideVoid;

    public BlockJar() {
        super(Material.glass);
        this.setHardness(0.3f);
        this.setStepSound(new CustomStepSound("jar", 1.0f, 1.0f));
        this.setCreativeTab(Thaumcraft.tabTC);
        this.setLightLevel(0.66f);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister ir) {
        this.iconLiquid = ir.registerIcon("thaumcraft:animatedglow");
        this.iconJarSide = ir.registerIcon("thaumcraft:jar_side");
        this.iconJarTop = ir.registerIcon("thaumcraft:jar_top");
        this.iconJarTopVoid = ir.registerIcon("thaumcraft:jar_top_void");
        this.iconJarSideVoid = ir.registerIcon("thaumcraft:jar_side_void");
        this.iconJarBottom = ir.registerIcon("thaumcraft:jar_bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta == 0 || meta == 1 || meta == 2) {
            return side == 0 ? this.iconJarBottom : (side == 1 ? this.iconJarTop : this.iconJarSide);
        }
        if (meta == 3) {
            return side == 0 ? this.iconJarBottom : (side == 1 ? this.iconJarTopVoid : this.iconJarSideVoid);
        }
        return this.iconJarBottom;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 3));
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0) {
            return new TileJarFillable();
        }
        if (metadata == 1) {
            return new TileJarBrain();
        }
        if (metadata == 2) {
            return new TileJarNode();
        }
        if (metadata == 3) {
            return new TileJarFillableVoid();
        }
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return ConfigBlocks.blockJarRI;
    }

    public void onBlockHarvested(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        this.dropBlockAsItem(par1World, par2, par3, par4, par5, 0);
        super.onBlockHarvested(par1World, par2, par3, par4, par5, par6EntityPlayer);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int md = world.getBlockMetadata(x, y, z);
        if (md == 0 || md == 3) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te != null && te instanceof TileJarFillable) {
                ItemStack drop = new ItemStack(ConfigItems.itemJarFilled);
                if (((TileJarFillable)te).amount <= 0 && ((TileJarFillable)te).aspectFilter == null) {
                    drop = new ItemStack((Block)this);
                }
                if (te instanceof TileJarFillableVoid) {
                    drop.setItemDamage(3);
                }
                if (((TileJarFillable)te).amount > 0) {
                    ((ItemJarFilled)drop.getItem()).setAspects(drop, new AspectList().add(((TileJarFillable)te).aspect, ((TileJarFillable)te).amount));
                }
                if (((TileJarFillable)te).aspectFilter != null) {
                    if (!drop.hasTagCompound()) {
                        drop.setTagCompound(new NBTTagCompound());
                    }
                    drop.stackTagCompound.setString("AspectFilter", ((TileJarFillable)te).aspectFilter.getTag());
                }
                drops.add(drop);
            }
            return drops;
        }
        if (md == 2) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te != null && te instanceof TileJarNode && ((TileJarNode)te).drop && ((TileJarNode)te).getAspects() != null) {
                ItemStack drop = new ItemStack(ConfigItems.itemJarNode);
                ((ItemJarNode)drop.getItem()).setAspects(drop, ((TileJarNode)te).getAspects().copy());
                ((ItemJarNode)drop.getItem()).setNodeAttributes(drop, ((TileJarNode)te).getNodeType(), ((TileJarNode)te).getNodeModifier(), ((TileJarNode)te).getId());
                drops.add(drop);
            }
            return drops;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        TileEntity te;
        int md = par1World.getBlockMetadata(par2, par3, par4);
        if (md == 1 && !par1World.isRemote && (te = par1World.getTileEntity(par2, par3, par4)) != null && te instanceof TileJarBrain) {
            int var2;
            for (int xp = ((TileJarBrain)te).xp; xp > 0; xp -= var2) {
                var2 = EntityXPOrb.getXPSplit((int)xp);
                par1World.spawnEntityInWorld((Entity)new EntityXPOrb(par1World, (double)par2, (double)par3, (double)par4, var2));
            }
        }
        super.breakBlock(par1World, par2, par3, par4, par5, par6);
    }

    public int damageDropped(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return meta != 15;
    }

    public void onBlockPlacedBy(World world, int par2, int par3, int par4, EntityLivingBase ent, ItemStack stack) {
        int l = MathHelper.floor_double((double)((double)(ent.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntity tile = world.getTileEntity(par2, par3, par4);
        if (tile instanceof TileJarFillable) {
            if (l == 0) {
                ((TileJarFillable)tile).facing = 2;
            }
            if (l == 1) {
                ((TileJarFillable)tile).facing = 5;
            }
            if (l == 2) {
                ((TileJarFillable)tile).facing = 3;
            }
            if (l == 3) {
                ((TileJarFillable)tile).facing = 4;
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float what, float these, float are) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileJarBrain) {
            ((TileJarBrain)te).eatDelay = 40;
            if (!world.isRemote) {
                int var6 = world.rand.nextInt(Math.min(((TileJarBrain)te).xp + 1, 64));
                if (var6 > 0) {
                    int var2;
                    ((TileJarBrain)te).xp -= var6;
                    for (int xp = var6; xp > 0; xp -= var2) {
                        var2 = EntityXPOrb.getXPSplit((int)xp);
                        world.spawnEntityInWorld((Entity)new EntityXPOrb(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, var2));
                    }
                    world.markBlockForUpdate(x, y, z);
                    te.markDirty();
                }
            } else {
                world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "thaumcraft:jar", 0.2f, 1.0f, false);
            }
        }
        if (te != null && te instanceof TileJarFillable && player.isSneaking() && ((TileJarFillable)te).aspectFilter != null && side == ((TileJarFillable)te).facing) {
            ((TileJarFillable)te).aspectFilter = null;
            if (world.isRemote) {
                world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "thaumcraft:page", 1.0f, 1.0f, false);
            } else {
                ForgeDirection fd = ForgeDirection.getOrientation((int)side);
                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)((float)x + 0.5f + (float)fd.offsetX / 3.0f), (double)((float)y + 0.5f), (double)((float)z + 0.5f + (float)fd.offsetZ / 3.0f), new ItemStack(ConfigItems.itemResource, 1, 13)));
            }
        } else if (te != null && te instanceof TileJarFillable && player.isSneaking() && player.getHeldItem() == null) {
            ((TileJarFillable)te).amount = 0;
            if (((TileJarFillable)te).aspectFilter == null) {
                ((TileJarFillable)te).aspect = null;
            }
            if (world.isRemote) {
                world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "thaumcraft:jar", 0.4f, 1.0f, false);
                world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "game.neutral.swim", 0.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f, false);
            }
        } else if (te != null && te instanceof TileJarFillable && player.getHeldItem() != null && ((TileJarFillable)te).aspectFilter == null && player.getHeldItem().getItem() == ConfigItems.itemResource && player.getHeldItem().getItemDamage() == 13) {
            if (((TileJarFillable)te).amount == 0 && ((IEssentiaContainerItem)player.getHeldItem().getItem()).getAspects(player.getHeldItem()) == null) {
                return true;
            }
            if (((TileJarFillable)te).amount == 0 && ((IEssentiaContainerItem)player.getHeldItem().getItem()).getAspects(player.getHeldItem()) != null) {
                ((TileJarFillable)te).aspect = ((IEssentiaContainerItem)player.getHeldItem().getItem()).getAspects(player.getHeldItem()).getAspects()[0];
            }
            --player.getHeldItem().stackSize;
            this.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, null);
            ((TileJarFillable)te).aspectFilter = ((TileJarFillable)te).aspect;
            if (world.isRemote) {
                world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "thaumcraft:jar", 0.4f, 1.0f, false);
            }
        }
        return true;
    }

    public TileEntity createNewTileEntity(World var1, int md) {
        return null;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        this.setBlockBounds(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.75f, 0.8125f);
        super.setBlockBoundsBasedOnState(world, i, j, k);
    }

    public void addCollisionBoxesToList(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
    }

    public float getEnchantPowerBonus(World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileJarBrain) {
            return 2.0f;
        }
        return super.getEnchantPowerBonus(world, x, y, z);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 2) {
            return 11;
        }
        return super.getLightValue(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile != null && tile instanceof TileJarBrain && ((TileJarBrain)tile).xp >= ((TileJarBrain)tile).xpMax) {
            double xx = (double)x + 0.3 + (double)(rand.nextFloat() * 0.4f);
            double yy = (double)y + 0.9;
            double zz = (double)z + 0.3 + (double)(rand.nextFloat() * 0.4f);
            EntitySpellParticleFX var21 = new EntitySpellParticleFX(world, xx, yy, zz, 0.0, 0.0, 0.0);
            var21.setAlphaF(0.5f);
            var21.setRBGColorF(0.0f, 0.4f + world.rand.nextFloat() * 0.1f, 0.3f + world.rand.nextFloat() * 0.2f);
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)var21);
        }
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int rs) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile != null && tile instanceof TileJarBrain) {
            float r = (float)((TileJarBrain)tile).xp / (float)((TileJarBrain)tile).xpMax;
            return MathHelper.floor_float((float)(r * 14.0f)) + (((TileJarBrain)tile).xp > 0 ? 1 : 0);
        }
        if (tile != null && tile instanceof TileJarFillable) {
            float r = (float)((TileJarFillable)tile).amount / (float)((TileJarFillable)tile).maxAmount;
            return MathHelper.floor_float((float)(r * 14.0f)) + (((TileJarFillable)tile).amount > 0 ? 1 : 0);
        }
        return super.getComparatorInputOverride(world, x, y, z, rs);
    }
}

