/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileArcaneLamp;
import thaumcraft.common.tiles.TileArcaneLampFertility;
import thaumcraft.common.tiles.TileArcaneLampGrowth;
import thaumcraft.common.tiles.TileBrainbox;
import thaumcraft.common.tiles.TileVisRelay;

public class BlockMetalDeviceItem
extends ItemBlock {
    public BlockMetalDeviceItem(Block par1) {
        super(par1);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public int getMetadata(int par1) {
        return par1;
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return super.getUnlocalizedName() + "." + par1ItemStack.getItemDamage();
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (stack.getItemDamage() == 0 || stack.getItemDamage() == 1 || stack.getItemDamage() == 2 || stack.getItemDamage() == 3 || stack.getItemDamage() == 5 || stack.getItemDamage() == 6 || stack.getItemDamage() == 7 || stack.getItemDamage() == 8 || stack.getItemDamage() == 9 || stack.getItemDamage() == 13 || stack.getItemDamage() == 14) {
            return super.onItemUse(stack, player, world, x, y, z, side, par8, par9, par10);
        }
        Block bi = world.getBlock(x, y, z);
        int md = world.getBlockMetadata(x, y, z);
        if (stack.getItemDamage() == 12) {
            if (bi == ConfigBlocks.blockMetalDevice && (md == 10 || md == 11)) {
                return super.onItemUse(stack, player, world, x, y, z, side, par8, par9, par10);
            }
            return false;
        }
        if (bi == ConfigBlocks.blockMetalDevice && md == 0) {
            if (side == 0 || side == 1) {
                return false;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (stack.stackSize == 0) {
            return false;
        }
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        if (y == 255 && this.field_150939_a.getMaterial().isSolid()) {
            return false;
        }
        Block var11 = world.getBlock(x, y, z);
        if (world.isAirBlock(x, y, z) || var11.isReplaceable((IBlockAccess)world, x, y, z) || var11 == Blocks.vine || var11 == Blocks.tallgrass || var11 == Blocks.deadbush || var11 == Blocks.snow_layer) {
            for (int a = 2; a < 6; ++a) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)a);
                int xx = x + dir.offsetX;
                int yy = y + dir.offsetY;
                int zz = z + dir.offsetZ;
                Block bid = world.getBlock(xx, yy, zz);
                int meta = world.getBlockMetadata(xx, yy, zz);
                if (bid != ConfigBlocks.blockMetalDevice || meta != 0 || !this.placeBlockAt(stack, player, world, x, y, z, side, par8, par9, par10, stack.getItemDamage())) continue;
                world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_150939_a.stepSound.getStepResourcePath(), (this.field_150939_a.stepSound.getVolume() + 1.0f) / 2.0f, this.field_150939_a.stepSound.getPitch() * 0.8f);
                --stack.stackSize;
                world.setBlock(x, y, z, ConfigBlocks.blockMetalDevice, dir.getOpposite().ordinal() - 1, 3);
                return true;
            }
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        TileVisRelay tile;
        boolean ret = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (metadata == 7) {
            TileArcaneLamp tile2 = (TileArcaneLamp)world.getTileEntity(x, y, z);
            if (tile2 != null && tile2 instanceof TileArcaneLamp) {
                tile2.facing = ForgeDirection.getOrientation((int)side).getOpposite();
                world.markBlockForUpdate(x, y, x);
            }
        } else if (metadata == 8) {
            TileArcaneLampGrowth tile3 = (TileArcaneLampGrowth)world.getTileEntity(x, y, z);
            if (tile3 != null && tile3 instanceof TileArcaneLampGrowth) {
                tile3.facing = ForgeDirection.getOrientation((int)side).getOpposite();
                world.markBlockForUpdate(x, y, x);
            }
        } else if (metadata == 12) {
            TileBrainbox tile4 = (TileBrainbox)world.getTileEntity(x, y, z);
            if (tile4 != null && tile4 instanceof TileBrainbox) {
                tile4.facing = ForgeDirection.getOrientation((int)side).getOpposite();
                world.markBlockForUpdate(x, y, x);
            }
        } else if (metadata == 13) {
            TileArcaneLampFertility tile5 = (TileArcaneLampFertility)world.getTileEntity(x, y, z);
            if (tile5 != null && tile5 instanceof TileArcaneLampFertility) {
                tile5.facing = ForgeDirection.getOrientation((int)side).getOpposite();
                world.markBlockForUpdate(x, y, x);
            }
        } else if (metadata == 14 && (tile = (TileVisRelay)world.getTileEntity(x, y, z)) != null && tile instanceof TileVisRelay) {
            tile.orientation = (short)side;
            world.markBlockForUpdate(x, y, x);
        }
        return ret;
    }
}

