/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileMirror;
import thaumcraft.common.tiles.TileMirrorEssentia;

public class BlockMirrorItem
extends ItemBlock {
    public IIcon[] icon = new IIcon[5];

    public BlockMirrorItem(Block par1) {
        super(par1);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.icon[0] = par1IconRegister.registerIcon("thaumcraft:mirrorframe");
        this.icon[1] = par1IconRegister.registerIcon("thaumcraft:mirrorpane");
        this.icon[2] = par1IconRegister.registerIcon("thaumcraft:mirrorpanetrans");
        this.icon[3] = par1IconRegister.registerIcon("thaumcraft:mirrorpaneopen");
        this.icon[4] = par1IconRegister.registerIcon("thaumcraft:mirrorframe2");
    }

    public IIcon getIconFromDamageForRenderPass(int par1, int par2) {
        if (par2 == 0) {
            return this.icon[par1 <= 1 ? 0 : 4];
        }
        return this.icon[par2 + par1 % 2 * 2];
    }

    public boolean getShareTag() {
        return true;
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        int d = par1ItemStack.getItemDamage() < 6 ? 0 : 6;
        return super.getUnlocalizedName() + "." + d;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.getBlock(x, y, z) == ConfigBlocks.blockMirror) {
            if (world.isRemote) {
                player.swingItem();
                return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
            }
            if (stack.getItemDamage() <= 5) {
                TileEntity tm = world.getTileEntity(x, y, z);
                if (tm != null && tm instanceof TileMirror && !((TileMirror)tm).isLinkValid()) {
                    ItemStack st = stack.copy();
                    st.stackSize = 1;
                    st.setItemDamage(1);
                    st.setTagInfo("linkX", (NBTBase)new NBTTagInt(tm.xCoord));
                    st.setTagInfo("linkY", (NBTBase)new NBTTagInt(tm.yCoord));
                    st.setTagInfo("linkZ", (NBTBase)new NBTTagInt(tm.zCoord));
                    st.setTagInfo("linkDim", (NBTBase)new NBTTagInt(world.provider.dimensionId));
                    st.setTagInfo("dimname", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)world.provider.dimensionId).getDimensionName()));
                    world.playSoundEffect((double)x, (double)y, (double)z, "thaumcraft:jar", 1.0f, 2.0f);
                    if (!player.inventory.addItemStackToInventory(st) && !world.isRemote) {
                        world.spawnEntityInWorld((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, st));
                    }
                    if (!player.capabilities.isCreativeMode) {
                        --stack.stackSize;
                    }
                    player.inventoryContainer.detectAndSendChanges();
                } else if (tm != null && tm instanceof TileMirror) {
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation("\u00a75\u00a7oThat mirror is already linked to a valid destination.", new Object[0]));
                }
            } else {
                TileEntity tm = world.getTileEntity(x, y, z);
                if (tm != null && tm instanceof TileMirrorEssentia && !((TileMirrorEssentia)tm).isLinkValid()) {
                    ItemStack st = stack.copy();
                    st.stackSize = 1;
                    st.setItemDamage(7);
                    st.setTagInfo("linkX", (NBTBase)new NBTTagInt(tm.xCoord));
                    st.setTagInfo("linkY", (NBTBase)new NBTTagInt(tm.yCoord));
                    st.setTagInfo("linkZ", (NBTBase)new NBTTagInt(tm.zCoord));
                    st.setTagInfo("linkDim", (NBTBase)new NBTTagInt(world.provider.dimensionId));
                    st.setTagInfo("dimname", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)world.provider.dimensionId).getDimensionName()));
                    world.playSoundEffect((double)x, (double)y, (double)z, "thaumcraft:jar", 1.0f, 2.0f);
                    if (!player.inventory.addItemStackToInventory(st) && !world.isRemote) {
                        world.spawnEntityInWorld((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, st));
                    }
                    if (!player.capabilities.isCreativeMode) {
                        --stack.stackSize;
                    }
                    player.inventoryContainer.detectAndSendChanges();
                } else if (tm != null && tm instanceof TileMirrorEssentia) {
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation("\u00a75\u00a7oThat mirror is already linked to a valid destination.", new Object[0]));
                }
            }
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean ret = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (ret && !world.isRemote) {
            if (metadata <= 5) {
                TileEntity te = world.getTileEntity(x, y, z);
                if (te != null && te instanceof TileMirror && stack.hasTagCompound()) {
                    ((TileMirror)te).linkX = stack.stackTagCompound.getInteger("linkX");
                    ((TileMirror)te).linkY = stack.stackTagCompound.getInteger("linkY");
                    ((TileMirror)te).linkZ = stack.stackTagCompound.getInteger("linkZ");
                    ((TileMirror)te).linkDim = stack.stackTagCompound.getInteger("linkDim");
                    ((TileMirror)te).restoreLink();
                }
            } else {
                TileEntity te = world.getTileEntity(x, y, z);
                if (te != null && te instanceof TileMirrorEssentia && stack.hasTagCompound()) {
                    ((TileMirrorEssentia)te).linkX = stack.stackTagCompound.getInteger("linkX");
                    ((TileMirrorEssentia)te).linkY = stack.stackTagCompound.getInteger("linkY");
                    ((TileMirrorEssentia)te).linkZ = stack.stackTagCompound.getInteger("linkZ");
                    ((TileMirrorEssentia)te).linkDim = stack.stackTagCompound.getInteger("linkDim");
                    ((TileMirrorEssentia)te).restoreLink();
                }
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 2;
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.uncommon;
    }

    public int getMetadata(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack item, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (item.hasTagCompound()) {
            int lx = item.stackTagCompound.getInteger("linkX");
            int ly = item.stackTagCompound.getInteger("linkY");
            int lz = item.stackTagCompound.getInteger("linkZ");
            int ldim = item.stackTagCompound.getInteger("linkDim");
            String dimname = item.stackTagCompound.getString("dimname");
            list.add("Linked to " + lx + "," + ly + "," + lz + " in " + dimname);
        }
    }
}

