/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.items.baubles.ItemAmuletVis;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileAlchemyFurnace;
import thaumcraft.common.tiles.TileFluxScrubber;
import thaumcraft.common.tiles.TileFocalManipulator;
import thaumcraft.common.tiles.TileInfusionMatrix;
import thaumcraft.common.tiles.TileInfusionPillar;
import thaumcraft.common.tiles.TileNodeConverter;
import thaumcraft.common.tiles.TileNodeStabilizer;
import thaumcraft.common.tiles.TilePedestal;
import thaumcraft.common.tiles.TileSpa;
import thaumcraft.common.tiles.TileWandPedestal;

public class BlockStoneDevice
extends BlockContainer {
    public IIcon[] iconFurnace = new IIcon[5];
    public IIcon[] iconPedestal = new IIcon[2];
    public IIcon[] iconWandPedestal = new IIcon[2];
    public IIcon[] iconWandPedestalFocus = new IIcon[3];
    public IIcon[] iconSpa = new IIcon[2];

    public BlockStoneDevice() {
        super(Material.rock);
        this.setHardness(3.0f);
        this.setResistance(25.0f);
        this.setStepSound(Block.soundTypeStone);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister ir) {
        this.iconPedestal[0] = ir.registerIcon("thaumcraft:pedestal_side");
        this.iconPedestal[1] = ir.registerIcon("thaumcraft:pedestal_top");
        this.iconWandPedestal[0] = ir.registerIcon("thaumcraft:wandpedestal_side");
        this.iconWandPedestal[1] = ir.registerIcon("thaumcraft:wandpedestal_top");
        this.iconWandPedestalFocus[0] = ir.registerIcon("thaumcraft:wandpedestal_focus_side");
        this.iconWandPedestalFocus[1] = ir.registerIcon("thaumcraft:wandpedestal_focus_top");
        this.iconWandPedestalFocus[2] = ir.registerIcon("thaumcraft:wandpedestal_focus_bot");
        this.iconFurnace[0] = ir.registerIcon("thaumcraft:al_furnace_side");
        this.iconFurnace[1] = ir.registerIcon("thaumcraft:al_furnace_top");
        this.iconFurnace[2] = ir.registerIcon("thaumcraft:al_furnace_front_off");
        this.iconFurnace[3] = ir.registerIcon("thaumcraft:al_furnace_front_on");
        this.iconFurnace[4] = ir.registerIcon("thaumcraft:al_furnace_top_filled");
        this.iconSpa[0] = ir.registerIcon("thaumcraft:spa_side");
        this.iconSpa[1] = ir.registerIcon("thaumcraft:spa_top");
    }

    public int getRenderType() {
        return ConfigBlocks.blockStoneDeviceRI;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public IIcon getIcon(int side, int md) {
        if (md == 0) {
            if (side == 1) {
                return this.iconFurnace[1];
            }
            if (side > 1) {
                return this.iconFurnace[2];
            }
        } else if (md == 1) {
            if (side <= 1) {
                return this.iconPedestal[1];
            }
            if (side > 1) {
                return this.iconPedestal[0];
            }
        } else if (md == 5) {
            if (side == 0) {
                return this.iconPedestal[1];
            }
            if (side == 1) {
                return this.iconWandPedestal[1];
            }
            if (side > 1) {
                return this.iconWandPedestal[0];
            }
        } else if (md == 8) {
            if (side == 0) {
                return this.iconWandPedestalFocus[2];
            }
            if (side == 1) {
                return this.iconWandPedestalFocus[1];
            }
            if (side > 1) {
                return this.iconWandPedestalFocus[0];
            }
        } else if (md == 12) {
            if (side == 0) {
                return this.iconPedestal[1];
            }
            if (side == 1) {
                return this.iconSpa[1];
            }
            if (side > 1) {
                return this.iconSpa[0];
            }
        }
        return this.iconPedestal[1];
    }

    public IIcon getIcon(IBlockAccess iblockaccess, int i, int j, int k, int side) {
        int metadata = iblockaccess.getBlockMetadata(i, j, k);
        if (metadata == 0) {
            TileEntity te = iblockaccess.getTileEntity(i, j, k);
            if (side == 1) {
                if (te != null && te instanceof TileAlchemyFurnace && ((TileAlchemyFurnace)te).vis > 0) {
                    return this.iconFurnace[4];
                }
                return this.iconFurnace[1];
            }
            if (side > 1) {
                if (te != null && te instanceof TileAlchemyFurnace && ((TileAlchemyFurnace)te).isBurning()) {
                    return this.iconFurnace[3];
                }
                return this.iconFurnace[2];
            }
        } else if (metadata == 1 || metadata == 5 || metadata == 8 || metadata == 12) {
            return super.getIcon(iblockaccess, i, j, k, side);
        }
        return this.iconFurnace[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 5));
        par3List.add(new ItemStack(par1, 1, 8));
        par3List.add(new ItemStack(par1, 1, 9));
        par3List.add(new ItemStack(par1, 1, 10));
        par3List.add(new ItemStack(par1, 1, 11));
        par3List.add(new ItemStack(par1, 1, 12));
        par3List.add(new ItemStack(par1, 1, 13));
        par3List.add(new ItemStack(par1, 1, 14));
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int i, int j, int k, Random r) {
        TileEntity te = w.getTileEntity(i, j, k);
        if (te != null && te instanceof TileAlchemyFurnace && ((TileAlchemyFurnace)te).isBurning()) {
            float f = (float)i + 0.5f;
            float f1 = (float)j + 0.2f + r.nextFloat() * 5.0f / 16.0f;
            float f2 = (float)k + 0.5f;
            float f3 = 0.52f;
            float f4 = r.nextFloat() * 0.5f - 0.25f;
            w.spawnParticle("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            w.spawnParticle("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            w.spawnParticle("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            w.spawnParticle("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            w.spawnParticle("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            w.spawnParticle("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            w.spawnParticle("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            w.spawnParticle("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te != null && te instanceof TileAlchemyFurnace && ((TileAlchemyFurnace)te).isBurning()) {
                return 12;
            }
        } else if (meta == 2) {
            return 10;
        }
        return super.getLightValue(world, x, y, z);
    }

    public int damageDropped(int metadata) {
        return metadata == 3 ? 7 : (metadata == 4 ? 6 : metadata);
    }

    public Item getItemDropped(int metadata, Random par2Random, int par3) {
        return metadata == 3 || metadata == 4 ? Item.getItemFromBlock((Block)ConfigBlocks.blockCosmeticSolid) : super.getItemDropped(metadata, par2Random, par3);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0) {
            return new TileAlchemyFurnace();
        }
        if (metadata == 1) {
            return new TilePedestal();
        }
        if (metadata == 2) {
            return new TileInfusionMatrix();
        }
        if (metadata == 3) {
            return new TileInfusionPillar();
        }
        if (metadata == 5) {
            return new TileWandPedestal();
        }
        if (metadata == 9 || metadata == 10) {
            return new TileNodeStabilizer();
        }
        if (metadata == 11) {
            return new TileNodeConverter();
        }
        if (metadata == 12) {
            return new TileSpa();
        }
        if (metadata == 13) {
            return new TileFocalManipulator();
        }
        if (metadata == 14) {
            return new TileFluxScrubber();
        }
        return super.createTileEntity(world, metadata);
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int rs) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && (te instanceof TilePedestal || te instanceof TileAlchemyFurnace)) {
            return Container.calcRedstoneFromInventory((IInventory)((IInventory)te));
        }
        if (te != null && te instanceof TileWandPedestal && ((TileWandPedestal)te).getAspects() != null && ((TileWandPedestal)te).getStackInSlot(0) != null && ((TileWandPedestal)te).getStackInSlot(0).getItem() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)((TileWandPedestal)te).getStackInSlot(0).getItem();
            float r = (float)wand.getAllVis(((TileWandPedestal)te).getStackInSlot(0)).visSize() / ((float)wand.getMaxVis(((TileWandPedestal)te).getStackInSlot(0)) * 6.0f);
            return MathHelper.floor_float((float)(r * 14.0f)) + 1;
        }
        return 0;
    }

    public TileEntity createNewTileEntity(World var1, int md) {
        return null;
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        InventoryUtils.dropItems(par1World, par2, par3, par4);
        TileEntity tileEntity = par1World.getTileEntity(par2, par3, par4);
        if (tileEntity != null && tileEntity instanceof TileInfusionMatrix && ((TileInfusionMatrix)tileEntity).crafting) {
            par1World.createExplosion(null, (double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, 2.0f, true);
        }
        super.breakBlock(par1World, par2, par3, par4, par5, par6);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block par5) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileAlchemyFurnace) {
            ((TileAlchemyFurnace)te).getBellows();
        } else if (te != null && te instanceof TileNodeConverter) {
            ((TileNodeConverter)te).checkStatus();
        } else {
            int metadata = world.getBlockMetadata(x, y, z);
            if (metadata == 1) {
                if (!world.isAirBlock(x, y + 1, z)) {
                    InventoryUtils.dropItems(world, x, y, z);
                }
            } else if (metadata == 5) {
                if (!(world.isAirBlock(x, y + 1, z) || world.getBlock(x, y + 1, z) == this && world.getBlockMetadata(x, y + 1, z) == 8)) {
                    InventoryUtils.dropItems(world, x, y, z);
                }
            } else if (metadata == 3) {
                if (world.getBlock(x, y + 1, z) != this || world.getBlockMetadata(x, y + 1, z) != 4) {
                    this.dropBlockAsItem(world, x, y, z, metadata, 0);
                    world.setBlock(x, y, z, Blocks.air, 0, 3);
                }
            } else if (metadata == 4 && (world.getBlock(x, y - 1, z) != this || world.getBlockMetadata(x, y - 1, z) != 3)) {
                this.dropBlockAsItem(world, x, y, z, metadata, 0);
                world.setBlock(x, y, z, Blocks.air, 0, 3);
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        TileThaumcraft ped;
        if (world.isRemote) {
            return true;
        }
        int metadata = world.getBlockMetadata(x, y, z);
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (metadata == 0 && tileEntity instanceof TileAlchemyFurnace && !player.isSneaking()) {
            player.openGui((Object)Thaumcraft.instance, 9, world, x, y, z);
            return true;
        }
        if (metadata == 1 && tileEntity instanceof TilePedestal) {
            ped = (TilePedestal)tileEntity;
            if (((TilePedestal)ped).getStackInSlot(0) != null) {
                InventoryUtils.dropItemsAtEntity(world, x, y, z, (Entity)player);
                world.playSoundEffect((double)x, (double)y, (double)z, "random.pop", 0.2f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 1.5f);
                return true;
            }
            if (player.getCurrentEquippedItem() != null) {
                ItemStack i = player.getCurrentEquippedItem().copy();
                i.stackSize = 1;
                ((TilePedestal)ped).setInventorySlotContents(0, i);
                --player.getCurrentEquippedItem().stackSize;
                if (player.getCurrentEquippedItem().stackSize == 0) {
                    player.setCurrentItemOrArmor(0, null);
                }
                player.inventory.markDirty();
                world.playSoundEffect((double)x, (double)y, (double)z, "random.pop", 0.2f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 1.6f);
                return true;
            }
        }
        if (metadata == 8) {
            metadata = world.getBlockMetadata(x, --y, z);
            tileEntity = world.getTileEntity(x, y, z);
        }
        if (metadata == 5 && tileEntity instanceof TileWandPedestal) {
            if (player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().isItemEqual(new ItemStack((Block)this, 1, 8))) {
                return false;
            }
            ped = (TileWandPedestal)tileEntity;
            if (((TileWandPedestal)ped).getStackInSlot(0) != null) {
                InventoryUtils.dropItemsAtEntity(world, x, y, z, (Entity)player);
                world.markBlockForUpdate(x, y, z);
                ped.markDirty();
                world.playSoundEffect((double)x, (double)y, (double)z, "random.pop", 0.2f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 1.5f);
                return true;
            }
            if (player.getCurrentEquippedItem() != null && (player.getCurrentEquippedItem().getItem() instanceof ItemWandCasting || player.getCurrentEquippedItem().getItem() instanceof ItemAmuletVis)) {
                ItemStack i = player.getCurrentEquippedItem().copy();
                i.stackSize = 1;
                ((TileWandPedestal)ped).setInventorySlotContents(0, i);
                --player.getCurrentEquippedItem().stackSize;
                if (player.getCurrentEquippedItem().stackSize == 0) {
                    player.setCurrentItemOrArmor(0, null);
                }
                player.inventory.markDirty();
                world.markBlockForUpdate(x, y, z);
                ped.markDirty();
                world.playSoundEffect((double)x, (double)y, (double)z, "random.pop", 0.2f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 1.6f);
                return true;
            }
        }
        if (metadata == 12 && tileEntity instanceof TileSpa && !player.isSneaking()) {
            FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.inventory.getCurrentItem());
            if (fs != null) {
                int volume = fs.amount;
                TileSpa tile = (TileSpa)tileEntity;
                if (tile.tank.getFluidAmount() < tile.tank.getCapacity() && (tile.tank.getFluid() == null || tile.tank.getFluid().isFluidEqual(fs))) {
                    FluidContainerRegistry.FluidContainerData[] fcs;
                    tile.fill(ForgeDirection.UNKNOWN, FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.inventory.getCurrentItem()), true);
                    ItemStack emptyContainer = null;
                    for (FluidContainerRegistry.FluidContainerData fcd : fcs = FluidContainerRegistry.getRegisteredFluidContainerData()) {
                        if (!fcd.filledContainer.isItemEqual(player.inventory.getCurrentItem())) continue;
                        emptyContainer = fcd.emptyContainer.copy();
                    }
                    player.inventory.decrStackSize(player.inventory.currentItem, 1);
                    if (emptyContainer != null && !player.inventory.addItemStackToInventory(emptyContainer)) {
                        player.dropPlayerItemWithRandomChoice(emptyContainer, false);
                    }
                    player.inventoryContainer.detectAndSendChanges();
                    tile.markDirty();
                    world.markBlockForUpdate(x, y, z);
                    world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "game.neutral.swim", 0.33f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
                }
            } else {
                player.openGui((Object)Thaumcraft.instance, 19, world, x, y, z);
            }
            return true;
        }
        if (metadata == 13 && tileEntity instanceof TileFocalManipulator && !player.isSneaking()) {
            if (ThaumcraftApiHelper.isResearchComplete(player.getCommandSenderName(), "FOCALMANIPULATION")) {
                player.openGui((Object)Thaumcraft.instance, 20, world, x, y, z);
            } else if (!world.isRemote) {
                player.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + StatCollector.translateToLocal((String)"tc.researchmissing")));
            }
            return true;
        }
        return super.onBlockActivated(world, x, y, z, player, side, par7, par8, par9);
    }

    public void addCollisionBoxesToList(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        int metadata = world.getBlockMetadata(i, j, k);
        if (metadata == 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            this.setBlockBounds(0.25f, 0.5f, 0.25f, 0.75f, 1.0f, 0.75f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            this.setBlockBounds(0.125f, 0.25f, 0.125f, 0.875f, 0.5f, 0.875f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        int metadata = world.getBlockMetadata(i, j, k);
        if (metadata == 1) {
            this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.99f, 0.75f);
        } else if (metadata == 5) {
            this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
        } else if (metadata == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else if (metadata == 4) {
            this.setBlockBounds(0.0f, -1.0f, 0.0f, 1.0f, -0.5f, 1.0f);
        } else if (metadata == 8) {
            this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.4375f, 0.9375f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        super.setBlockBoundsBasedOnState(world, i, j, k);
    }

    public boolean onBlockEventReceived(World par1World, int par2, int par3, int par4, int par5, int par6) {
        if (par5 == 1) {
            if (par1World.isRemote) {
                Thaumcraft.proxy.blockSparkle(par1World, par2, par3, par4, 11960575, 2);
                par1World.playAuxSFX(2001, par2, par3, par4, Block.getIdFromBlock((Block)Blocks.stonebrick) + 0);
            }
            return true;
        }
        return super.onBlockEventReceived(par1World, par2, par3, par4, par5, par6);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 11 && side == ForgeDirection.UP) {
            return true;
        }
        if (meta == 12) {
            return true;
        }
        return super.isSideSolid(world, x, y, z, side);
    }
}

