/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;

public class ConfigAspects {
    private static final int[] ALLMETA = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};

    public static void init() {
        ConfigAspects.registerItemAspects();
        ConfigAspects.registerEntityAspects();
    }

    private static void registerEntityAspects() {
        ThaumcraftApi.registerEntityTag("Zombie", new AspectList().add(Aspect.UNDEAD, 2).add(Aspect.MAN, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Giant", new AspectList().add(Aspect.UNDEAD, 4).add(Aspect.MAN, 3).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Skeleton", new AspectList().add(Aspect.UNDEAD, 3).add(Aspect.MAN, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Skeleton", new AspectList().add(Aspect.UNDEAD, 4).add(Aspect.MAN, 1).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT("SkeletonType", (byte)1));
        ThaumcraftApi.registerEntityTag("Creeper", new AspectList().add(Aspect.PLANT, 2).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Creeper", new AspectList().add(Aspect.PLANT, 3).add(Aspect.FIRE, 3).add(Aspect.ENERGY, 3), new ThaumcraftApi.EntityTagsNBT("powered", (byte)1));
        ThaumcraftApi.registerEntityTag("EntityHorse", new AspectList().add(Aspect.BEAST, 4).add(Aspect.EARTH, 1).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Pig", new AspectList().add(Aspect.BEAST, 2).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("XPOrb", new AspectList().add(Aspect.MIND, 5), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Sheep", new AspectList().add(Aspect.BEAST, 2).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Cow", new AspectList().add(Aspect.BEAST, 3).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MushroomCow", new AspectList().add(Aspect.BEAST, 3).add(Aspect.PLANT, 1).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("SnowMan", new AspectList().add(Aspect.COLD, 3).add(Aspect.WATER, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Ozelot", new AspectList().add(Aspect.BEAST, 3).add(Aspect.ENTROPY, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Chicken", new AspectList().add(Aspect.BEAST, 2).add(Aspect.FLIGHT, 2).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Squid", new AspectList().add(Aspect.BEAST, 2).add(Aspect.WATER, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Wolf", new AspectList().add(Aspect.BEAST, 3).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Bat", new AspectList().add(Aspect.BEAST, 1).add(Aspect.FLIGHT, 1).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Boat", new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.WATER, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Spider", new AspectList().add(Aspect.BEAST, 3).add(Aspect.ENTROPY, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Slime", new AspectList().add(Aspect.SLIME, 2).add(Aspect.WATER, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Ghast", new AspectList().add(Aspect.UNDEAD, 3).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("PigZombie", new AspectList().add(Aspect.UNDEAD, 4).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Enderman", new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.TRAVEL, 2).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("CaveSpider", new AspectList().add(Aspect.BEAST, 2).add(Aspect.POISON, 2).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Silverfish", new AspectList().add(Aspect.BEAST, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Blaze", new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.FIRE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("LavaSlime", new AspectList().add(Aspect.SLIME, 3).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("EnderDragon", new AspectList().add(Aspect.ELDRITCH, 20).add(Aspect.BEAST, 20).add(Aspect.ENTROPY, 20), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("WitherBoss", new AspectList().add(Aspect.UNDEAD, 20).add(Aspect.ENTROPY, 20).add(Aspect.FIRE, 15), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Witch", new AspectList().add(Aspect.MAN, 3).add(Aspect.MAGIC, 2).add(Aspect.FIRE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Villager", new AspectList().add(Aspect.MAN, 3).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("VillagerGolem", new AspectList().add(Aspect.METAL, 4).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartRideable", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartChest", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.VOID, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartFurnace", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.FIRE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartTNT", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.FIRE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartHopper", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.EXCHANGE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartSpawner", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.MAGIC, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("EnderCrystal", new AspectList().add(Aspect.ELDRITCH, 3).add(Aspect.MAGIC, 3).add(Aspect.HEAL, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("ItemFrame", new AspectList().add(Aspect.SENSES, 3).add(Aspect.CLOTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Painting", new AspectList().add(Aspect.SENSES, 5).add(Aspect.CLOTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.PrimalOrb", new AspectList().add(Aspect.AIR, 5).add(Aspect.ENTROPY, 10).add(Aspect.MAGIC, 10).add(Aspect.ENERGY, 10), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.Firebat", new AspectList().add(Aspect.BEAST, 2).add(Aspect.FLIGHT, 1).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.Pech", new AspectList().add(Aspect.MAN, 2).add(Aspect.MAGIC, 2).add(Aspect.EXCHANGE, 2).add(Aspect.GREED, 2), new ThaumcraftApi.EntityTagsNBT("PechType", (byte)0));
        ThaumcraftApi.registerEntityTag("Thaumcraft.Pech", new AspectList().add(Aspect.MAN, 2).add(Aspect.MAGIC, 2).add(Aspect.EXCHANGE, 2).add(Aspect.WEAPON, 2), new ThaumcraftApi.EntityTagsNBT("PechType", (byte)1));
        ThaumcraftApi.registerEntityTag("Thaumcraft.Pech", new AspectList().add(Aspect.MAN, 2).add(Aspect.MAGIC, 4).add(Aspect.EXCHANGE, 2), new ThaumcraftApi.EntityTagsNBT("PechType", (byte)2));
        ThaumcraftApi.registerEntityTag("Thaumcraft.ThaumSlime", new AspectList().add(Aspect.SLIME, 2).add(Aspect.MAGIC, 1).add(Aspect.WATER, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.BrainyZombie", new AspectList().add(Aspect.UNDEAD, 3).add(Aspect.MAN, 1).add(Aspect.MIND, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.GiantBrainyZombie", new AspectList().add(Aspect.UNDEAD, 4).add(Aspect.MAN, 2).add(Aspect.MIND, 1).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.Taintacle", new AspectList().add(Aspect.TAINT, 3).add(Aspect.WATER, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintacleTiny", new AspectList().add(Aspect.TAINT, 1).add(Aspect.WATER, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintSpider", new AspectList().add(Aspect.TAINT, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintSpore", new AspectList().add(Aspect.TAINT, 2).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintSwarmer", new AspectList().add(Aspect.TAINT, 2).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintSwarm", new AspectList().add(Aspect.TAINT, 3).add(Aspect.AIR, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedPig", new AspectList().add(Aspect.TAINT, 2).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedSheep", new AspectList().add(Aspect.TAINT, 2).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedCow", new AspectList().add(Aspect.TAINT, 3).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedChicken", new AspectList().add(Aspect.TAINT, 2).add(Aspect.FLIGHT, 2).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedVillager", new AspectList().add(Aspect.TAINT, 3).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedCreeper", new AspectList().add(Aspect.TAINT, 2).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.MindSpider", new AspectList().add(Aspect.TAINT, 2).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.EldritchGuardian", new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.DEATH, 2).add(Aspect.UNDEAD, 4), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.EldritchOrb", new AspectList().add(Aspect.ELDRITCH, 2).add(Aspect.DEATH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.CultistKnight", new AspectList().add(Aspect.ELDRITCH, 1).add(Aspect.MAN, 2).add(Aspect.ENTROPY, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.CultistCleric", new AspectList().add(Aspect.ELDRITCH, 1).add(Aspect.MAN, 2).add(Aspect.ENTROPY, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        for (Aspect tag : Aspect.aspects.values()) {
            ThaumcraftApi.registerEntityTag("Thaumcraft.Wisp", new AspectList().add(tag, 2).add(Aspect.MAGIC, 1).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT("Type", tag.getTag()));
        }
        ThaumcraftApi.registerEntityTag("Thaumcraft.Golem", new AspectList().add(Aspect.AIR, 2).add(Aspect.EARTH, 2).add(Aspect.MAGIC, 2), new ThaumcraftApi.EntityTagsNBT[0]);
    }

    private static void registerItemAspects() {
        ThaumcraftApi.registerObjectTag("stone", new AspectList().add(Aspect.EARTH, 2));
        ThaumcraftApi.registerObjectTag("cobblestone", new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag("logWood", new AspectList().add(Aspect.TREE, 4));
        ThaumcraftApi.registerObjectTag("plankWood", new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag("slabWood", new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag("stairWood", new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag("stickWood", new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag("treeSapling", new AspectList().add(Aspect.TREE, 1).add(Aspect.PLANT, 2));
        ThaumcraftApi.registerObjectTag("treeLeaves", new AspectList().add(Aspect.PLANT, 1));
        for (int i = 0; i < 16; ++i) {
            ThaumcraftApi.registerObjectTag(dyes[i], new AspectList().add(Aspect.SENSES, 1));
        }
        ThaumcraftApi.registerObjectTag("oreLapis", new AspectList().add(Aspect.EARTH, 1).add(Aspect.SENSES, 3));
        ThaumcraftApi.registerObjectTag("oreDiamond", new AspectList().add(Aspect.EARTH, 1).add(Aspect.GREED, 3).add(Aspect.CRYSTAL, 3));
        ThaumcraftApi.registerObjectTag("gemDiamond", new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag("oreRedstone", new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENERGY, 2).add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.lit_redstone_ore), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENERGY, 3).add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerObjectTag("oreEmerald", new AspectList().add(Aspect.EARTH, 1).add(Aspect.GREED, 4).add(Aspect.CRYSTAL, 3));
        ThaumcraftApi.registerObjectTag("gemEmerald", new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.GREED, 5));
        ThaumcraftApi.registerObjectTag("oreQuartz", new AspectList().add(Aspect.EARTH, 1).add(Aspect.CRYSTAL, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.quartz), new AspectList().add(Aspect.CRYSTAL, 1).add(Aspect.ENERGY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.gold_nugget), new AspectList().add(Aspect.METAL, 1));
        ThaumcraftApi.registerObjectTag("nuggetIron", new AspectList().add(Aspect.METAL, 1));
        ThaumcraftApi.registerObjectTag("oreIron", new AspectList().add(Aspect.EARTH, 1).add(Aspect.METAL, 3));
        ThaumcraftApi.registerObjectTag("dustIron", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.iron_ingot), new AspectList().add(Aspect.METAL, 4));
        ThaumcraftApi.registerObjectTag("oreGold", new AspectList().add(Aspect.EARTH, 1).add(Aspect.METAL, 2).add(Aspect.GREED, 1));
        ThaumcraftApi.registerObjectTag("dustGold", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.GREED, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.gold_ingot), new AspectList().add(Aspect.METAL, 3).add(Aspect.GREED, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.coal_ore), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENERGY, 2).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.coal, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ENERGY, 2).add(Aspect.FIRE, 2));
        ThaumcraftApi.registerObjectTag("dustRedstone", new AspectList().add(Aspect.ENERGY, 2).add(Aspect.MECHANISM, 1));
        ThaumcraftApi.registerObjectTag("dustGlowstone", new AspectList().add(Aspect.SENSES, 1).add(Aspect.LIGHT, 2));
        ThaumcraftApi.registerObjectTag("glowstone", new AspectList().add(Aspect.SENSES, 3).add(Aspect.LIGHT, 10));
        if (Config.foundCopperIngot) {
            ThaumcraftApi.registerObjectTag("nuggetCopper", new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag("ingotCopper", new AspectList().add(Aspect.METAL, 3).add(Aspect.EXCHANGE, 1));
            ThaumcraftApi.registerObjectTag("dustCopper", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.EXCHANGE, 1));
            ThaumcraftApi.registerObjectTag("oreCopper", new AspectList().add(Aspect.METAL, 2).add(Aspect.EARTH, 1).add(Aspect.EXCHANGE, 1));
            ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 17), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 5).add(Aspect.EARTH, 1).add(Aspect.EXCHANGE, 2));
        }
        if (Config.foundTinIngot) {
            ThaumcraftApi.registerObjectTag("nuggetTin", new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag("ingotTin", new AspectList().add(Aspect.METAL, 3).add(Aspect.CRYSTAL, 1));
            ThaumcraftApi.registerObjectTag("dustTin", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.CRYSTAL, 1));
            ThaumcraftApi.registerObjectTag("oreTin", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENTROPY, 1).add(Aspect.CRYSTAL, 1));
            ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 18), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 5).add(Aspect.EARTH, 1).add(Aspect.CRYSTAL, 2));
        }
        if (Config.foundSilverIngot) {
            ThaumcraftApi.registerObjectTag("nuggetSilver", new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag("ingotSilver", new AspectList().add(Aspect.METAL, 3).add(Aspect.GREED, 1));
            ThaumcraftApi.registerObjectTag("dustSilver", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.GREED, 1));
            ThaumcraftApi.registerObjectTag("oreSilver", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENTROPY, 1).add(Aspect.GREED, 1));
            ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 19), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 5).add(Aspect.EARTH, 1).add(Aspect.GREED, 2));
        }
        if (Config.foundLeadIngot) {
            ThaumcraftApi.registerObjectTag("nuggetLead", new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag("ingotLead", new AspectList().add(Aspect.METAL, 3).add(Aspect.ORDER, 1));
            ThaumcraftApi.registerObjectTag("dustLead", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.ORDER, 1));
            ThaumcraftApi.registerObjectTag("oreLead", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENTROPY, 1).add(Aspect.ORDER, 1));
            ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 20), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 5).add(Aspect.EARTH, 1).add(Aspect.ORDER, 2));
        }
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.bedrock), new AspectList().add(Aspect.VOID, 16).add(Aspect.ENTROPY, 16).add(Aspect.EARTH, 16).add(Aspect.DARKNESS, 16));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.dirt, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.dirt, 1, 2), new AspectList().add(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.farmland, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.HARVEST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.sand, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.grass), new AspectList().add(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.clay_ball, 1, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.end_stone), new AspectList().add(Aspect.EARTH, 1).add(Aspect.DARKNESS, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.gravel), new AspectList().add(Aspect.EARTH, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.mycelium), new AspectList().add(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.clay, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 3).add(Aspect.WATER, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.hardened_clay, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 4).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.stained_hardened_clay, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 3).add(Aspect.FIRE, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.brick, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.netherbrick, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.soul_sand, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.TRAP, 1).add(Aspect.SOUL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.netherrack, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.nether_brick), new AspectList().add(Aspect.EARTH, 2).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.glass, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.stained_glass, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.mossy_cobblestone, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.PLANT, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.obsidian, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 2).add(Aspect.FIRE, 2).add(Aspect.DARKNESS, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.monster_egg, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 2).add(Aspect.BEAST, 1).add(Aspect.TRAP, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.stonebrick, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.stonebrick, 1, 1), new AspectList(new ItemStack(Blocks.stonebrick)).remove(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.stonebrick, 1, 2), new AspectList(new ItemStack(Blocks.stonebrick)).remove(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.stonebrick, 1, 3), new AspectList(new ItemStack(Blocks.stonebrick)).remove(Aspect.EARTH, 1).add(Aspect.ORDER, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.sandstone, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).remove(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.sandstone, 1, 1), new AspectList(new ItemStack(Blocks.sandstone)).remove(Aspect.EARTH, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.sandstone, 1, 2), new AspectList(new ItemStack(Blocks.sandstone)).remove(Aspect.EARTH, 1).add(Aspect.ORDER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.tallgrass, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.double_plant, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.waterlily, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 2).add(Aspect.WATER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.deadbush, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.vine, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.wheat_seeds, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.melon_seeds, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.pumpkin_seeds, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.melon, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.nether_wart), new AspectList().add(Aspect.PLANT, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.red_flower, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.yellow_flower, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.cactus), new AspectList().add(Aspect.PLANT, 3).add(Aspect.WATER, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.brown_mushroom), new AspectList().add(Aspect.PLANT, 1).add(Aspect.DARKNESS, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.red_mushroom), new AspectList().add(Aspect.PLANT, 1).add(Aspect.DARKNESS, 1).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.brown_mushroom_block, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 2).add(Aspect.DARKNESS, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.red_mushroom_block, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 2).add(Aspect.DARKNESS, 1).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.reeds), new AspectList().add(Aspect.PLANT, 1).add(Aspect.WATER, 1).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.wheat), new AspectList().add(Aspect.CROP, 2).add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.apple), new AspectList().add(Aspect.CROP, 2).add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.carrot), new AspectList().add(Aspect.CROP, 1).add(Aspect.HUNGER, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.potato), new AspectList().add(Aspect.CROP, 1).add(Aspect.HUNGER, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.baked_potato), new AspectList().add(Aspect.CROP, 1).add(Aspect.HUNGER, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.poisonous_potato), new AspectList().add(Aspect.CROP, 1).add(Aspect.POISON, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.pumpkin, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CROP, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.melon_block, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CROP, 2).remove(Aspect.HUNGER, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.name_tag, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MIND, 2).add(Aspect.BEAST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.iron_horse_armor, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ARMOR, 2).add(Aspect.BEAST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.golden_horse_armor, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ARMOR, 4).add(Aspect.BEAST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.diamond_horse_armor, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ARMOR, 6).add(Aspect.BEAST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.fire, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.water, 1, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.lava, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 3).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.ice, 1, Short.MAX_VALUE), new AspectList().add(Aspect.COLD, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.packed_ice, 1, Short.MAX_VALUE), new AspectList().add(Aspect.COLD, 3).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.snowball, 1, Short.MAX_VALUE), new AspectList().add(Aspect.COLD, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.cookie, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.potionitem), new AspectList().add(Aspect.WATER, 1).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.torch, 1, Short.MAX_VALUE), new AspectList().add(Aspect.LIGHT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.web, 1, Short.MAX_VALUE), new AspectList().add(Aspect.TRAP, 2).add(Aspect.CLOTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.flint, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.TOOL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.string, 1, Short.MAX_VALUE), new AspectList().add(Aspect.BEAST, 1).add(Aspect.CLOTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.slime_ball), new AspectList().add(Aspect.SLIME, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.leather, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CLOTH, 2).add(Aspect.BEAST, 1).add(Aspect.ARMOR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.rotten_flesh, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MAN, 1).add(Aspect.FLESH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.feather, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLIGHT, 2).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.bone, 1, Short.MAX_VALUE), new AspectList().add(Aspect.DEATH, 2).add(Aspect.FLESH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.egg, 1, Short.MAX_VALUE), new AspectList().add(Aspect.SLIME, 1).add(Aspect.LIFE, 1).add(Aspect.BEAST, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.spider_eye, 1, Short.MAX_VALUE), new AspectList().add(Aspect.SENSES, 2).add(Aspect.BEAST, 2).add(Aspect.POISON, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.gunpowder, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4).add(Aspect.ENTROPY, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.wool, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CLOTH, 4).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.fish, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLESH, 3).add(Aspect.LIFE, 1).add(Aspect.WATER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.cooked_fished, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 1).add(Aspect.FLESH, 4).add(Aspect.HUNGER, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.chicken, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLESH, 3).add(Aspect.LIFE, 2).add(Aspect.BEAST, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.cooked_chicken, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 1).add(Aspect.FLESH, 4).add(Aspect.HUNGER, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.porkchop, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLESH, 3).add(Aspect.LIFE, 1).add(Aspect.BEAST, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.cooked_porkchop, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 1).add(Aspect.FLESH, 3).add(Aspect.HUNGER, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.beef, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLESH, 4).add(Aspect.LIFE, 2).add(Aspect.BEAST, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.cooked_beef, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 1).add(Aspect.FLESH, 4).add(Aspect.HUNGER, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.blaze_rod, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4).add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.saddle, 1, Short.MAX_VALUE), new AspectList().add(Aspect.BEAST, 2).add(Aspect.CLOTH, 3).add(Aspect.TRAVEL, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.ender_pearl, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.MAGIC, 2).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.ghast_tear, 1, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 1).add(Aspect.UNDEAD, 4).add(Aspect.SOUL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.skull, 1, 0), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.UNDEAD, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.skull, 1, 1), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.UNDEAD, 4).add(Aspect.POISON, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.skull, 1, 2), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.FLESH, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.skull, 1, 3), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.MAN, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.skull, 1, 4), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.ENTROPY, 2).add(Aspect.FIRE, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_11), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_13), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.WATER, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_cat), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.BEAST, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_chirp), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.EARTH, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_far), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.ELDRITCH, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_mall), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.MAN, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_mellohi), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.CRAFT, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_stal), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.DARKNESS, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_strad), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.MECHANISM, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_ward), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.MAGIC, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_blocks), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.TOOL, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.record_wait), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.TRAP, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.nether_star), new AspectList().add(Aspect.ELDRITCH, 8).add(Aspect.MAGIC, 8).add(Aspect.ORDER, 8).add(Aspect.LIGHT, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.chainmail_helmet, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.chainmail_chestplate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 12));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.chainmail_leggings, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 11));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.chainmail_boots, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 7));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.paper), new AspectList().add(Aspect.MIND, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.book), new AspectList().add(Aspect.MIND, 3));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Item)Items.enchanted_book), new AspectList(new ItemStack(Items.book)));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.bookshelf), new AspectList().add(Aspect.MIND, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.dragon_egg), new AspectList().add(Aspect.ELDRITCH, 8).add(Aspect.BEAST, 8).add(Aspect.MAGIC, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.portal, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.end_portal, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.end_portal_frame, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.MECHANISM, 4).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.mob_spawner, 1, Short.MAX_VALUE), new AspectList().add(Aspect.BEAST, 4).add(Aspect.TRAVEL, 4).add(Aspect.UNDEAD, 4).add(Aspect.MAGIC, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.ender_eye), new AspectList().add(Aspect.SENSES, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.arrow), new AspectList().add(Aspect.WEAPON, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.glass_bottle), new AspectList().add(Aspect.VOID, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.chest, 1, Short.MAX_VALUE), new AspectList().add(Aspect.VOID, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.golden_apple, 1, 0), new AspectList().add(Aspect.MAGIC, 2).add(Aspect.HEAL, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.golden_apple, 1, 1), new AspectList().add(Aspect.MAGIC, 4).add(Aspect.HEAL, 8));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.bowl), new AspectList().add(Aspect.VOID, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.mushroom_stew), new AspectList().add(Aspect.HUNGER, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.minecart), new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.iron_door), new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.MOTION, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.wooden_door), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.MOTION, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.boat), new AspectList().add(Aspect.WATER, 4).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.flint_and_steel, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Item)Items.fishing_rod, 1, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 1).add(Aspect.TOOL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.bucket), new AspectList().add(Aspect.METAL, 8).add(Aspect.VOID, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.water_bucket), new AspectList(new ItemStack(Items.bucket)).add(Aspect.WATER, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.lava_bucket), new AspectList(new ItemStack(Items.bucket)).add(Aspect.FIRE, 4).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.milk_bucket), new AspectList(new ItemStack(Items.bucket)).add(Aspect.HUNGER, 2).add(Aspect.HEAL, 2).add(Aspect.WATER, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.cake, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 4).add(Aspect.HUNGER, 4).add(Aspect.LIFE, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.brewing_stand), new AspectList().add(Aspect.CRAFT, 2).add(Aspect.WATER, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.stone_button), new AspectList().add(Aspect.MECHANISM, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.rail, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 1).add(Aspect.TRAVEL, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.detector_rail, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.golden_rail, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.ENERGY, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.activator_rail, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.fence_gate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.TRAVEL, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.wooden_pressure_plate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.stone_pressure_plate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.light_weighted_pressure_plate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.heavy_weighted_pressure_plate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.lever, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.redstone_torch, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.piston, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.MOTION, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.sticky_piston, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.MOTION, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.jukebox), new AspectList().add(Aspect.SENSES, 4).add(Aspect.MECHANISM, 2).add(Aspect.AIR, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.noteblock), new AspectList().add(Aspect.SENSES, 4).add(Aspect.MECHANISM, 1).add(Aspect.AIR, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.trapdoor, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MOTION, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.lit_furnace, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.furnace, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.enchanting_table), new AspectList().add(Aspect.MAGIC, 8).add(Aspect.CRAFT, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.crafting_table), new AspectList().add(Aspect.CRAFT, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.clock), new AspectList().add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.anvil), new int[]{0, 1, 2}, new AspectList().add(Aspect.METAL, 64).add(Aspect.CRAFT, 2).add(Aspect.TOOL, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.beacon), new AspectList().add(Aspect.AURA, 2).add(Aspect.MAGIC, 2).add(Aspect.EXCHANGE, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.wooden_button, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.carrot_on_a_stick, 1, Short.MAX_VALUE), new AspectList().add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.flower_pot), new AspectList().add(Aspect.VOID, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.golden_carrot), new AspectList().add(Aspect.SENSES, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.ender_chest, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.EXCHANGE, 2).merge(Aspect.TRAVEL, 2).merge(Aspect.VOID, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.hopper, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.MECHANISM, 1).merge(Aspect.EXCHANGE, 1).merge(Aspect.VOID, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.dropper, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.MECHANISM, 1).merge(Aspect.EXCHANGE, 1).merge(Aspect.VOID, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.dispenser, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.MECHANISM, 1).merge(Aspect.EXCHANGE, 1).merge(Aspect.VOID, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.tripwire_hook, 1, Short.MAX_VALUE), new AspectList().add(Aspect.SENSES, 1).add(Aspect.MECHANISM, 1).add(Aspect.TRAP, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.daylight_detector, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.SENSES, 2).merge(Aspect.LIGHT, 3).merge(Aspect.MECHANISM, 3));
        LinkedHashMap<List, Integer> lhm = new LinkedHashMap<List, Integer>();
        for (int var4 = 1; var4 <= Short.MAX_VALUE; ++var4) {
            List var5 = PotionHelper.getPotionEffects((int)var4, (boolean)false);
            if (var5 == null || var5.isEmpty()) continue;
            lhm.put(var5, var4);
        }
        Iterator var6 = lhm.values().iterator();
        while (var6.hasNext()) {
            int var7 = (Integer)var6.next();
            ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.potionitem, 1, var7), new AspectList(new ItemStack((Item)Items.potionitem)));
        }
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(ConfigBlocks.blockTable), new AspectList().add(Aspect.TOOL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTable, 1, 15), new AspectList(new ItemStack(ConfigBlocks.blockTable)).add(Aspect.CRAFT, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTable, 1, 2), new AspectList(new ItemStack(ConfigBlocks.blockTable)).add(Aspect.MIND, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 16), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 6).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 31), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 4).add(Aspect.EARTH, 1).add(Aspect.GREED, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 21), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 4).add(Aspect.EARTH, 1).add(Aspect.EXCHANGE, 4).add(Aspect.POISON, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 5), new AspectList().add(Aspect.METAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 6), new AspectList().add(Aspect.METAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 0), new AspectList().add(Aspect.EARTH, 1).add(Aspect.METAL, 2).add(Aspect.EXCHANGE, 2).add(Aspect.POISON, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 7), new AspectList().add(Aspect.EARTH, 1).add(Aspect.TRAP, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 1), new AspectList().add(Aspect.EARTH, 1).add(Aspect.AIR, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 2), new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 3), new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 4), new AspectList().add(Aspect.EARTH, 1).add(Aspect.EARTH, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 5), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ORDER, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 6), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaint, 1, 0), new AspectList().add(Aspect.TREE, 1).add(Aspect.TAINT, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaint, 1, 1), new AspectList().add(Aspect.EARTH, 1).add(Aspect.TAINT, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 0), new AspectList().add(Aspect.LIFE, 1).add(Aspect.TAINT, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 1), new AspectList().add(Aspect.PLANT, 1).add(Aspect.TAINT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 2), new AspectList().add(Aspect.PLANT, 1).add(Aspect.TAINT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 3), new AspectList().add(Aspect.BEAST, 1).add(Aspect.PLANT, 1).add(Aspect.TAINT, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 4), new AspectList().add(Aspect.BEAST, 1).add(Aspect.PLANT, 1).add(Aspect.TAINT, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCosmeticSolid), new AspectList().add(Aspect.EARTH, 4).add(Aspect.DARKNESS, 2).add(Aspect.ELDRITCH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0), new AspectList().add(Aspect.TREE, 3).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMagicalLog, 1, 1), new AspectList().add(Aspect.TREE, 3).add(Aspect.MAGIC, 1).add(Aspect.ORDER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMagicalLeaves, 1, 0), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMagicalLeaves, 1, 1), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 0), new AspectList().add(Aspect.PLANT, 2).add(Aspect.TREE, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 1), new AspectList().add(Aspect.PLANT, 2).add(Aspect.TREE, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 2), new AspectList().add(Aspect.PLANT, 2).add(Aspect.EXCHANGE, 2).add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 3), new AspectList().add(Aspect.PLANT, 2).add(Aspect.FIRE, 2).add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 5), new AspectList().add(Aspect.PLANT, 2).add(Aspect.POISON, 1).add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), new AspectList().add(Aspect.EARTH, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), new AspectList().add(Aspect.EARTH, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 3), new AspectList().add(Aspect.METAL, 3).add(Aspect.POISON, 1).add(Aspect.EXCHANGE, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemZombieBrain), new AspectList().add(Aspect.FLESH, 2).add(Aspect.MIND, 4).add(Aspect.UNDEAD, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 6), new AspectList().add(Aspect.TRAP, 2).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 9), new AspectList().add(Aspect.MIND, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 11), new AspectList().add(Aspect.TAINT, 3).add(Aspect.SLIME, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 12), new AspectList().add(Aspect.TAINT, 2).add(Aspect.GREED, 1).add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 18), new AspectList().add(Aspect.GREED, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemLootbag, 1, 0), new AspectList().add(Aspect.GREED, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemLootbag, 1, 1), new AspectList().add(Aspect.GREED, 16));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemLootbag, 1, 2), new AspectList().add(Aspect.GREED, 32));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNuggetBeef, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNuggetChicken, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNuggetPork, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNuggetFish, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(ConfigItems.itemTripleMeatTreat, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HEAL, 1).remove(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 0), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.AIR, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 1), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.FIRE, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 2), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.WATER, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 3), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.EARTH, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 4), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.ORDER, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 5), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.ENTROPY, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 14), new AspectList(new ItemStack(ConfigItems.itemShard, 1, 6)).add(Aspect.MAGIC, 2).remove(Aspect.CRYSTAL));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMetalDevice), new AspectList(new ItemStack(Items.cauldron, 1, Short.MAX_VALUE)).add(Aspect.CRAFT, 4).add(Aspect.MAGIC, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCandle), new AspectList().add(Aspect.LIGHT, 2).add(Aspect.FLESH, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockAiry, 1, 2), new AspectList().add(Aspect.LIGHT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockAiry, 1, 3), new AspectList().add(Aspect.LIGHT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemThaumonomicon, 1, Short.MAX_VALUE), new AspectList(new ItemStack(Blocks.bookshelf)).add(Aspect.MAGIC, 2).merge(Aspect.MIND, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockAlchemyFurnace, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MAGIC, 8).add(Aspect.WATER, 8).add(Aspect.CRAFT, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemEssence, 1, 0), new AspectList().add(Aspect.VOID, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemEssence, 1, 1), new AspectList());
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemWispEssence, 1, 0), new AspectList().add(Aspect.AURA, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemCrystalEssence, 1, 0), new AspectList());
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(ConfigItems.itemPrimalArrow), new AspectList().add(Aspect.WEAPON, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(ConfigItems.itemGoggles, 1, Short.MAX_VALUE), new AspectList().add(Aspect.SENSES, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 1), new AspectList().add(Aspect.SENSES, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemBaubleBlanks, 1, 3), new AspectList().add(Aspect.MAGIC, 5));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemFocusPech), new AspectList().add(Aspect.MAGIC, 5).add(Aspect.POISON, 5).add(Aspect.ENTROPY, 5).add(Aspect.ELDRITCH, 5).add(Aspect.WEAPON, 5));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemChestCultistPlate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 5).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemChestCultistRobe, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 3).add(Aspect.CLOTH, 2).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemChestCultistLeaderPlate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 5).add(Aspect.ELDRITCH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemLegsCultistPlate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 5).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemLegsCultistLeaderPlate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 5).add(Aspect.ELDRITCH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemLegsCultistRobe, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 3).add(Aspect.CLOTH, 2).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemHelmetCultistPlate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 5).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemHelmetCultistLeaderPlate, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 5).add(Aspect.ELDRITCH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemHelmetCultistRobe, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 3).add(Aspect.CLOTH, 2).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemBootsCultist, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 4).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 8), new AspectList().add(Aspect.ELDRITCH, 1).add(Aspect.TREE, 2).add(Aspect.CLOTH, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemEldritchObject, 1, 0), new AspectList().add(Aspect.ELDRITCH, 5).add(Aspect.AURA, 3).add(Aspect.MAGIC, 3).add(Aspect.SENSES, 3).add(Aspect.SOUL, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemEldritchObject, 1, 1), new AspectList().add(Aspect.MIND, 5).add(Aspect.MAGIC, 3).add(Aspect.ELDRITCH, 3).add(Aspect.SOUL, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemEldritchObject, 1, 2), new AspectList().add(Aspect.TRAP, 4).add(Aspect.MIND, 4).add(Aspect.MECHANISM, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemEldritchObject, 1, 3), new AspectList().add(Aspect.AIR, 16).add(Aspect.EARTH, 16).add(Aspect.FIRE, 16).add(Aspect.WATER, 16).add(Aspect.ORDER, 16).add(Aspect.ENTROPY, 16));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockEldritch, 1, Short.MAX_VALUE), new AspectList().add(Aspect.VOID, 8).add(Aspect.ELDRITCH, 8).add(Aspect.SENSES, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockEldritchPortal), new AspectList().add(Aspect.VOID, 8).add(Aspect.ELDRITCH, 8).add(Aspect.TRAVEL, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockEldritch, 1, 3), new AspectList().add(Aspect.VOID, 4).add(Aspect.ELDRITCH, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockEldritch, 1, 4), new AspectList().add(Aspect.LIGHT, 1).add(Aspect.EARTH, 1).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockEldritch, 1, 5), new AspectList().add(Aspect.MIND, 2).add(Aspect.EARTH, 1).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockEldritch, 1, 6), new AspectList().add(Aspect.METAL, 2).add(Aspect.MECHANISM, 2).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 11), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 12), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ELDRITCH, 1));
    }
}

